/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DelegationStatus {
    IN_PROGRESS("IN_PROGRESS"),
    UNDER_REVIEW("UNDER_REVIEW"),
    COMPLETE("COMPLETE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DelegationStatus> VALUE_MAP;
    private final String value;

    private DelegationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DelegationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DelegationStatus> knownValues() {
        EnumSet<DelegationStatus> knownValues = EnumSet.allOf(DelegationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DelegationStatus.class, DelegationStatus::toString);
    }
}

