/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentsResponse;

public class ListAssessmentsIterable
implements SdkIterable<ListAssessmentsResponse> {
    private final AuditManagerClient client;
    private final ListAssessmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssessmentsIterable(AuditManagerClient client, ListAssessmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssessmentsResponseFetcher();
    }

    public Iterator<ListAssessmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAssessmentsResponseFetcher
    implements SyncPageFetcher<ListAssessmentsResponse> {
        private ListAssessmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssessmentsResponse nextPage(ListAssessmentsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentsIterable.this.client.listAssessments(ListAssessmentsIterable.this.firstRequest);
            }
            return ListAssessmentsIterable.this.client.listAssessments((ListAssessmentsRequest)((Object)ListAssessmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

