/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about whether the result of a previous query was reused.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultReuseInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResultReuseInformation.Builder, ResultReuseInformation> {
    private static final SdkField<Boolean> REUSED_PREVIOUS_RESULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReusedPreviousResult").getter(getter(ResultReuseInformation::reusedPreviousResult))
            .setter(setter(Builder::reusedPreviousResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReusedPreviousResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REUSED_PREVIOUS_RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean reusedPreviousResult;

    private ResultReuseInformation(BuilderImpl builder) {
        this.reusedPreviousResult = builder.reusedPreviousResult;
    }

    /**
     * <p>
     * True if a previous query result was reused; false if the result was generated from a new run of the query.
     * </p>
     * 
     * @return True if a previous query result was reused; false if the result was generated from a new run of the
     *         query.
     */
    public final Boolean reusedPreviousResult() {
        return reusedPreviousResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reusedPreviousResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultReuseInformation)) {
            return false;
        }
        ResultReuseInformation other = (ResultReuseInformation) obj;
        return Objects.equals(reusedPreviousResult(), other.reusedPreviousResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultReuseInformation").add("ReusedPreviousResult", reusedPreviousResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReusedPreviousResult":
            return Optional.ofNullable(clazz.cast(reusedPreviousResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultReuseInformation, T> g) {
        return obj -> g.apply((ResultReuseInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultReuseInformation> {
        /**
         * <p>
         * True if a previous query result was reused; false if the result was generated from a new run of the query.
         * </p>
         * 
         * @param reusedPreviousResult
         *        True if a previous query result was reused; false if the result was generated from a new run of the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reusedPreviousResult(Boolean reusedPreviousResult);
    }

    static final class BuilderImpl implements Builder {
        private Boolean reusedPreviousResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultReuseInformation model) {
            reusedPreviousResult(model.reusedPreviousResult);
        }

        public final Boolean getReusedPreviousResult() {
            return reusedPreviousResult;
        }

        public final void setReusedPreviousResult(Boolean reusedPreviousResult) {
            this.reusedPreviousResult = reusedPreviousResult;
        }

        @Override
        public final Builder reusedPreviousResult(Boolean reusedPreviousResult) {
            this.reusedPreviousResult = reusedPreviousResult;
            return this;
        }

        @Override
        public ResultReuseInformation build() {
            return new ResultReuseInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
