/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex structure that lists the zonal shifts for a managed resource and their statuses for the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZonalShiftInResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ZonalShiftInResource.Builder, ZonalShiftInResource> {
    private static final SdkField<String> APPLIED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appliedStatus").getter(getter(ZonalShiftInResource::appliedStatusAsString))
            .setter(setter(Builder::appliedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedStatus").build()).build();

    private static final SdkField<String> AWAY_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awayFrom").getter(getter(ZonalShiftInResource::awayFrom)).setter(setter(Builder::awayFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awayFrom").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(ZonalShiftInResource::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiryTime").getter(getter(ZonalShiftInResource::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiryTime").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(ZonalShiftInResource::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ZonalShiftInResource::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> ZONAL_SHIFT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zonalShiftId").getter(getter(ZonalShiftInResource::zonalShiftId)).setter(setter(Builder::zonalShiftId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShiftId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(APPLIED_STATUS_FIELD, AWAY_FROM_FIELD, COMMENT_FIELD, EXPIRY_TIME_FIELD,
                    RESOURCE_IDENTIFIER_FIELD, START_TIME_FIELD, ZONAL_SHIFT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appliedStatus;

    private final String awayFrom;

    private final String comment;

    private final Instant expiryTime;

    private final String resourceIdentifier;

    private final Instant startTime;

    private final String zonalShiftId;

    private ZonalShiftInResource(BuilderImpl builder) {
        this.appliedStatus = builder.appliedStatus;
        this.awayFrom = builder.awayFrom;
        this.comment = builder.comment;
        this.expiryTime = builder.expiryTime;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.startTime = builder.startTime;
        this.zonalShiftId = builder.zonalShiftId;
    }

    /**
     * <p>
     * An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values: <code>APPLIED</code>
     * or <code>NOT_APPLIED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appliedStatus}
     * will return {@link AppliedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appliedStatusAsString}.
     * </p>
     * 
     * @return An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values:
     *         <code>APPLIED</code> or <code>NOT_APPLIED</code>.
     * @see AppliedStatus
     */
    public final AppliedStatus appliedStatus() {
        return AppliedStatus.fromValue(appliedStatus);
    }

    /**
     * <p>
     * An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values: <code>APPLIED</code>
     * or <code>NOT_APPLIED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appliedStatus}
     * will return {@link AppliedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appliedStatusAsString}.
     * </p>
     * 
     * @return An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values:
     *         <code>APPLIED</code> or <code>NOT_APPLIED</code>.
     * @see AppliedStatus
     */
    public final String appliedStatusAsString() {
        return appliedStatus;
    }

    /**
     * <p>
     * The Availability Zone that traffic is moved away from for a resource when you start a zonal shift. Until the
     * zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones in
     * the AWS Region.
     * </p>
     * 
     * @return The Availability Zone that traffic is moved away from for a resource when you start a zonal shift. Until
     *         the zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability
     *         Zones in the AWS Region.
     */
    public final String awayFrom() {
        return awayFrom;
    }

    /**
     * <p>
     * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
     * maintained. That is, a new comment overwrites any existing comment string.
     * </p>
     * 
     * @return A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history
     *         is maintained. That is, a new comment overwrites any existing comment string.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The expiry time (expiration time) for the zonal shift. A zonal shift is temporary and must be set to expire when
     * you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72 hours).
     * However, you can update a zonal shift to set a new expiration at any time.
     * </p>
     * <p>
     * When you start a zonal shift, you specify how long you want it to be active, which Route 53 ARC converts to an
     * expiry time (expiration time). You can cancel a zonal shift, for example, if you're ready to restore traffic to
     * the Availability Zone. Or you can update the zonal shift to specify another length of time to expire in.
     * </p>
     * 
     * @return The expiry time (expiration time) for the zonal shift. A zonal shift is temporary and must be set to
     *         expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of
     *         three days (72 hours). However, you can update a zonal shift to set a new expiration at any time. </p>
     *         <p>
     *         When you start a zonal shift, you specify how long you want it to be active, which Route 53 ARC converts
     *         to an expiry time (expiration time). You can cancel a zonal shift, for example, if you're ready to
     *         restore traffic to the Availability Zone. Or you can update the zonal shift to specify another length of
     *         time to expire in.
     */
    public final Instant expiryTime() {
        return expiryTime;
    }

    /**
     * <p>
     * The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN) for
     * the resource.
     * </p>
     * <p>
     * At this time, you can only start a zonal shift for Network Load Balancers and Application Load Balancers with
     * cross-zone load balancing turned off.
     * </p>
     * 
     * @return The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name
     *         (ARN) for the resource.</p>
     *         <p>
     *         At this time, you can only start a zonal shift for Network Load Balancers and Application Load Balancers
     *         with cross-zone load balancing turned off.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The time (UTC) when the zonal shift is started.
     * </p>
     * 
     * @return The time (UTC) when the zonal shift is started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The identifier of a zonal shift.
     * </p>
     * 
     * @return The identifier of a zonal shift.
     */
    public final String zonalShiftId() {
        return zonalShiftId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appliedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awayFrom());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(zonalShiftId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalShiftInResource)) {
            return false;
        }
        ZonalShiftInResource other = (ZonalShiftInResource) obj;
        return Objects.equals(appliedStatusAsString(), other.appliedStatusAsString())
                && Objects.equals(awayFrom(), other.awayFrom()) && Objects.equals(comment(), other.comment())
                && Objects.equals(expiryTime(), other.expiryTime())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(zonalShiftId(), other.zonalShiftId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZonalShiftInResource").add("AppliedStatus", appliedStatusAsString()).add("AwayFrom", awayFrom())
                .add("Comment", comment()).add("ExpiryTime", expiryTime()).add("ResourceIdentifier", resourceIdentifier())
                .add("StartTime", startTime()).add("ZonalShiftId", zonalShiftId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appliedStatus":
            return Optional.ofNullable(clazz.cast(appliedStatusAsString()));
        case "awayFrom":
            return Optional.ofNullable(clazz.cast(awayFrom()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "expiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "zonalShiftId":
            return Optional.ofNullable(clazz.cast(zonalShiftId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ZonalShiftInResource, T> g) {
        return obj -> g.apply((ZonalShiftInResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZonalShiftInResource> {
        /**
         * <p>
         * An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values:
         * <code>APPLIED</code> or <code>NOT_APPLIED</code>.
         * </p>
         * 
         * @param appliedStatus
         *        An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values:
         *        <code>APPLIED</code> or <code>NOT_APPLIED</code>.
         * @see AppliedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppliedStatus
         */
        Builder appliedStatus(String appliedStatus);

        /**
         * <p>
         * An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values:
         * <code>APPLIED</code> or <code>NOT_APPLIED</code>.
         * </p>
         * 
         * @param appliedStatus
         *        An <code>appliedStatus</code> for a zonal shift for a resource can have one of two values:
         *        <code>APPLIED</code> or <code>NOT_APPLIED</code>.
         * @see AppliedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppliedStatus
         */
        Builder appliedStatus(AppliedStatus appliedStatus);

        /**
         * <p>
         * The Availability Zone that traffic is moved away from for a resource when you start a zonal shift. Until the
         * zonal shift expires or you cancel it, traffic for the resource is instead moved to other Availability Zones
         * in the AWS Region.
         * </p>
         * 
         * @param awayFrom
         *        The Availability Zone that traffic is moved away from for a resource when you start a zonal shift.
         *        Until the zonal shift expires or you cancel it, traffic for the resource is instead moved to other
         *        Availability Zones in the AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awayFrom(String awayFrom);

        /**
         * <p>
         * A comment that you enter about the zonal shift. Only the latest comment is retained; no comment history is
         * maintained. That is, a new comment overwrites any existing comment string.
         * </p>
         * 
         * @param comment
         *        A comment that you enter about the zonal shift. Only the latest comment is retained; no comment
         *        history is maintained. That is, a new comment overwrites any existing comment string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The expiry time (expiration time) for the zonal shift. A zonal shift is temporary and must be set to expire
         * when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of three days (72
         * hours). However, you can update a zonal shift to set a new expiration at any time.
         * </p>
         * <p>
         * When you start a zonal shift, you specify how long you want it to be active, which Route 53 ARC converts to
         * an expiry time (expiration time). You can cancel a zonal shift, for example, if you're ready to restore
         * traffic to the Availability Zone. Or you can update the zonal shift to specify another length of time to
         * expire in.
         * </p>
         * 
         * @param expiryTime
         *        The expiry time (expiration time) for the zonal shift. A zonal shift is temporary and must be set to
         *        expire when you start the zonal shift. You can initially set a zonal shift to expire in a maximum of
         *        three days (72 hours). However, you can update a zonal shift to set a new expiration at any time. </p>
         *        <p>
         *        When you start a zonal shift, you specify how long you want it to be active, which Route 53 ARC
         *        converts to an expiry time (expiration time). You can cancel a zonal shift, for example, if you're
         *        ready to restore traffic to the Availability Zone. Or you can update the zonal shift to specify
         *        another length of time to expire in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(Instant expiryTime);

        /**
         * <p>
         * The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource Name (ARN)
         * for the resource.
         * </p>
         * <p>
         * At this time, you can only start a zonal shift for Network Load Balancers and Application Load Balancers with
         * cross-zone load balancing turned off.
         * </p>
         * 
         * @param resourceIdentifier
         *        The identifier for the resource to include in a zonal shift. The identifier is the Amazon Resource
         *        Name (ARN) for the resource.</p>
         *        <p>
         *        At this time, you can only start a zonal shift for Network Load Balancers and Application Load
         *        Balancers with cross-zone load balancing turned off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The time (UTC) when the zonal shift is started.
         * </p>
         * 
         * @param startTime
         *        The time (UTC) when the zonal shift is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The identifier of a zonal shift.
         * </p>
         * 
         * @param zonalShiftId
         *        The identifier of a zonal shift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShiftId(String zonalShiftId);
    }

    static final class BuilderImpl implements Builder {
        private String appliedStatus;

        private String awayFrom;

        private String comment;

        private Instant expiryTime;

        private String resourceIdentifier;

        private Instant startTime;

        private String zonalShiftId;

        private BuilderImpl() {
        }

        private BuilderImpl(ZonalShiftInResource model) {
            appliedStatus(model.appliedStatus);
            awayFrom(model.awayFrom);
            comment(model.comment);
            expiryTime(model.expiryTime);
            resourceIdentifier(model.resourceIdentifier);
            startTime(model.startTime);
            zonalShiftId(model.zonalShiftId);
        }

        public final String getAppliedStatus() {
            return appliedStatus;
        }

        public final void setAppliedStatus(String appliedStatus) {
            this.appliedStatus = appliedStatus;
        }

        @Override
        public final Builder appliedStatus(String appliedStatus) {
            this.appliedStatus = appliedStatus;
            return this;
        }

        @Override
        public final Builder appliedStatus(AppliedStatus appliedStatus) {
            this.appliedStatus(appliedStatus == null ? null : appliedStatus.toString());
            return this;
        }

        public final String getAwayFrom() {
            return awayFrom;
        }

        public final void setAwayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
        }

        @Override
        public final Builder awayFrom(String awayFrom) {
            this.awayFrom = awayFrom;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getExpiryTime() {
            return expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getZonalShiftId() {
            return zonalShiftId;
        }

        public final void setZonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
        }

        @Override
        public final Builder zonalShiftId(String zonalShiftId) {
            this.zonalShiftId = zonalShiftId;
            return this;
        }

        @Override
        public ZonalShiftInResource build() {
            return new ZonalShiftInResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
