/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an HTTP data source configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpDataSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpDataSourceConfig.Builder, HttpDataSourceConfig> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(HttpDataSourceConfig::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<AuthorizationConfig> AUTHORIZATION_CONFIG_FIELD = SdkField
            .<AuthorizationConfig> builder(MarshallingType.SDK_POJO).memberName("authorizationConfig")
            .getter(getter(HttpDataSourceConfig::authorizationConfig)).setter(setter(Builder::authorizationConfig))
            .constructor(AuthorizationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            AUTHORIZATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpoint;

    private final AuthorizationConfig authorizationConfig;

    private HttpDataSourceConfig(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.authorizationConfig = builder.authorizationConfig;
    }

    /**
     * <p>
     * The HTTP URL endpoint. You can specify either the domain name or IP, and port combination, and the URL scheme
     * must be HTTP or HTTPS. If you don't specify the port, AppSync uses the default port 80 for the HTTP endpoint and
     * port 443 for HTTPS endpoints.
     * </p>
     * 
     * @return The HTTP URL endpoint. You can specify either the domain name or IP, and port combination, and the URL
     *         scheme must be HTTP or HTTPS. If you don't specify the port, AppSync uses the default port 80 for the
     *         HTTP endpoint and port 443 for HTTPS endpoints.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The authorization configuration in case the HTTP endpoint requires authorization.
     * </p>
     * 
     * @return The authorization configuration in case the HTTP endpoint requires authorization.
     */
    public final AuthorizationConfig authorizationConfig() {
        return authorizationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpDataSourceConfig)) {
            return false;
        }
        HttpDataSourceConfig other = (HttpDataSourceConfig) obj;
        return Objects.equals(endpoint(), other.endpoint()) && Objects.equals(authorizationConfig(), other.authorizationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpDataSourceConfig").add("Endpoint", endpoint())
                .add("AuthorizationConfig", authorizationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "authorizationConfig":
            return Optional.ofNullable(clazz.cast(authorizationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpDataSourceConfig, T> g) {
        return obj -> g.apply((HttpDataSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpDataSourceConfig> {
        /**
         * <p>
         * The HTTP URL endpoint. You can specify either the domain name or IP, and port combination, and the URL scheme
         * must be HTTP or HTTPS. If you don't specify the port, AppSync uses the default port 80 for the HTTP endpoint
         * and port 443 for HTTPS endpoints.
         * </p>
         * 
         * @param endpoint
         *        The HTTP URL endpoint. You can specify either the domain name or IP, and port combination, and the URL
         *        scheme must be HTTP or HTTPS. If you don't specify the port, AppSync uses the default port 80 for the
         *        HTTP endpoint and port 443 for HTTPS endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The authorization configuration in case the HTTP endpoint requires authorization.
         * </p>
         * 
         * @param authorizationConfig
         *        The authorization configuration in case the HTTP endpoint requires authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationConfig(AuthorizationConfig authorizationConfig);

        /**
         * <p>
         * The authorization configuration in case the HTTP endpoint requires authorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizationConfig.Builder} avoiding the
         * need to create one manually via {@link AuthorizationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #authorizationConfig(AuthorizationConfig)}.
         * 
         * @param authorizationConfig
         *        a consumer that will call methods on {@link AuthorizationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationConfig(AuthorizationConfig)
         */
        default Builder authorizationConfig(Consumer<AuthorizationConfig.Builder> authorizationConfig) {
            return authorizationConfig(AuthorizationConfig.builder().applyMutation(authorizationConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private AuthorizationConfig authorizationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpDataSourceConfig model) {
            endpoint(model.endpoint);
            authorizationConfig(model.authorizationConfig);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final AuthorizationConfig.Builder getAuthorizationConfig() {
            return authorizationConfig != null ? authorizationConfig.toBuilder() : null;
        }

        public final void setAuthorizationConfig(AuthorizationConfig.BuilderImpl authorizationConfig) {
            this.authorizationConfig = authorizationConfig != null ? authorizationConfig.build() : null;
        }

        @Override
        public final Builder authorizationConfig(AuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        @Override
        public HttpDataSourceConfig build() {
            return new HttpDataSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
