/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppVisibility;
import software.amazon.awssdk.services.appstream.model.EntitlementAttribute;
import software.amazon.awssdk.services.appstream.model.EntitlementAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entitlement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entitlement> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Entitlement.getter(Entitlement::name)).setter(Entitlement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(Entitlement.getter(Entitlement::stackName)).setter(Entitlement.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Entitlement.getter(Entitlement::description)).setter(Entitlement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> APP_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppVisibility").getter(Entitlement.getter(Entitlement::appVisibilityAsString)).setter(Entitlement.setter(Builder::appVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVisibility").build()}).build();
    private static final SdkField<List<EntitlementAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(Entitlement.getter(Entitlement::attributes)).setter(Entitlement.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitlementAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Entitlement.getter(Entitlement::createdTime)).setter(Entitlement.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Entitlement.getter(Entitlement::lastModifiedTime)).setter(Entitlement.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STACK_NAME_FIELD, DESCRIPTION_FIELD, APP_VISIBILITY_FIELD, ATTRIBUTES_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String stackName;
    private final String description;
    private final String appVisibility;
    private final List<EntitlementAttribute> attributes;
    private final Instant createdTime;
    private final Instant lastModifiedTime;

    private Entitlement(BuilderImpl builder) {
        this.name = builder.name;
        this.stackName = builder.stackName;
        this.description = builder.description;
        this.appVisibility = builder.appVisibility;
        this.attributes = builder.attributes;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String description() {
        return this.description;
    }

    public final AppVisibility appVisibility() {
        return AppVisibility.fromValue(this.appVisibility);
    }

    public final String appVisibilityAsString() {
        return this.appVisibility;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<EntitlementAttribute> attributes() {
        return this.attributes;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entitlement)) {
            return false;
        }
        Entitlement other = (Entitlement)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.appVisibilityAsString(), other.appVisibilityAsString()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"Entitlement").add("Name", (Object)this.name()).add("StackName", (Object)this.stackName()).add("Description", (Object)this.description()).add("AppVisibility", (Object)this.appVisibilityAsString()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AppVisibility": {
                return Optional.ofNullable(clazz.cast(this.appVisibilityAsString()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entitlement, T> g) {
        return obj -> g.apply((Entitlement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String stackName;
        private String description;
        private String appVisibility;
        private List<EntitlementAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Entitlement model) {
            this.name(model.name);
            this.stackName(model.stackName);
            this.description(model.description);
            this.appVisibility(model.appVisibility);
            this.attributes(model.attributes);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAppVisibility() {
            return this.appVisibility;
        }

        public final void setAppVisibility(String appVisibility) {
            this.appVisibility = appVisibility;
        }

        @Override
        public final Builder appVisibility(String appVisibility) {
            this.appVisibility = appVisibility;
            return this;
        }

        @Override
        public final Builder appVisibility(AppVisibility appVisibility) {
            this.appVisibility(appVisibility == null ? null : appVisibility.toString());
            return this;
        }

        public final List<EntitlementAttribute.Builder> getAttributes() {
            List<EntitlementAttribute.Builder> result = EntitlementAttributeListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<EntitlementAttribute.BuilderImpl> attributes) {
            this.attributes = EntitlementAttributeListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<EntitlementAttribute> attributes) {
            this.attributes = EntitlementAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(EntitlementAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<EntitlementAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (EntitlementAttribute)((EntitlementAttribute.Builder)EntitlementAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Entitlement build() {
            return new Entitlement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entitlement> {
        public Builder name(String var1);

        public Builder stackName(String var1);

        public Builder description(String var1);

        public Builder appVisibility(String var1);

        public Builder appVisibility(AppVisibility var1);

        public Builder attributes(Collection<EntitlementAttribute> var1);

        public Builder attributes(EntitlementAttribute ... var1);

        public Builder attributes(Consumer<EntitlementAttribute.Builder> ... var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

