/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appfabric;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.appfabric.model.AccessDeniedException;
import software.amazon.awssdk.services.appfabric.model.AppFabricException;
import software.amazon.awssdk.services.appfabric.model.BatchGetUserAccessTasksRequest;
import software.amazon.awssdk.services.appfabric.model.BatchGetUserAccessTasksResponse;
import software.amazon.awssdk.services.appfabric.model.ConflictException;
import software.amazon.awssdk.services.appfabric.model.ConnectAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.ConnectAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.CreateAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.CreateAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.CreateAppBundleRequest;
import software.amazon.awssdk.services.appfabric.model.CreateAppBundleResponse;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.CreateIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteAppBundleRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteAppBundleResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.DeleteIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.GetAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.GetAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.GetAppBundleRequest;
import software.amazon.awssdk.services.appfabric.model.GetAppBundleResponse;
import software.amazon.awssdk.services.appfabric.model.GetIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.GetIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.model.GetIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.GetIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.InternalServerException;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest;
import software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest;
import software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse;
import software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest;
import software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse;
import software.amazon.awssdk.services.appfabric.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appfabric.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appfabric.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appfabric.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.appfabric.model.StartIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.StartIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.StartUserAccessTasksRequest;
import software.amazon.awssdk.services.appfabric.model.StartUserAccessTasksResponse;
import software.amazon.awssdk.services.appfabric.model.StopIngestionRequest;
import software.amazon.awssdk.services.appfabric.model.StopIngestionResponse;
import software.amazon.awssdk.services.appfabric.model.TagResourceRequest;
import software.amazon.awssdk.services.appfabric.model.TagResourceResponse;
import software.amazon.awssdk.services.appfabric.model.ThrottlingException;
import software.amazon.awssdk.services.appfabric.model.UntagResourceRequest;
import software.amazon.awssdk.services.appfabric.model.UntagResourceResponse;
import software.amazon.awssdk.services.appfabric.model.UpdateAppAuthorizationRequest;
import software.amazon.awssdk.services.appfabric.model.UpdateAppAuthorizationResponse;
import software.amazon.awssdk.services.appfabric.model.UpdateIngestionDestinationRequest;
import software.amazon.awssdk.services.appfabric.model.UpdateIngestionDestinationResponse;
import software.amazon.awssdk.services.appfabric.model.ValidationException;
import software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsIterable;
import software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesIterable;
import software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsIterable;
import software.amazon.awssdk.services.appfabric.paginators.ListIngestionsIterable;

/**
 * Service client for accessing AppFabric. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services AppFabric quickly connects software as a service (SaaS) applications across your organization.
 * This allows IT and security teams to easily manage and secure applications using a standard schema, and employees can
 * complete everyday tasks faster using generative artificial intelligence (AI). You can use these APIs to complete
 * AppFabric tasks, such as setting up audit log ingestions or viewing user access. For more information about
 * AppFabric, including the required permissions to use the service, see the <a
 * href="https://docs.aws.amazon.com/appfabric/latest/adminguide/">Amazon Web Services AppFabric Administration
 * Guide</a>. For more information about using the Command Line Interface (CLI) to manage your AppFabric resources, see
 * the <a href="https://docs.aws.amazon.com/cli/latest/reference/appfabric/index.html">AppFabric section of the CLI
 * Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppFabricClient extends AwsClient {
    String SERVICE_NAME = "appfabric";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appfabric";

    /**
     * <p>
     * Gets user access details in a batch request.
     * </p>
     * <p>
     * This action polls data from the tasks that are kicked off by the <code>StartUserAccessTasks</code> action.
     * </p>
     *
     * @param batchGetUserAccessTasksRequest
     * @return Result of the BatchGetUserAccessTasks operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.BatchGetUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/BatchGetUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetUserAccessTasksResponse batchGetUserAccessTasks(BatchGetUserAccessTasksRequest batchGetUserAccessTasksRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets user access details in a batch request.
     * </p>
     * <p>
     * This action polls data from the tasks that are kicked off by the <code>StartUserAccessTasks</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetUserAccessTasksRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetUserAccessTasksRequest#builder()}
     * </p>
     *
     * @param batchGetUserAccessTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.BatchGetUserAccessTasksRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetUserAccessTasks operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.BatchGetUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/BatchGetUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetUserAccessTasksResponse batchGetUserAccessTasks(
            Consumer<BatchGetUserAccessTasksRequest.Builder> batchGetUserAccessTasksRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return batchGetUserAccessTasks(BatchGetUserAccessTasksRequest.builder().applyMutation(batchGetUserAccessTasksRequest)
                .build());
    }

    /**
     * <p>
     * Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call
     * the APIs of the application.
     * </p>
     *
     * @param connectAppAuthorizationRequest
     * @return Result of the ConnectAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ConnectAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ConnectAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default ConnectAppAuthorizationResponse connectAppAuthorization(ConnectAppAuthorizationRequest connectAppAuthorizationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call
     * the APIs of the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConnectAppAuthorizationRequest.Builder} avoiding
     * the need to create one manually via {@link ConnectAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param connectAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ConnectAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return Result of the ConnectAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ConnectAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ConnectAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default ConnectAppAuthorizationResponse connectAppAuthorization(
            Consumer<ConnectAppAuthorizationRequest.Builder> connectAppAuthorizationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return connectAppAuthorization(ConnectAppAuthorizationRequest.builder().applyMutation(connectAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     *
     * @param createAppAuthorizationRequest
     * @return Result of the CreateAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppAuthorizationResponse createAppAuthorization(CreateAppAuthorizationRequest createAppAuthorizationRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ConflictException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param createAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAppAuthorizationResponse createAppAuthorization(
            Consumer<CreateAppAuthorizationRequest.Builder> createAppAuthorizationRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ConflictException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return createAppAuthorization(CreateAppAuthorizationRequest.builder().applyMutation(createAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Creates an app bundle to collect data from an application using AppFabric.
     * </p>
     *
     * @param createAppBundleRequest
     * @return Result of the CreateAppBundle operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppBundleResponse createAppBundle(CreateAppBundleRequest createAppBundleRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ConflictException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an app bundle to collect data from an application using AppFabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppBundleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAppBundleRequest#builder()}
     * </p>
     *
     * @param createAppBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateAppBundleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAppBundle operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppBundleResponse createAppBundle(Consumer<CreateAppBundleRequest.Builder> createAppBundleRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ConflictException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return createAppBundle(CreateAppBundleRequest.builder().applyMutation(createAppBundleRequest).build());
    }

    /**
     * <p>
     * Creates a data ingestion for an application.
     * </p>
     *
     * @param createIngestionRequest
     * @return Result of the CreateIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIngestionResponse createIngestion(CreateIngestionRequest createIngestionRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ConflictException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data ingestion for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIngestionRequest#builder()}
     * </p>
     *
     * @param createIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateIngestionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateIngestionResponse createIngestion(Consumer<CreateIngestionRequest.Builder> createIngestionRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ConflictException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return createIngestion(CreateIngestionRequest.builder().applyMutation(createIngestionRequest).build());
    }

    /**
     * <p>
     * Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     *
     * @param createIngestionDestinationRequest
     * @return Result of the CreateIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIngestionDestinationResponse createIngestionDestination(
            CreateIngestionDestinationRequest createIngestionDestinationRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param createIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.CreateIngestionDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.CreateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/CreateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIngestionDestinationResponse createIngestionDestination(
            Consumer<CreateIngestionDestinationRequest.Builder> createIngestionDestinationRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ConflictException,
            ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return createIngestionDestination(CreateIngestionDestinationRequest.builder()
                .applyMutation(createIngestionDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes an app authorization. You must delete the associated ingestion before you can delete an app
     * authorization.
     * </p>
     *
     * @param deleteAppAuthorizationRequest
     * @return Result of the DeleteAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppAuthorizationResponse deleteAppAuthorization(DeleteAppAuthorizationRequest deleteAppAuthorizationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an app authorization. You must delete the associated ingestion before you can delete an app
     * authorization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAppAuthorizationResponse deleteAppAuthorization(
            Consumer<DeleteAppAuthorizationRequest.Builder> deleteAppAuthorizationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return deleteAppAuthorization(DeleteAppAuthorizationRequest.builder().applyMutation(deleteAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.
     * </p>
     *
     * @param deleteAppBundleRequest
     * @return Result of the DeleteAppBundle operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppBundleResponse deleteAppBundle(DeleteAppBundleRequest deleteAppBundleRequest)
            throws InternalServerException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppBundleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAppBundleRequest#builder()}
     * </p>
     *
     * @param deleteAppBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteAppBundleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAppBundle operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppBundleResponse deleteAppBundle(Consumer<DeleteAppBundleRequest.Builder> deleteAppBundleRequest)
            throws InternalServerException, ThrottlingException, ConflictException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppFabricException {
        return deleteAppBundle(DeleteAppBundleRequest.builder().applyMutation(deleteAppBundleRequest).build());
    }

    /**
     * <p>
     * Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion
     * destinations before you can delete an app ingestion.
     * </p>
     *
     * @param deleteIngestionRequest
     * @return Result of the DeleteIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIngestionResponse deleteIngestion(DeleteIngestionRequest deleteIngestionRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion
     * destinations before you can delete an app ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIngestionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIngestionRequest#builder()}
     * </p>
     *
     * @param deleteIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteIngestionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteIngestionResponse deleteIngestion(Consumer<DeleteIngestionRequest.Builder> deleteIngestionRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return deleteIngestion(DeleteIngestionRequest.builder().applyMutation(deleteIngestionRequest).build());
    }

    /**
     * <p>
     * Deletes an ingestion destination.
     * </p>
     * <p>
     * This deletes the association between an ingestion and it's destination. It doesn't delete previously ingested
     * data or the storage destination, such as the Amazon S3 bucket where the data is delivered. If the ingestion
     * destination is deleted while the associated ingestion is enabled, the ingestion will fail and is eventually
     * disabled.
     * </p>
     *
     * @param deleteIngestionDestinationRequest
     * @return Result of the DeleteIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIngestionDestinationResponse deleteIngestionDestination(
            DeleteIngestionDestinationRequest deleteIngestionDestinationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ingestion destination.
     * </p>
     * <p>
     * This deletes the association between an ingestion and it's destination. It doesn't delete previously ingested
     * data or the storage destination, such as the Amazon S3 bucket where the data is delivered. If the ingestion
     * destination is deleted while the associated ingestion is enabled, the ingestion will fail and is eventually
     * disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param deleteIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.DeleteIngestionDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.DeleteIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/DeleteIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIngestionDestinationResponse deleteIngestionDestination(
            Consumer<DeleteIngestionDestinationRequest.Builder> deleteIngestionDestinationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return deleteIngestionDestination(DeleteIngestionDestinationRequest.builder()
                .applyMutation(deleteIngestionDestinationRequest).build());
    }

    /**
     * <p>
     * Returns information about an app authorization.
     * </p>
     *
     * @param getAppAuthorizationRequest
     * @return Result of the GetAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppAuthorization" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAppAuthorizationResponse getAppAuthorization(GetAppAuthorizationRequest getAppAuthorizationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an app authorization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link GetAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param getAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return Result of the GetAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppAuthorization" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAppAuthorizationResponse getAppAuthorization(
            Consumer<GetAppAuthorizationRequest.Builder> getAppAuthorizationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return getAppAuthorization(GetAppAuthorizationRequest.builder().applyMutation(getAppAuthorizationRequest).build());
    }

    /**
     * <p>
     * Returns information about an app bundle.
     * </p>
     *
     * @param getAppBundleRequest
     * @return Result of the GetAppBundle operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppBundleResponse getAppBundle(GetAppBundleRequest getAppBundleRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppBundleRequest.Builder} avoiding the need to
     * create one manually via {@link GetAppBundleRequest#builder()}
     * </p>
     *
     * @param getAppBundleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetAppBundleRequest.Builder} to create a request.
     * @return Result of the GetAppBundle operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetAppBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetAppBundle" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAppBundleResponse getAppBundle(Consumer<GetAppBundleRequest.Builder> getAppBundleRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return getAppBundle(GetAppBundleRequest.builder().applyMutation(getAppBundleRequest).build());
    }

    /**
     * <p>
     * Returns information about an ingestion.
     * </p>
     *
     * @param getIngestionRequest
     * @return Result of the GetIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIngestionResponse getIngestion(GetIngestionRequest getIngestionRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngestionRequest.Builder} avoiding the need to
     * create one manually via {@link GetIngestionRequest#builder()}
     * </p>
     *
     * @param getIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetIngestionRequest.Builder} to create a request.
     * @return Result of the GetIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetIngestionResponse getIngestion(Consumer<GetIngestionRequest.Builder> getIngestionRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return getIngestion(GetIngestionRequest.builder().applyMutation(getIngestionRequest).build());
    }

    /**
     * <p>
     * Returns information about an ingestion destination.
     * </p>
     *
     * @param getIngestionDestinationRequest
     * @return Result of the GetIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIngestionDestinationResponse getIngestionDestination(GetIngestionDestinationRequest getIngestionDestinationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an ingestion destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param getIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.GetIngestionDestinationRequest.Builder} to create a
     *        request.
     * @return Result of the GetIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.GetIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/GetIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIngestionDestinationResponse getIngestionDestination(
            Consumer<GetIngestionDestinationRequest.Builder> getIngestionDestinationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return getIngestionDestination(GetIngestionDestinationRequest.builder().applyMutation(getIngestionDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of all app authorizations configured for an app bundle.
     * </p>
     *
     * @param listAppAuthorizationsRequest
     * @return Result of the ListAppAuthorizations operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAuthorizationsResponse listAppAuthorizations(ListAppAuthorizationsRequest listAppAuthorizationsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all app authorizations configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppAuthorizationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppAuthorizationsRequest#builder()}
     * </p>
     *
     * @param listAppAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAppAuthorizations operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAuthorizationsResponse listAppAuthorizations(
            Consumer<ListAppAuthorizationsRequest.Builder> listAppAuthorizationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return listAppAuthorizations(ListAppAuthorizationsRequest.builder().applyMutation(listAppAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all app authorizations configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsIterable responses = client.listAppAuthorizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsIterable responses = client
     *             .listAppAuthorizationsPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsIterable responses = client.listAppAuthorizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAppAuthorizationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAuthorizationsIterable listAppAuthorizationsPaginator(ListAppAuthorizationsRequest listAppAuthorizationsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return new ListAppAuthorizationsIterable(this, listAppAuthorizationsRequest);
    }

    /**
     * <p>
     * Returns a list of all app authorizations configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsIterable responses = client.listAppAuthorizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsIterable responses = client
     *             .listAppAuthorizationsPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppAuthorizationsIterable responses = client.listAppAuthorizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppAuthorizations(software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppAuthorizationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAppAuthorizationsRequest#builder()}
     * </p>
     *
     * @param listAppAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppAuthorizationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAppAuthorizationsIterable listAppAuthorizationsPaginator(
            Consumer<ListAppAuthorizationsRequest.Builder> listAppAuthorizationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return listAppAuthorizationsPaginator(ListAppAuthorizationsRequest.builder().applyMutation(listAppAuthorizationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of app bundles.
     * </p>
     *
     * @param listAppBundlesRequest
     * @return Result of the ListAppBundles operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppBundlesResponse listAppBundles(ListAppBundlesRequest listAppBundlesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of app bundles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppBundlesRequest#builder()}
     * </p>
     *
     * @param listAppBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest.Builder} to create a request.
     * @return Result of the ListAppBundles operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppBundlesResponse listAppBundles(Consumer<ListAppBundlesRequest.Builder> listAppBundlesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return listAppBundles(ListAppBundlesRequest.builder().applyMutation(listAppBundlesRequest).build());
    }

    /**
     * <p>
     * Returns a list of app bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesIterable responses = client.listAppBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesIterable responses = client
     *             .listAppBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesIterable responses = client.listAppBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation.</b>
     * </p>
     *
     * @param listAppBundlesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppBundlesIterable listAppBundlesPaginator(ListAppBundlesRequest listAppBundlesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return new ListAppBundlesIterable(this, listAppBundlesRequest);
    }

    /**
     * <p>
     * Returns a list of app bundles.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesIterable responses = client.listAppBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesIterable responses = client
     *             .listAppBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListAppBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListAppBundlesIterable responses = client.listAppBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAppBundles(software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAppBundlesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAppBundlesRequest#builder()}
     * </p>
     *
     * @param listAppBundlesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListAppBundlesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListAppBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListAppBundles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAppBundlesIterable listAppBundlesPaginator(Consumer<ListAppBundlesRequest.Builder> listAppBundlesRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return listAppBundlesPaginator(ListAppBundlesRequest.builder().applyMutation(listAppBundlesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all ingestion destinations configured for an ingestion.
     * </p>
     *
     * @param listIngestionDestinationsRequest
     * @return Result of the ListIngestionDestinations operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionDestinationsResponse listIngestionDestinations(
            ListIngestionDestinationsRequest listIngestionDestinationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all ingestion destinations configured for an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIngestionDestinationsRequest#builder()}
     * </p>
     *
     * @param listIngestionDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListIngestionDestinations operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionDestinationsResponse listIngestionDestinations(
            Consumer<ListIngestionDestinationsRequest.Builder> listIngestionDestinationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return listIngestionDestinations(ListIngestionDestinationsRequest.builder()
                .applyMutation(listIngestionDestinationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all ingestion destinations configured for an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsIterable responses = client.listIngestionDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsIterable responses = client
     *             .listIngestionDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsIterable responses = client.listIngestionDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIngestionDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionDestinationsIterable listIngestionDestinationsPaginator(
            ListIngestionDestinationsRequest listIngestionDestinationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return new ListIngestionDestinationsIterable(this, listIngestionDestinationsRequest);
    }

    /**
     * <p>
     * Returns a list of all ingestion destinations configured for an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsIterable responses = client.listIngestionDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsIterable responses = client
     *             .listIngestionDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionDestinationsIterable responses = client.listIngestionDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestionDestinations(software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIngestionDestinationsRequest#builder()}
     * </p>
     *
     * @param listIngestionDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionDestinationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestionDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestionDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestionDestinationsIterable listIngestionDestinationsPaginator(
            Consumer<ListIngestionDestinationsRequest.Builder> listIngestionDestinationsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return listIngestionDestinationsPaginator(ListIngestionDestinationsRequest.builder()
                .applyMutation(listIngestionDestinationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all ingestions configured for an app bundle.
     * </p>
     *
     * @param listIngestionsRequest
     * @return Result of the ListIngestions operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsResponse listIngestions(ListIngestionsRequest listIngestionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all ingestions configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest.Builder} to create a request.
     * @return Result of the ListIngestions operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsResponse listIngestions(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return listIngestions(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all ingestions configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListIngestionsIterable responses = client
     *             .listIngestionsPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation.</b>
     * </p>
     *
     * @param listIngestionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsIterable listIngestionsPaginator(ListIngestionsRequest listIngestionsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return new ListIngestionsIterable(this, listIngestionsRequest);
    }

    /**
     * <p>
     * Returns a list of all ingestions configured for an app bundle.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appfabric.paginators.ListIngestionsIterable responses = client
     *             .listIngestionsPaginator(request);
     *     for (software.amazon.awssdk.services.appfabric.model.ListIngestionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appfabric.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListIngestionsRequest#builder()}
     * </p>
     *
     * @param listIngestionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListIngestionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListIngestionsIterable listIngestionsPaginator(Consumer<ListIngestionsRequest.Builder> listIngestionsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return listIngestionsPaginator(ListIngestionsRequest.builder().applyMutation(listIngestionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts (enables) an ingestion, which collects data from an application.
     * </p>
     *
     * @param startIngestionRequest
     * @return Result of the StartIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.StartIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default StartIngestionResponse startIngestion(StartIngestionRequest startIngestionRequest) throws InternalServerException,
            ThrottlingException, ConflictException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts (enables) an ingestion, which collects data from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartIngestionRequest.Builder} avoiding the need to
     * create one manually via {@link StartIngestionRequest#builder()}
     * </p>
     *
     * @param startIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.StartIngestionRequest.Builder} to create a request.
     * @return Result of the StartIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.StartIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default StartIngestionResponse startIngestion(Consumer<StartIngestionRequest.Builder> startIngestionRequest)
            throws InternalServerException, ThrottlingException, ConflictException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return startIngestion(StartIngestionRequest.builder().applyMutation(startIngestionRequest).build());
    }

    /**
     * <p>
     * Starts the tasks to search user access status for a specific email address.
     * </p>
     * <p>
     * The tasks are stopped when the user access status data is found. The tasks are terminated when the API calls to
     * the application time out.
     * </p>
     *
     * @param startUserAccessTasksRequest
     * @return Result of the StartUserAccessTasks operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.StartUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUserAccessTasksResponse startUserAccessTasks(StartUserAccessTasksRequest startUserAccessTasksRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the tasks to search user access status for a specific email address.
     * </p>
     * <p>
     * The tasks are stopped when the user access status data is found. The tasks are terminated when the API calls to
     * the application time out.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartUserAccessTasksRequest.Builder} avoiding the
     * need to create one manually via {@link StartUserAccessTasksRequest#builder()}
     * </p>
     *
     * @param startUserAccessTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.StartUserAccessTasksRequest.Builder} to create a
     *        request.
     * @return Result of the StartUserAccessTasks operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.StartUserAccessTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StartUserAccessTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default StartUserAccessTasksResponse startUserAccessTasks(
            Consumer<StartUserAccessTasksRequest.Builder> startUserAccessTasksRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return startUserAccessTasks(StartUserAccessTasksRequest.builder().applyMutation(startUserAccessTasksRequest).build());
    }

    /**
     * <p>
     * Stops (disables) an ingestion.
     * </p>
     *
     * @param stopIngestionRequest
     * @return Result of the StopIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.StopIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StopIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default StopIngestionResponse stopIngestion(StopIngestionRequest stopIngestionRequest) throws InternalServerException,
            ThrottlingException, ConflictException, ValidationException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops (disables) an ingestion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopIngestionRequest.Builder} avoiding the need to
     * create one manually via {@link StopIngestionRequest#builder()}
     * </p>
     *
     * @param stopIngestionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.StopIngestionRequest.Builder} to create a request.
     * @return Result of the StopIngestion operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.StopIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/StopIngestion" target="_top">AWS API
     *      Documentation</a>
     */
    default StopIngestionResponse stopIngestion(Consumer<StopIngestionRequest.Builder> stopIngestionRequest)
            throws InternalServerException, ThrottlingException, ConflictException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return stopIngestion(StopIngestionRequest.builder().applyMutation(stopIngestionRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     * <p>
     * If the app authorization was in a <code>connected</code> state, updating the app authorization will set it back
     * to a <code>PendingConnect</code> state.
     * </p>
     *
     * @param updateAppAuthorizationRequest
     * @return Result of the UpdateAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.UpdateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAppAuthorizationResponse updateAppAuthorization(UpdateAppAuthorizationRequest updateAppAuthorizationRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     * </p>
     * <p>
     * If the app authorization was in a <code>connected</code> state, updating the app authorization will set it back
     * to a <code>PendingConnect</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAppAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAppAuthorizationRequest#builder()}
     * </p>
     *
     * @param updateAppAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.UpdateAppAuthorizationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAppAuthorization operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.UpdateAppAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateAppAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAppAuthorizationResponse updateAppAuthorization(
            Consumer<UpdateAppAuthorizationRequest.Builder> updateAppAuthorizationRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppFabricException {
        return updateAppAuthorization(UpdateAppAuthorizationRequest.builder().applyMutation(updateAppAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     *
     * @param updateIngestionDestinationRequest
     * @return Result of the UpdateIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.UpdateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIngestionDestinationResponse updateIngestionDestination(
            UpdateIngestionDestinationRequest updateIngestionDestinationRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ConflictException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, AppFabricException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web
     * Services AppFabric and where it's delivered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIngestionDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIngestionDestinationRequest#builder()}
     * </p>
     *
     * @param updateIngestionDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appfabric.model.UpdateIngestionDestinationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateIngestionDestination operation returned by the service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception, or failure with an internal
     *         server.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request rate exceeds the limit.
     * @throws ConflictException
     *         The request has created a conflict. Check the request parameters and try again.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppFabricException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppFabricClient.UpdateIngestionDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateIngestionDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIngestionDestinationResponse updateIngestionDestination(
            Consumer<UpdateIngestionDestinationRequest.Builder> updateIngestionDestinationRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ConflictException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppFabricException {
        return updateIngestionDestination(UpdateIngestionDestinationRequest.builder()
                .applyMutation(updateIngestionDestinationRequest).build());
    }

    /**
     * Create a {@link AppFabricClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppFabricClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppFabricClient}.
     */
    static AppFabricClientBuilder builder() {
        return new DefaultAppFabricClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default AppFabricServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
