/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BytesMeasure {
    KILOBYTES("KILOBYTES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BytesMeasure> VALUE_MAP;
    private final String value;

    private BytesMeasure(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BytesMeasure fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BytesMeasure> knownValues() {
        EnumSet<BytesMeasure> knownValues = EnumSet.allOf(BytesMeasure.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BytesMeasure.class, BytesMeasure::toString);
    }
}

