/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ProxySystemSetting;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class ProxyConfiguration
implements ToCopyableBuilder<Builder, ProxyConfiguration> {
    private final URI endpoint;
    private final String username;
    private final String password;
    private final String ntlmDomain;
    private final String ntlmWorkstation;
    private final Set<String> nonProxyHosts;
    private final Boolean preemptiveBasicAuthenticationEnabled;
    private final Boolean useSystemPropertyValues;
    private final String host;
    private final int port;
    private final String scheme;

    private ProxyConfiguration(DefaultClientProxyConfigurationBuilder builder) {
        this.endpoint = builder.endpoint;
        this.username = builder.username;
        this.password = builder.password;
        this.ntlmDomain = builder.ntlmDomain;
        this.ntlmWorkstation = builder.ntlmWorkstation;
        this.nonProxyHosts = builder.nonProxyHosts;
        this.preemptiveBasicAuthenticationEnabled = builder.preemptiveBasicAuthenticationEnabled == null ? Boolean.FALSE : builder.preemptiveBasicAuthenticationEnabled;
        this.useSystemPropertyValues = builder.useSystemPropertyValues;
        this.host = this.resolveHost();
        this.port = this.resolvePort();
        this.scheme = this.resolveScheme();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String scheme() {
        return this.scheme;
    }

    public String username() {
        return this.resolveValue(this.username, ProxySystemSetting.PROXY_USERNAME);
    }

    public String password() {
        return this.resolveValue(this.password, ProxySystemSetting.PROXY_PASSWORD);
    }

    public String ntlmDomain() {
        return this.ntlmDomain;
    }

    public String ntlmWorkstation() {
        return this.ntlmWorkstation;
    }

    public Set<String> nonProxyHosts() {
        Set<String> hosts = this.nonProxyHosts == null && this.useSystemPropertyValues != false ? this.parseNonProxyHostsProperty() : this.nonProxyHosts;
        return Collections.unmodifiableSet(hosts != null ? hosts : Collections.emptySet());
    }

    public Boolean preemptiveBasicAuthenticationEnabled() {
        return this.preemptiveBasicAuthenticationEnabled;
    }

    public Builder toBuilder() {
        return ProxyConfiguration.builder().endpoint(this.endpoint).username(this.username).password(this.password).ntlmDomain(this.ntlmDomain).ntlmWorkstation(this.ntlmWorkstation).nonProxyHosts(this.nonProxyHosts).preemptiveBasicAuthenticationEnabled(this.preemptiveBasicAuthenticationEnabled);
    }

    public static Builder builder() {
        return new DefaultClientProxyConfigurationBuilder();
    }

    public String toString() {
        return ToString.builder((String)"ProxyConfiguration").add("endpoint", (Object)this.endpoint).add("username", (Object)this.username).add("ntlmDomain", (Object)this.ntlmDomain).add("ntlmWorkstation", (Object)this.ntlmWorkstation).add("nonProxyHosts", this.nonProxyHosts).add("preemptiveBasicAuthenticationEnabled", (Object)this.preemptiveBasicAuthenticationEnabled).build();
    }

    private String resolveHost() {
        return this.endpoint != null ? this.endpoint.getHost() : this.resolveValue(null, ProxySystemSetting.PROXY_HOST);
    }

    private int resolvePort() {
        int port = 0;
        if (this.endpoint != null) {
            port = this.endpoint.getPort();
        } else if (this.useSystemPropertyValues.booleanValue()) {
            port = ProxySystemSetting.PROXY_PORT.getStringValue().map(Integer::parseInt).orElse(0);
        }
        return port;
    }

    public String resolveScheme() {
        return this.endpoint != null ? this.endpoint.getScheme() : null;
    }

    private String resolveValue(String value, ProxySystemSetting systemSetting) {
        return value == null && this.useSystemPropertyValues != false ? (String)systemSetting.getStringValue().orElse(null) : value;
    }

    private Set<String> parseNonProxyHostsProperty() {
        String nonProxyHosts = ProxySystemSetting.NON_PROXY_HOSTS.getStringValue().orElse(null);
        if (!StringUtils.isEmpty((CharSequence)nonProxyHosts)) {
            return Arrays.stream(nonProxyHosts.split("\\|")).map(String::toLowerCase).map(s -> s.replace("*", ".*?")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static final class DefaultClientProxyConfigurationBuilder
    implements Builder {
        private URI endpoint;
        private String username;
        private String password;
        private String ntlmDomain;
        private String ntlmWorkstation;
        private Set<String> nonProxyHosts;
        private Boolean preemptiveBasicAuthenticationEnabled;
        private Boolean useSystemPropertyValues = Boolean.TRUE;

        private DefaultClientProxyConfigurationBuilder() {
        }

        @Override
        public Builder endpoint(URI endpoint) {
            if (endpoint != null) {
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getUserInfo()), (String)"Proxy endpoint user info is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getPath()), (String)"Proxy endpoint path is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getQuery()), (String)"Proxy endpoint query is not supported.", (Object[])new Object[0]);
                Validate.isTrue((boolean)StringUtils.isEmpty((CharSequence)endpoint.getFragment()), (String)"Proxy endpoint fragment is not supported.", (Object[])new Object[0]);
            }
            this.endpoint = endpoint;
            return this;
        }

        public void setEndpoint(URI endpoint) {
            this.endpoint(endpoint);
        }

        @Override
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public void setUsername(String username) {
            this.username(username);
        }

        @Override
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public void setPassword(String password) {
            this.password(password);
        }

        @Override
        public Builder ntlmDomain(String proxyDomain) {
            this.ntlmDomain = proxyDomain;
            return this;
        }

        public void setNtlmDomain(String ntlmDomain) {
            this.ntlmDomain(ntlmDomain);
        }

        @Override
        public Builder ntlmWorkstation(String proxyWorkstation) {
            this.ntlmWorkstation = proxyWorkstation;
            return this;
        }

        public void setNtlmWorkstation(String ntlmWorkstation) {
            this.ntlmWorkstation(ntlmWorkstation);
        }

        @Override
        public Builder nonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts = new HashSet<String>(nonProxyHosts);
            return this;
        }

        @Override
        public Builder addNonProxyHost(String nonProxyHost) {
            if (this.nonProxyHosts == null) {
                this.nonProxyHosts = new HashSet<String>();
            }
            this.nonProxyHosts.add(nonProxyHost);
            return this;
        }

        public void setNonProxyHosts(Set<String> nonProxyHosts) {
            this.nonProxyHosts(nonProxyHosts);
        }

        @Override
        public Builder preemptiveBasicAuthenticationEnabled(Boolean preemptiveBasicAuthenticationEnabled) {
            this.preemptiveBasicAuthenticationEnabled = preemptiveBasicAuthenticationEnabled;
            return this;
        }

        public void setPreemptiveBasicAuthenticationEnabled(Boolean preemptiveBasicAuthenticationEnabled) {
            this.preemptiveBasicAuthenticationEnabled(preemptiveBasicAuthenticationEnabled);
        }

        @Override
        public Builder useSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues = useSystemPropertyValues;
            return this;
        }

        public void setUseSystemPropertyValues(Boolean useSystemPropertyValues) {
            this.useSystemPropertyValues(useSystemPropertyValues);
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProxyConfiguration> {
        public Builder endpoint(URI var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder ntlmDomain(String var1);

        public Builder ntlmWorkstation(String var1);

        public Builder nonProxyHosts(Set<String> var1);

        public Builder addNonProxyHost(String var1);

        public Builder preemptiveBasicAuthenticationEnabled(Boolean var1);

        public Builder useSystemPropertyValues(Boolean var1);
    }
}

