/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the backend properties associated with an Amplify <code>Branch</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Backend implements SdkPojo, Serializable, ToCopyableBuilder<Backend.Builder, Backend> {
    private static final SdkField<String> STACK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackArn").getter(getter(Backend::stackArn)).setter(setter(Builder::stackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackArn;

    private Backend(BuilderImpl builder) {
        this.stackArn = builder.stackArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the CloudFormation stack.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the CloudFormation stack.
     */
    public final String stackArn() {
        return stackArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backend)) {
            return false;
        }
        Backend other = (Backend) obj;
        return Objects.equals(stackArn(), other.stackArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Backend").add("StackArn", stackArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stackArn":
            return Optional.ofNullable(clazz.cast(stackArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Backend, T> g) {
        return obj -> g.apply((Backend) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Backend> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the CloudFormation stack.
         * </p>
         * 
         * @param stackArn
         *        The Amazon Resource Name (ARN) for the CloudFormation stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackArn(String stackArn);
    }

    static final class BuilderImpl implements Builder {
        private String stackArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Backend model) {
            stackArn(model.stackArn);
        }

        public final String getStackArn() {
            return stackArn;
        }

        public final void setStackArn(String stackArn) {
            this.stackArn = stackArn;
        }

        @Override
        public final Builder stackArn(String stackArn) {
            this.stackArn = stackArn;
            return this;
        }

        @Override
        public Backend build() {
            return new Backend(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
