/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCertificateAuthorityCsrResponse extends AcmPcaResponse implements
        ToCopyableBuilder<GetCertificateAuthorityCsrResponse.Builder, GetCertificateAuthorityCsrResponse> {
    private static final SdkField<String> CSR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Csr")
            .getter(getter(GetCertificateAuthorityCsrResponse::csr)).setter(setter(Builder::csr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSR_FIELD));

    private final String csr;

    private GetCertificateAuthorityCsrResponse(BuilderImpl builder) {
        super(builder);
        this.csr = builder.csr;
    }

    /**
     * <p>
     * The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
     * </p>
     * 
     * @return The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
     */
    public final String csr() {
        return csr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(csr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificateAuthorityCsrResponse)) {
            return false;
        }
        GetCertificateAuthorityCsrResponse other = (GetCertificateAuthorityCsrResponse) obj;
        return Objects.equals(csr(), other.csr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCertificateAuthorityCsrResponse").add("Csr", csr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Csr":
            return Optional.ofNullable(clazz.cast(csr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCertificateAuthorityCsrResponse, T> g) {
        return obj -> g.apply((GetCertificateAuthorityCsrResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCertificateAuthorityCsrResponse> {
        /**
         * <p>
         * The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
         * </p>
         * 
         * @param csr
         *        The base64 PEM-encoded certificate signing request (CSR) for your private CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csr(String csr);
    }

    static final class BuilderImpl extends AcmPcaResponse.BuilderImpl implements Builder {
        private String csr;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificateAuthorityCsrResponse model) {
            super(model);
            csr(model.csr);
        }

        public final String getCsr() {
            return csr;
        }

        public final void setCsr(String csr) {
            this.csr = csr;
        }

        @Override
        public final Builder csr(String csr) {
            this.csr = csr;
            return this;
        }

        @Override
        public GetCertificateAuthorityCsrResponse build() {
            return new GetCertificateAuthorityCsrResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
