/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExtendedKeyUsageType {
    SERVER_AUTH("SERVER_AUTH"),
    CLIENT_AUTH("CLIENT_AUTH"),
    CODE_SIGNING("CODE_SIGNING"),
    EMAIL_PROTECTION("EMAIL_PROTECTION"),
    TIME_STAMPING("TIME_STAMPING"),
    OCSP_SIGNING("OCSP_SIGNING"),
    SMART_CARD_LOGIN("SMART_CARD_LOGIN"),
    DOCUMENT_SIGNING("DOCUMENT_SIGNING"),
    CERTIFICATE_TRANSPARENCY("CERTIFICATE_TRANSPARENCY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExtendedKeyUsageType> VALUE_MAP;
    private final String value;

    private ExtendedKeyUsageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExtendedKeyUsageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExtendedKeyUsageType> knownValues() {
        EnumSet<ExtendedKeyUsageType> knownValues = EnumSet.allOf(ExtendedKeyUsageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExtendedKeyUsageType.class, ExtendedKeyUsageType::toString);
    }
}

