/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest;
import software.amazon.awssdk.services.account.model.DeleteAlternateContactResponse;
import software.amazon.awssdk.services.account.model.DisableRegionRequest;
import software.amazon.awssdk.services.account.model.DisableRegionResponse;
import software.amazon.awssdk.services.account.model.EnableRegionRequest;
import software.amazon.awssdk.services.account.model.EnableRegionResponse;
import software.amazon.awssdk.services.account.model.GetAlternateContactRequest;
import software.amazon.awssdk.services.account.model.GetAlternateContactResponse;
import software.amazon.awssdk.services.account.model.GetContactInformationRequest;
import software.amazon.awssdk.services.account.model.GetContactInformationResponse;
import software.amazon.awssdk.services.account.model.GetRegionOptStatusRequest;
import software.amazon.awssdk.services.account.model.GetRegionOptStatusResponse;
import software.amazon.awssdk.services.account.model.ListRegionsRequest;
import software.amazon.awssdk.services.account.model.ListRegionsResponse;
import software.amazon.awssdk.services.account.model.PutAlternateContactRequest;
import software.amazon.awssdk.services.account.model.PutAlternateContactResponse;
import software.amazon.awssdk.services.account.model.PutContactInformationRequest;
import software.amazon.awssdk.services.account.model.PutContactInformationResponse;
import software.amazon.awssdk.services.account.paginators.ListRegionsPublisher;

/**
 * Service client for accessing AWS Account asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Operations for Amazon Web Services Account Management
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AccountAsyncClient extends AwsClient {
    String SERVICE_NAME = "account";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "account";

    /**
     * <p>
     * Deletes the specified alternate contact from an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <note>
     * <p>
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by
     * Organizations, you must first enable integration between Amazon Web Services Account Management and
     * Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted
     * access for Amazon Web Services Account Management</a>.
     * </p>
     * </note>
     *
     * @param deleteAlternateContactRequest
     * @return A Java Future containing the result of the DeleteAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.DeleteAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/DeleteAlternateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAlternateContactResponse> deleteAlternateContact(
            DeleteAlternateContactRequest deleteAlternateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified alternate contact from an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <note>
     * <p>
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by
     * Organizations, you must first enable integration between Amazon Web Services Account Management and
     * Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted
     * access for Amazon Web Services Account Management</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlternateContactRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAlternateContactRequest#builder()}
     * </p>
     *
     * @param deleteAlternateContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.DeleteAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/DeleteAlternateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAlternateContactResponse> deleteAlternateContact(
            Consumer<DeleteAlternateContactRequest.Builder> deleteAlternateContactRequest) {
        return deleteAlternateContact(DeleteAlternateContactRequest.builder().applyMutation(deleteAlternateContactRequest)
                .build());
    }

    /**
     * <p>
     * Disables (opts-out) a particular Region for an account.
     * </p>
     *
     * @param disableRegionRequest
     * @return A Java Future containing the result of the DisableRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>ConflictException The request could not be processed because of a conflict in the current status of
     *         the resource. For example, this happens if you try to enable a Region that is currently being disabled
     *         (in a status of DISABLING).</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.DisableRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/DisableRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableRegionResponse> disableRegion(DisableRegionRequest disableRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables (opts-out) a particular Region for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableRegionRequest.Builder} avoiding the need to
     * create one manually via {@link DisableRegionRequest#builder()}
     * </p>
     *
     * @param disableRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.DisableRegionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisableRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>ConflictException The request could not be processed because of a conflict in the current status of
     *         the resource. For example, this happens if you try to enable a Region that is currently being disabled
     *         (in a status of DISABLING).</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.DisableRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/DisableRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableRegionResponse> disableRegion(Consumer<DisableRegionRequest.Builder> disableRegionRequest) {
        return disableRegion(DisableRegionRequest.builder().applyMutation(disableRegionRequest).build());
    }

    /**
     * <p>
     * Enables (opts-in) a particular Region for an account.
     * </p>
     *
     * @param enableRegionRequest
     * @return A Java Future containing the result of the EnableRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>ConflictException The request could not be processed because of a conflict in the current status of
     *         the resource. For example, this happens if you try to enable a Region that is currently being disabled
     *         (in a status of DISABLING).</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.EnableRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/EnableRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableRegionResponse> enableRegion(EnableRegionRequest enableRegionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables (opts-in) a particular Region for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableRegionRequest.Builder} avoiding the need to
     * create one manually via {@link EnableRegionRequest#builder()}
     * </p>
     *
     * @param enableRegionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.EnableRegionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the EnableRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>ConflictException The request could not be processed because of a conflict in the current status of
     *         the resource. For example, this happens if you try to enable a Region that is currently being disabled
     *         (in a status of DISABLING).</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.EnableRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/EnableRegion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableRegionResponse> enableRegion(Consumer<EnableRegionRequest.Builder> enableRegionRequest) {
        return enableRegion(EnableRegionRequest.builder().applyMutation(enableRegionRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <note>
     * <p>
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by
     * Organizations, you must first enable integration between Amazon Web Services Account Management and
     * Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted
     * access for Amazon Web Services Account Management</a>.
     * </p>
     * </note>
     *
     * @param getAlternateContactRequest
     * @return A Java Future containing the result of the GetAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAlternateContactResponse> getAlternateContact(
            GetAlternateContactRequest getAlternateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <note>
     * <p>
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by
     * Organizations, you must first enable integration between Amazon Web Services Account Management and
     * Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted
     * access for Amazon Web Services Account Management</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAlternateContactRequest.Builder} avoiding the
     * need to create one manually via {@link GetAlternateContactRequest#builder()}
     * </p>
     *
     * @param getAlternateContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.GetAlternateContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAlternateContactResponse> getAlternateContact(
            Consumer<GetAlternateContactRequest.Builder> getAlternateContactRequest) {
        return getAlternateContact(GetAlternateContactRequest.builder().applyMutation(getAlternateContactRequest).build());
    }

    /**
     * <p>
     * Retrieves the primary contact information of an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the primary contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary
     * and alternate contact information</a>.
     * </p>
     *
     * @param getContactInformationRequest
     * @return A Java Future containing the result of the GetContactInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetContactInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetContactInformation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactInformationResponse> getContactInformation(
            GetContactInformationRequest getContactInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the primary contact information of an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the primary contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary
     * and alternate contact information</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactInformationRequest.Builder} avoiding the
     * need to create one manually via {@link GetContactInformationRequest#builder()}
     * </p>
     *
     * @param getContactInformationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.GetContactInformationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetContactInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetContactInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetContactInformation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactInformationResponse> getContactInformation(
            Consumer<GetContactInformationRequest.Builder> getContactInformationRequest) {
        return getContactInformation(GetContactInformationRequest.builder().applyMutation(getContactInformationRequest).build());
    }

    /**
     * <p>
     * Retrieves the opt-in status of a particular Region.
     * </p>
     *
     * @param getRegionOptStatusRequest
     * @return A Java Future containing the result of the GetRegionOptStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetRegionOptStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetRegionOptStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRegionOptStatusResponse> getRegionOptStatus(GetRegionOptStatusRequest getRegionOptStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the opt-in status of a particular Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegionOptStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegionOptStatusRequest#builder()}
     * </p>
     *
     * @param getRegionOptStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.GetRegionOptStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRegionOptStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetRegionOptStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetRegionOptStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRegionOptStatusResponse> getRegionOptStatus(
            Consumer<GetRegionOptStatusRequest.Builder> getRegionOptStatusRequest) {
        return getRegionOptStatus(GetRegionOptStatusRequest.builder().applyMutation(getRegionOptStatusRequest).build());
    }

    /**
     * <p>
     * Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be
     * filtered by the <code>region-opt-status-contains</code> parameter.
     * </p>
     *
     * @param listRegionsRequest
     * @return A Java Future containing the result of the ListRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/ListRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRegionsResponse> listRegions(ListRegionsRequest listRegionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be
     * filtered by the <code>region-opt-status-contains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegionsRequest#builder()}
     * </p>
     *
     * @param listRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.ListRegionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/ListRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRegionsResponse> listRegions(Consumer<ListRegionsRequest.Builder> listRegionsRequest) {
        return listRegions(ListRegionsRequest.builder().applyMutation(listRegionsRequest).build());
    }

    /**
     * <p>
     * Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be
     * filtered by the <code>region-opt-status-contains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRegions(software.amazon.awssdk.services.account.model.ListRegionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.account.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.account.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.account.model.ListRegionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.account.model.ListRegionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegions(software.amazon.awssdk.services.account.model.ListRegionsRequest)} operation.</b>
     * </p>
     *
     * @param listRegionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/ListRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegionsPublisher listRegionsPaginator(ListRegionsRequest listRegionsRequest) {
        return new ListRegionsPublisher(this, listRegionsRequest);
    }

    /**
     * <p>
     * Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be
     * filtered by the <code>region-opt-status-contains</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRegions(software.amazon.awssdk.services.account.model.ListRegionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.account.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.account.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.account.model.ListRegionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.account.model.ListRegionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegions(software.amazon.awssdk.services.account.model.ListRegionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegionsRequest#builder()}
     * </p>
     *
     * @param listRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.ListRegionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/ListRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegionsPublisher listRegionsPaginator(Consumer<ListRegionsRequest.Builder> listRegionsRequest) {
        return listRegionsPaginator(ListRegionsRequest.builder().applyMutation(listRegionsRequest).build());
    }

    /**
     * <p>
     * Modifies the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <note>
     * <p>
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by
     * Organizations, you must first enable integration between Amazon Web Services Account Management and
     * Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted
     * access for Amazon Web Services Account Management</a>.
     * </p>
     * </note>
     *
     * @param putAlternateContactRequest
     * @return A Java Future containing the result of the PutAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.PutAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/PutAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAlternateContactResponse> putAlternateContact(
            PutAlternateContactRequest putAlternateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <note>
     * <p>
     * Before you can update the alternate contact information for an Amazon Web Services account that is managed by
     * Organizations, you must first enable integration between Amazon Web Services Account Management and
     * Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/using-orgs-trusted-access.html">Enabling trusted
     * access for Amazon Web Services Account Management</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAlternateContactRequest.Builder} avoiding the
     * need to create one manually via {@link PutAlternateContactRequest#builder()}
     * </p>
     *
     * @param putAlternateContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.PutAlternateContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.PutAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/PutAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAlternateContactResponse> putAlternateContact(
            Consumer<PutAlternateContactRequest.Builder> putAlternateContactRequest) {
        return putAlternateContact(PutAlternateContactRequest.builder().applyMutation(putAlternateContactRequest).build());
    }

    /**
     * <p>
     * Updates the primary contact information of an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the primary contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary
     * and alternate contact information</a>.
     * </p>
     *
     * @param putContactInformationRequest
     * @return A Java Future containing the result of the PutContactInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.PutContactInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/PutContactInformation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutContactInformationResponse> putContactInformation(
            PutContactInformationRequest putContactInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the primary contact information of an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the primary contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Update the primary
     * and alternate contact information</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutContactInformationRequest.Builder} avoiding the
     * need to create one manually via {@link PutContactInformationRequest#builder()}
     * </p>
     *
     * @param putContactInformationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.account.model.PutContactInformationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutContactInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.PutContactInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/PutContactInformation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutContactInformationResponse> putContactInformation(
            Consumer<PutContactInformationRequest.Builder> putContactInformationRequest) {
        return putContactInformation(PutContactInformationRequest.builder().applyMutation(putContactInformationRequest).build());
    }

    @Override
    default AccountServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AccountAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AccountAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AccountAsyncClient}.
     */
    static AccountAsyncClientBuilder builder() {
        return new DefaultAccountAsyncClientBuilder();
    }
}
