/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.container.ExplicitTypeVariable;
import ru.vyarus.java.generics.resolver.context.container.WildcardTypeImpl;
import ru.vyarus.java.generics.resolver.error.GenericsTrackingException;
import ru.vyarus.java.generics.resolver.error.IncompatibleTypesException;
import ru.vyarus.java.generics.resolver.util.GenericInfoUtils;
import ru.vyarus.java.generics.resolver.util.GenericsResolutionUtils;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.EmptyGenericsMap;

public final class GenericsTrackingUtils {
    private GenericsTrackingUtils() {
    }

    public static LinkedHashMap<String, Type> track(Class<?> type, Class<?> known, LinkedHashMap<String, Type> knownGenerics) {
        if (type.getTypeParameters().length == 0 || knownGenerics.isEmpty()) {
            return EmptyGenericsMap.getInstance();
        }
        try {
            return GenericsTrackingUtils.trackGenerics(type, known, knownGenerics);
        }
        catch (Exception ex) {
            throw new GenericsTrackingException(type, known, knownGenerics, ex);
        }
    }

    private static LinkedHashMap<String, Type> trackGenerics(Class<?> type, Class<?> known, LinkedHashMap<String, Type> knownGenerics) {
        LinkedHashMap<String, Type> rootGenerics = new LinkedHashMap<String, Type>();
        for (TypeVariable<Class<?>> var : type.getTypeParameters()) {
            rootGenerics.put(var.getName(), new ExplicitTypeVariable(var));
        }
        Map<Class<?>, LinkedHashMap<String, Type>> generics = GenericsResolutionUtils.resolve(type, rootGenerics, Collections.<Class<?>, LinkedHashMap<String, Type>>emptyMap(), Collections.<Class<?>>emptyList());
        HashMap<String, Type> tracedRootGenerics = new HashMap<String, Type>();
        LinkedHashMap<String, Type> rawRootGenerics = GenericsResolutionUtils.resolveRawGenerics(type);
        for (Map.Entry entry : generics.get(known).entrySet()) {
            Type actualType = (Type)entry.getValue();
            String genericName = (String)entry.getKey();
            Type knownGenericType = knownGenerics.get(genericName);
            GenericsTrackingUtils.trackType(tracedRootGenerics, rawRootGenerics, genericName, actualType, knownGenericType, type, known, knownGenerics);
        }
        LinkedHashMap<String, Type> res = new LinkedHashMap<String, Type>();
        for (TypeVariable<Class<?>> gen : type.getTypeParameters()) {
            String name;
            res.put(name, tracedRootGenerics.containsKey(name = gen.getName()) ? (Type)tracedRootGenerics.get(name) : GenericsUtils.resolveTypeVariables(gen.getBounds().length > 1 ? WildcardTypeImpl.upper(gen.getBounds()) : gen.getBounds()[0], res));
        }
        return res;
    }

    private static void trackType(Map<String, Type> resolved, Map<String, Type> rawRootGenerics, String genericName, Type actualGeneric, Type knownGeneric, Class<?> root, Class<?> known, LinkedHashMap<String, Type> knownGenerics) {
        Class<?> knownGenericType = GenericsUtils.resolveClass(knownGeneric, knownGenerics);
        if (actualGeneric instanceof ExplicitTypeVariable) {
            ExplicitTypeVariable variable = (ExplicitTypeVariable)actualGeneric;
            GenericsTrackingUtils.checkTypesCompatibility(WildcardTypeImpl.upper(GenericsUtils.resolveTypeVariables(variable.getBounds(), rawRootGenerics)), knownGenericType, genericName, root, known);
            resolved.put(variable.getName(), knownGeneric);
        } else if (actualGeneric instanceof ParameterizedType) {
            Class exactActualType = (Class)((ParameterizedType)actualGeneric).getRawType();
            GenericsTrackingUtils.checkTypesCompatibility(exactActualType, knownGenericType, genericName, root, known);
            if (knownGeneric instanceof ParameterizedType) {
                Type[] actualArguments = ((ParameterizedType)actualGeneric).getActualTypeArguments();
                Type[] knownArguments = GenericsTrackingUtils.alignParametrizationArguments(exactActualType, knownGenericType, (ParameterizedType)knownGeneric, knownGenerics);
                for (int i = 0; i < actualArguments.length; ++i) {
                    GenericsTrackingUtils.trackType(resolved, rawRootGenerics, genericName, actualArguments[i], knownArguments[i], root, known, knownGenerics);
                }
            }
        } else if (actualGeneric instanceof GenericArrayType) {
            Type actualComponentType = ((GenericArrayType)actualGeneric).getGenericComponentType();
            if (knownGeneric instanceof Class && ((Class)knownGeneric).isArray()) {
                GenericsTrackingUtils.trackType(resolved, rawRootGenerics, genericName, actualComponentType, ((Class)knownGeneric).getComponentType(), root, known, knownGenerics);
            }
        } else if (actualGeneric instanceof Class) {
            Class exactActualType = (Class)actualGeneric;
            GenericsTrackingUtils.checkTypesCompatibility(exactActualType, knownGenericType, genericName, root, known);
        }
    }

    private static Type[] alignParametrizationArguments(Class<?> exactActualType, Class<?> knownGenericType, ParameterizedType knownGeneric, LinkedHashMap<String, Type> knownGenerics) {
        Type[] knownArguments;
        if (exactActualType.equals(knownGenericType)) {
            knownArguments = knownGeneric.getActualTypeArguments();
        } else if (knownGenericType.isAssignableFrom(exactActualType)) {
            LinkedHashMap<String, Type> sub = GenericsTrackingUtils.track(exactActualType, knownGenericType, GenericsResolutionUtils.resolveGenerics(knownGeneric, knownGenerics));
            knownArguments = sub.values().toArray(new Type[0]);
        } else {
            GenericsContext ctx = GenericsResolver.resolve(knownGenericType, new Class[0]);
            knownArguments = GenericInfoUtils.create(ctx, (Type)knownGeneric, new Class[0]).getTypeGenerics(exactActualType).values().toArray(new Type[0]);
        }
        return knownArguments;
    }

    private static void checkTypesCompatibility(Type actualType, Type knownType, String genericName, Class<?> root, Class<?> known) {
        if (!TypeUtils.isCompatible(actualType, knownType)) {
            throw new IncompatibleTypesException(String.format("Known generic %s of %s is not compatible with %s hierarchy: %%s when required %%s", genericName, TypeToStringUtils.toStringWithNamedGenerics(known), root.getSimpleName()), knownType, actualType);
        }
    }
}

