/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.util.GenericsResolutionUtils;
import ru.vyarus.java.generics.resolver.util.GenericsTrackingUtils;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.EmptyGenericsMap;

public final class GenericInfoUtils {
    private GenericInfoUtils() {
    }

    public static GenericsInfo create(Class<?> type, Class<?> ... ignoreClasses) {
        LinkedHashMap<String, Type> generics = GenericsResolutionUtils.resolveRawGenerics(type);
        return GenericInfoUtils.create(type, generics, null, ignoreClasses);
    }

    public static GenericsInfo create(GenericsContext context, Type type, Class<?> ... ignoreClasses) {
        Map<String, Type> rootGenerics = context.visibleGenericsMap();
        Type actual = GenericsUtils.resolveTypeVariables(type, rootGenerics);
        Class<?> target = context.resolveClass(actual);
        LinkedHashMap<String, Type> generics = GenericsResolutionUtils.resolveGenerics(actual, rootGenerics);
        generics = GenericsResolutionUtils.fillOuterGenerics(actual, generics, context.getGenericsInfo().getTypesMap());
        return GenericInfoUtils.create(target, generics, GenericInfoUtils.usePossiblyOwnerGenerics(target, context.getGenericsInfo()), ignoreClasses);
    }

    public static GenericsInfo create(GenericsContext context, Type type, Class<?> asType, Class<?> ... ignoreClasses) {
        Map<String, Type> rootGenerics = context.visibleGenericsMap();
        Type actual = GenericsUtils.resolveTypeVariables(type, rootGenerics);
        Class<?> middleType = context.resolveClass(actual);
        if (!middleType.isAssignableFrom(asType)) {
            throw new IllegalArgumentException(String.format("Requested type %s is not a subtype of %s", asType.getSimpleName(), middleType.getSimpleName()));
        }
        LinkedHashMap typeGenerics = GenericsResolutionUtils.resolveGenerics(actual, rootGenerics);
        HashMap knownGenerics = new HashMap();
        knownGenerics.put(middleType, GenericsResolutionUtils.fillOuterGenerics(actual, typeGenerics, context.getGenericsInfo().getTypesMap()));
        if (TypeUtils.isInner(middleType)) {
            knownGenerics.put((Class)TypeUtils.getOuter(middleType), new LinkedHashMap<String, Type>(GenericsUtils.extractOwnerGenerics(middleType, (Map)knownGenerics.get(middleType))));
        } else {
            knownGenerics.putAll(GenericInfoUtils.usePossiblyOwnerGenerics(asType, context.getGenericsInfo()));
        }
        typeGenerics = asType.getTypeParameters().length > 0 ? GenericsTrackingUtils.track(asType, middleType, typeGenerics) : EmptyGenericsMap.getInstance();
        typeGenerics = GenericsResolutionUtils.fillOuterGenerics(asType, typeGenerics, knownGenerics.size() > 1 ? knownGenerics : context.getGenericsInfo().getTypesMap());
        return GenericInfoUtils.create(asType, typeGenerics, knownGenerics, ignoreClasses);
    }

    private static GenericsInfo create(Class type, LinkedHashMap<String, Type> rootGenerics, Map<Class<?>, LinkedHashMap<String, Type>> knownGenerics, Class<?> ... ignoreClasses) {
        Map<Class<?>, LinkedHashMap<String, Type>> generics = GenericsResolutionUtils.resolve(type, rootGenerics, knownGenerics == null ? Collections.emptyMap() : knownGenerics, Arrays.asList(ignoreClasses));
        return new GenericsInfo(type, generics, ignoreClasses);
    }

    private static Map<Class<?>, LinkedHashMap<String, Type>> usePossiblyOwnerGenerics(Class<?> type, GenericsInfo info) {
        HashMap res = new HashMap();
        for (Class<?> root : info.getComposingTypes()) {
            if (root.isAssignableFrom(type)) continue;
            res.put(root, (LinkedHashMap)info.getTypeGenerics(root));
        }
        return res;
    }
}

