/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseFactory;
import org.zaproxy.clientapi.core.ClientApiException;

public class ApiResponseSet
extends ApiResponse {
    private String[] attributes = null;
    private final Map<String, ApiResponse> valuesMap;

    @Deprecated
    public ApiResponseSet(String name, String[] attributes) {
        super(name);
        this.attributes = attributes;
        this.valuesMap = Collections.emptyMap();
    }

    public ApiResponseSet(String name, Map<String, ApiResponse> values) {
        super(name);
        this.valuesMap = Collections.unmodifiableMap(new HashMap<String, ApiResponse>(values));
    }

    public ApiResponseSet(Node node) throws ClientApiException {
        super(node.getNodeName());
        HashMap<String, ApiResponse> values = new HashMap<String, ApiResponse>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ApiResponse elem = ApiResponseFactory.getResponse(child);
            values.put(elem.getName(), elem);
        }
        this.valuesMap = Collections.unmodifiableMap(values);
    }

    @Deprecated
    public String[] getAttributes() {
        return this.attributes;
    }

    @Deprecated
    public String getAttribute(String key) {
        return this.getStringValue(key);
    }

    public ApiResponse getValue(String key) {
        return this.valuesMap.get(key);
    }

    public String getStringValue(String key) {
        ApiResponse value = this.valuesMap.get(key);
        if (value instanceof ApiResponseElement) {
            return ((ApiResponseElement)value).getValue();
        }
        return value != null ? value.toString() : null;
    }

    public Map<String, ApiResponse> getValuesMap() {
        return this.valuesMap;
    }

    public Set<String> getKeys() {
        return this.valuesMap.keySet();
    }

    public Collection<ApiResponse> getValues() {
        return this.valuesMap.values();
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("ApiResponseSet ");
        sb.append(this.getName());
        sb.append(" : [\n");
        for (Map.Entry<String, ApiResponse> val : this.valuesMap.entrySet()) {
            for (int i = 0; i < indent + 1; ++i) {
                sb.append("\t");
            }
            sb.append(val.getKey());
            sb.append(" = ");
            if (val.getValue() instanceof ApiResponseElement) {
                sb.append(val.getValue());
            } else {
                sb.append('\n');
                sb.append(val.getValue().toString(indent + 2));
            }
            sb.append("\n");
        }
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("]\n");
        return sb.toString();
    }
}

