/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public class BufferingClientHttpResponseWrapper
implements ClientHttpResponse {
    private final ClientHttpResponse delegate;
    private final InputStream body;

    public BufferingClientHttpResponseWrapper(ClientHttpResponse delegate) throws IOException {
        this.delegate = delegate;
        InputStream delegateBody = delegate.getBody();
        this.body = delegateBody.markSupported() ? delegateBody : new BufferedInputStream(delegateBody);
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.delegate.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.delegate.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.delegate.getStatusText();
    }

    public void close() {
        try {
            this.body.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.delegate.close();
    }

    public InputStream getBody() {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        return this.delegate.getHeaders();
    }
}

