/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpLogFormatter;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;

@API(status=API.Status.EXPERIMENTAL)
public interface StructuredHttpLogFormatter
extends HttpLogFormatter {
    @Override
    default public String format(Precorrelation precorrelation, HttpRequest request) throws IOException {
        return this.format(this.prepare(precorrelation, request));
    }

    @Override
    default public String format(Correlation correlation, HttpResponse response) throws IOException {
        return this.format(this.prepare(correlation, response));
    }

    public String format(Map<String, Object> var1) throws IOException;

    default public Map<String, Object> prepare(Precorrelation precorrelation, HttpRequest request) throws IOException {
        String correlationId = precorrelation.getId();
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("origin", request.getOrigin().name().toLowerCase(Locale.ROOT));
        content.put("type", "request");
        content.put("correlation", correlationId);
        content.put("protocol", request.getProtocolVersion());
        content.put("remote", request.getRemote());
        content.put("method", request.getMethod());
        content.put("uri", request.getRequestUri());
        content.put("host", request.getHost());
        content.put("path", request.getPath());
        content.put("scheme", request.getScheme());
        content.put("port", this.preparePort(request));
        if (!request.getAttributes().isEmpty()) {
            content.put("attributes", request.getAttributes());
        }
        this.prepareHeaders(request).ifPresent(headers -> content.put("headers", headers));
        this.prepareBody(request).ifPresent(body -> content.put("body", body));
        return content;
    }

    default public Map<String, Object> prepare(Correlation correlation, HttpResponse response) throws IOException {
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("origin", response.getOrigin().name().toLowerCase(Locale.ROOT));
        content.put("type", "response");
        content.put("correlation", correlation.getId());
        content.put("duration", correlation.getDuration().toMillis());
        content.put("protocol", response.getProtocolVersion());
        content.put("status", response.getStatus());
        if (!response.getAttributes().isEmpty()) {
            content.put("attributes", response.getAttributes());
        }
        this.prepareHeaders(response).ifPresent(headers -> content.put("headers", headers));
        this.prepareBody(response).ifPresent(body -> content.put("body", body));
        return content;
    }

    @Nullable
    default public String preparePort(HttpRequest request) {
        return request.getPort().map(Object::toString).orElse(null);
    }

    default public Optional<Map<String, List<String>>> prepareHeaders(HttpMessage message) {
        HttpHeaders headers = message.getHeaders();
        return Optional.ofNullable(headers.isEmpty() ? null : headers);
    }

    default public Optional<Object> prepareBody(HttpMessage message) throws IOException {
        String body = message.getBodyAsString();
        return Optional.ofNullable(body.isEmpty() ? null : body);
    }
}

