/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.valve;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.base.ServerConfiguration;

public class CSRFValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(CSRFValve.class);
    private static Log audit = CarbonConstants.AUDIT_LOG;
    private static final String REFERER_HEADER = "referer";
    private static final String CSRF_VALVE_PROPERTY = "Security.CSRFPreventionConfig.CSRFValve";
    private static final String ENABLED_PROPERTY = "Security.CSRFPreventionConfig.CSRFValve.Enabled";
    private static final String WHITE_LIST_PROPERTY = "Security.CSRFPreventionConfig.CSRFValve.WhiteList.Url";
    private static final String RULE_PATTERN_PROPERTY = "Security.CSRFPreventionConfig.CSRFValve.Patterns.Pattern";
    private static final String RULE_PROPERTY = "Security.CSRFPreventionConfig.CSRFValve.Rule";
    private static final String RULE_ALLOW = "allow";
    private static final String RULE_DENY = "deny";
    private static final String AJAXPROCESSOR_URL_PATTERN = "ajaxprocessor.jsp";
    private static final String FINISHJSP_URL_PATTERN = "finish.jsp";
    private static String[] csrfPatternList;
    private static String[] whiteList;
    private static String csrfRule;
    private static boolean csrfEnabled;

    private void loadConfiguration() {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        whiteList = serverConfiguration.getProperties(WHITE_LIST_PROPERTY);
        csrfPatternList = serverConfiguration.getProperties(RULE_PATTERN_PROPERTY);
        csrfRule = serverConfiguration.getFirstProperty(RULE_PROPERTY);
        if (whiteList.length > 0 && csrfPatternList.length > 0 && csrfRule != null && serverConfiguration.getFirstProperty(ENABLED_PROPERTY) != null && Boolean.parseBoolean(serverConfiguration.getFirstProperty(ENABLED_PROPERTY))) {
            csrfEnabled = true;
        }
    }

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.loadConfiguration();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (csrfEnabled) {
            this.validatePatterns(request, response);
        }
        this.getNext().invoke(request, response);
    }

    private void validatePatterns(Request request, Response response) throws ServletException {
        String context = request.getRequestURI().substring(request.getRequestURI().indexOf("/") + 1);
        if (RULE_ALLOW.equals(csrfRule) && !this.isContextStartWithGivenPatterns(context)) {
            this.validateRefererHeader(request, response);
        } else if (RULE_DENY.equals(csrfRule) && this.isContextStartWithGivenPatterns(context)) {
            this.validateRefererHeader(request, response);
        }
    }

    private boolean isContextStartWithGivenPatterns(String context) {
        boolean patternMatched = false;
        for (String pattern : csrfPatternList) {
            if (!context.startsWith(pattern)) continue;
            patternMatched = true;
            break;
        }
        return patternMatched;
    }

    private void validateRefererHeader(Request request, Response response) throws ServletException {
        String refererHeader = request.getHeader(REFERER_HEADER);
        boolean allow = false;
        if (refererHeader != null) {
            for (String ip : whiteList) {
                if (!refererHeader.startsWith(ip)) continue;
                allow = true;
                break;
            }
            if (!allow) {
                String msg = "Possible CSRF attack. Refer header : " + refererHeader;
                log.warn((Object)msg);
                audit.warn((Object)msg);
                response.setStatus(403);
                throw new ServletException(msg);
            }
        } else {
            HttpSession currentSession;
            String requestURI = request.getRequestURI();
            if ((requestURI.contains(AJAXPROCESSOR_URL_PATTERN) || requestURI.contains(FINISHJSP_URL_PATTERN)) && (currentSession = request.getSession(false)) != null) {
                currentSession.invalidate();
                String msg = "Possible CSRF attack. Request to '" + requestURI + "' does not have a Referer header";
                log.warn((Object)msg);
                audit.warn((Object)msg);
                response.setStatus(403);
                throw new ServletException(msg);
            }
        }
    }

    static {
        csrfEnabled = false;
    }
}

