/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.transports.fileupload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class ToolsAnyFileUploadExecutor
extends AbstractFileUploadExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        try (PrintWriter out = response.getWriter();){
            Map fileResourceMap = (Map)this.configurationContext.getProperty("file.resource.map");
            if (fileResourceMap == null) {
                fileResourceMap = new TreeBidiMap();
                this.configurationContext.setProperty("file.resource.map", (Object)fileResourceMap);
            }
            List<FileItemData> fileItems = this.getAllFileItems();
            for (FileItemData fileItem : fileItems) {
                String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
                String serviceUploadDir = this.configurationContext.getProperty("WORK_DIR") + File.separator + "extra" + File.separator + uuid + File.separator;
                File dir = new File(serviceUploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File uploadedFile = new File(dir, fileItem.getFileItem().getFieldName());
                try (FileOutputStream fileOutStream = new FileOutputStream(uploadedFile);){
                    fileItem.getDataHandler().writeTo((OutputStream)fileOutStream);
                    fileOutStream.flush();
                }
                response.setContentType("text/plain; charset=utf-8");
                fileResourceMap.put(uuid, uploadedFile.getAbsolutePath());
                out.write(uuid);
            }
            out.flush();
        }
        return true;
    }
}

