/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.transports;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.transports.fileupload.FileUploadExecutorManager;

public class FileUploadServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(FileUploadServlet.class);
    private static final long serialVersionUID = 8089568022124816379L;
    private FileUploadExecutorManager fileUploadExecutorManager;
    private BundleContext bundleContext;
    private ConfigurationContext configContext;
    private String webContext;
    private ServletConfig servletConfig;

    public FileUploadServlet(BundleContext context, ConfigurationContext configCtx, String webContext) {
        this.bundleContext = context;
        this.configContext = configCtx;
        this.webContext = webContext;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.fileUploadExecutorManager.execute(request, response);
        }
        catch (Exception e) {
            String msg = "File upload failed ";
            log.error((Object)msg, (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(406);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        try {
            this.fileUploadExecutorManager = new FileUploadExecutorManager(this.bundleContext, this.configContext, this.webContext);
            this.bundleContext.registerService(FileUploadExecutorManager.class.getName(), (Object)this.fileUploadExecutorManager, null);
        }
        catch (CarbonException e) {
            log.error((Object)"Exception occurred while trying to initialize FileUploadServlet", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }
}

