/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.commons.stub.registry.service.RegistryAdminServiceStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class RegistryAdminServiceClient {
    private static final Log log = LogFactory.getLog(RegistryAdminServiceClient.class);
    private RegistryAdminServiceStub stub;
    private HttpSession session;

    public RegistryAdminServiceClient(String cookie, ServletConfig config, HttpSession session) throws AxisFault {
        String serverURL = CarbonUIUtil.getServerURL(config.getServletContext(), session);
        ConfigurationContext ctx = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.session = session;
        String serviceEPR = serverURL + "RegistryAdminService";
        this.stub = new RegistryAdminServiceStub(ctx, serviceEPR);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        if (cookie != null) {
            options.setProperty("Cookie", (Object)cookie);
        }
    }

    public boolean isRegistryReadOnly() {
        try {
            return this.stub.isRegistryReadOnly();
        }
        catch (Exception e) {
            String msg = "Error occurred while checking registry mode";
            log.error((Object)msg, (Throwable)e);
            return false;
        }
    }

    public String getRegistryHTTPURL() {
        try {
            String httpPermalink = this.stub.getHTTPPermalink("/");
            if (httpPermalink != null) {
                return httpPermalink.substring(0, httpPermalink.length() - "/".length());
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to get permalink", (Throwable)e);
        }
        return "#";
    }

    public String getRegistryHTTPSURL() {
        try {
            String httpsPermalink = this.stub.getHTTPSPermalink("/");
            if (httpsPermalink != null) {
                return httpsPermalink.substring(0, httpsPermalink.length() - "/".length());
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to get permalink", (Throwable)e);
        }
        return "#";
    }
}

