/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.catalog.Catalog;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import wiremock.org.eclipse.jetty.util.TypeUtil;

public class BaseClassCatalog
implements Catalog,
EntityResolver {
    private final Map<String, String> publicIdMap;
    private final Map<String, String> systemIdMap;

    public static BaseClassCatalog load(URI uriToCatalogXml, Class<?> baseClass) throws IOException {
        return new CatalogReader(uriToCatalogXml, baseClass).parse();
    }

    private BaseClassCatalog(Map<String, String> publicIdMap, Map<String, String> systemIdMap) {
        this.publicIdMap = Objects.requireNonNull(publicIdMap, "Public ID Map");
        this.systemIdMap = Objects.requireNonNull(systemIdMap, "System ID Map");
    }

    @Override
    public Stream<Catalog> catalogs() {
        return Stream.of(new Catalog[0]);
    }

    @Override
    public String matchPublic(String publicId) {
        return this.publicIdMap.get(publicId);
    }

    @Override
    public String matchSystem(String systemId) {
        return this.systemIdMap.get(systemId);
    }

    @Override
    public String matchURI(String uri) {
        for (Map.Entry<String, String> entry : this.publicIdMap.entrySet()) {
            if (!entry.getValue().equals(uri)) continue;
            return entry.getKey();
        }
        for (Map.Entry<String, String> entry : this.systemIdMap.entrySet()) {
            if (!entry.getValue().equals(uri)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        String resolvedSystemId = null;
        if (systemId != null) {
            int idx;
            if (systemId.toLowerCase(Locale.ENGLISH).endsWith(".dtd") && (idx = systemId.lastIndexOf(47)) >= 0) {
                resolvedSystemId = this.matchSystem(systemId.substring(idx + 1));
            }
            if (resolvedSystemId == null) {
                resolvedSystemId = this.matchSystem(systemId);
            }
        }
        if (resolvedSystemId == null && publicId != null) {
            resolvedSystemId = this.matchPublic(publicId);
        }
        if (resolvedSystemId == null && systemId != null) {
            resolvedSystemId = this.matchURI(systemId);
        }
        if (resolvedSystemId != null) {
            return new InputSource(resolvedSystemId);
        }
        return null;
    }

    private static class CatalogReader {
        private final URI catalogUri;
        private final Class<?> baseClass;

        public CatalogReader(URI uriToCatalogXml, Class<?> baseClass) {
            this.catalogUri = Objects.requireNonNull(uriToCatalogXml, "Catalog XML");
            this.baseClass = Objects.requireNonNull(baseClass, "Base Class");
        }

        public BaseClassCatalog parse() throws IOException {
            BaseClassCatalog baseClassCatalog;
            block8: {
                InputStream in = this.catalogUri.toURL().openStream();
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setValidating(false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    dbf.setFeature("http://apache.org/xml/features/validation/schema", false);
                    dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    InputSource input = new InputSource(in);
                    Document doc = db.parse(input);
                    Element root = doc.getDocumentElement();
                    Map<String, String> publicIdMap = this.getMapping(root, "public", "publicId");
                    Map<String, String> systemIdMap = this.getMapping(root, "system", "systemId");
                    baseClassCatalog = new BaseClassCatalog(publicIdMap, systemIdMap);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ParserConfigurationException | SAXException e) {
                        throw new IOException("Unable to parse: " + String.valueOf(this.catalogUri), e);
                    }
                }
                in.close();
            }
            return baseClassCatalog;
        }

        private Map<String, String> getMapping(Element root, String elementName, String attrIdName) throws IOException {
            HashMap<String, String> mapping = new HashMap<String, String>();
            NodeList nodeList = root.getElementsByTagNameNS("*", elementName);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element elem = (Element)nodeList.item(i2);
                String id = elem.getAttribute(attrIdName);
                String ref = elem.getAttribute("uri");
                try {
                    if (new URI(ref).isAbsolute()) {
                        mapping.put(id, ref);
                        continue;
                    }
                    URL url = this.baseClass.getResource(ref);
                    if (url == null) {
                        throw new FileNotFoundException("Unable to find ref [%s/%s] in same archive as %s: %s".formatted(this.baseClass.getPackageName().replace('.', '/'), ref, this.baseClass.getName(), TypeUtil.getLocationOfClass(this.baseClass)));
                    }
                    mapping.put(id, url.toExternalForm());
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new IOException("Unable to parse %s - bad URI in: %s".formatted(this.catalogUri, elem), e);
                }
            }
            return mapping;
        }
    }
}

