/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.regex.Pattern;
import wiremock.org.eclipse.jetty.util.StringUtil;

public class FileID {
    private static final Pattern NUMBER = Pattern.compile("[0-9]+");

    public static String getBasename(Path path) {
        Path filename = path.getFileName();
        if (filename == null) {
            return "";
        }
        String basename = filename.toString();
        int dot = basename.lastIndexOf(46);
        if (dot >= 0) {
            basename = basename.substring(0, dot);
        }
        return basename;
    }

    public static String getFileName(URI uri) {
        if (uri == null) {
            return "";
        }
        if (uri.isOpaque()) {
            return FileID.getFileName(uri.getSchemeSpecificPart());
        }
        return FileID.getFileName(uri.getPath());
    }

    public static String getFileName(String path) {
        if (path == null || "/".equals(path)) {
            return "";
        }
        int idx = path.lastIndexOf(47);
        if (idx >= 0) {
            if (idx == path.length() - 1) {
                int previousSlash = path.lastIndexOf(47, idx - 1);
                if (previousSlash >= 0) {
                    return path.substring(previousSlash + 1, idx);
                }
                return path.substring(0, idx);
            }
            return path.substring(idx + 1);
        }
        return path;
    }

    public static String getExtension(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.getScheme() == null) {
            return null;
        }
        String path = null;
        if (uri.getScheme().equalsIgnoreCase("jar")) {
            URI sspUri = URI.create(uri.getRawSchemeSpecificPart());
            if (!sspUri.getScheme().equalsIgnoreCase("file")) {
                return null;
            }
            path = sspUri.getPath();
        } else {
            path = uri.getPath();
        }
        int jarEnd = path.indexOf("!/");
        if (jarEnd >= 0) {
            return FileID.getExtension(path.substring(0, jarEnd));
        }
        return FileID.getExtension(path);
    }

    public static String getExtension(Path path) {
        if (path == null) {
            return null;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        return FileID.getExtension(path.getFileName().toString());
    }

    public static String getExtension(String filename) {
        int lastDot;
        if (filename == null) {
            return null;
        }
        if (filename.endsWith("/") || filename.endsWith("\\")) {
            return null;
        }
        int lastSlash = filename.lastIndexOf(File.separator);
        if (lastSlash >= 0) {
            filename = filename.substring(lastSlash + 1);
        }
        if ((lastDot = filename.lastIndexOf(46)) <= 0) {
            return null;
        }
        return filename.substring(lastDot + 1).toLowerCase(Locale.ENGLISH);
    }

    public static boolean isExtension(Path path, String ... extensions) {
        return FileID.matchesExtension(FileID.getExtension(path), extensions);
    }

    public static boolean isExtension(URI uri, String ... extensions) {
        return FileID.matchesExtension(FileID.getExtension(uri), extensions);
    }

    public static boolean isExtension(String filename, String ... extensions) {
        return FileID.matchesExtension(FileID.getExtension(filename), extensions);
    }

    private static boolean matchesExtension(String ext, String ... extensions) {
        if (ext == null) {
            return false;
        }
        for (String extension : extensions) {
            if (!ext.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNamedPathSegment(Path path, String segmentName) {
        if (path == null) {
            return false;
        }
        int segmentCount = path.getNameCount();
        for (int i2 = segmentCount - 1; i2 >= 0; --i2) {
            Path segment = path.getName(i2);
            if (!segment.getFileName().toString().equalsIgnoreCase(segmentName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchive(Path path) {
        return FileID.isExtension(path, "jar", "war", "zip");
    }

    public static boolean isArchive(String filename) {
        return FileID.isExtension(filename, "jar", "war", "zip");
    }

    public static boolean isArchive(URI uri) {
        return FileID.isExtension(uri, "jar", "war", "zip");
    }

    public static boolean isLibArchive(Path path) {
        return FileID.isExtension(path, "jar", "zip");
    }

    public static boolean isLibArchive(String filename) {
        return FileID.isExtension(filename, "jar", "zip");
    }

    public static boolean isLibArchive(URI uri) {
        return FileID.isExtension(uri, "jar", "zip");
    }

    public static boolean isClassFile(Path path) {
        Path fileNamePath = path.getFileName();
        if (fileNamePath == null) {
            return false;
        }
        String filename = fileNamePath.toString();
        if (!StringUtil.asciiEndsWithIgnoreCase(filename, ".class")) {
            return false;
        }
        int start = 0;
        int end = filename.length() - 6;
        if (end <= start) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(filename.charAt(0))) {
            return false;
        }
        for (int i2 = start + 1; i2 < end; ++i2) {
            if (Character.isJavaIdentifierPart(filename.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHidden(Path path) {
        int count = path.getNameCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Path segment = path.getName(i2);
            String segmentName = segment.toString();
            if (segmentName.isBlank()) continue;
            if (segmentName.charAt(0) == '.') {
                return true;
            }
            try {
                if (!Files.isHidden(segment)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isHidden(Path base, Path path) {
        return FileID.isHidden(base.relativize(path));
    }

    public static boolean isJavaArchive(URI uri) {
        return FileID.isExtension(uri, "jar");
    }

    public static boolean isJavaArchive(Path path) {
        return FileID.isExtension(path, "jar");
    }

    public static boolean isJavaArchive(String filename) {
        return FileID.isExtension(filename, "jar");
    }

    public static boolean isMetaInfVersions(Path path) {
        if (path.getNameCount() < 3) {
            return false;
        }
        if (!StringUtil.asciiEqualsIgnoreCase("META-INF", path.getName(0).toString())) {
            return false;
        }
        if (!StringUtil.asciiEqualsIgnoreCase("versions", path.getName(1).toString())) {
            return false;
        }
        return NUMBER.matcher(path.getName(2).getFileName().toString()).matches();
    }

    public static boolean isNotMetaInfVersions(Path path) {
        return !FileID.isMetaInfVersions(path);
    }

    public static boolean isModuleInfoClass(Path path) {
        Path filenameSegment = path.getFileName();
        if (filenameSegment == null) {
            return false;
        }
        return filenameSegment.toString().equalsIgnoreCase("module-info.class");
    }

    public static boolean isNotModuleInfoClass(Path path) {
        return !FileID.isModuleInfoClass(path);
    }

    public static boolean isTld(Path path) {
        if (path == null) {
            return false;
        }
        if (!FileID.hasNamedPathSegment(path, "META-INF")) {
            return false;
        }
        return FileID.isExtension(path, "tld");
    }

    public static boolean isWebArchive(Path path) {
        return FileID.isExtension(path, "war");
    }

    public static boolean isWebArchive(URI uri) {
        return FileID.isExtension(uri, "war");
    }

    public static boolean isWebArchive(String filename) {
        return FileID.isExtension(filename, "war");
    }

    public static boolean isXml(Path path) {
        return FileID.isExtension(path, "xml");
    }

    public static boolean isXml(String filename) {
        return FileID.isExtension(filename, "xml");
    }
}

