/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.server.AliasCheck;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.Context;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.NetworkConnector;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.SymlinkAllowedResourceAliasChecker;
import wiremock.org.eclipse.jetty.server.handler.ContextRequest;
import wiremock.org.eclipse.jetty.server.handler.ContextResponse;
import wiremock.org.eclipse.jetty.util.Attributes;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.DecoratedObjectFactory;
import wiremock.org.eclipse.jetty.util.IO;
import wiremock.org.eclipse.jetty.util.Index;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.URIUtil;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;
import wiremock.org.eclipse.jetty.util.component.ClassLoaderDump;
import wiremock.org.eclipse.jetty.util.component.DumpableAttributes;
import wiremock.org.eclipse.jetty.util.component.LifeCycle;
import wiremock.org.eclipse.jetty.util.resource.MountedPathResource;
import wiremock.org.eclipse.jetty.util.resource.Resource;
import wiremock.org.eclipse.jetty.util.resource.ResourceFactory;
import wiremock.org.eclipse.jetty.util.resource.Resources;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@ManagedObject
public class ContextHandler
extends Handler.Wrapper
implements Attributes,
AliasCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ContextHandler.class);
    private static final ThreadLocal<Context> __context = new ThreadLocal();
    public static final String MANAGED_ATTRIBUTES = "wiremock.org.eclipse.jetty.server.context.ManagedAttributes";
    public static final String CROSS_CONTEXT_ATTRIBUTE = "wiremock.org.eclipse.jetty.CrossContextDispatch";
    private final ScopedContext _context;
    private final Attributes _persistentAttributes = new Attributes.Mapped();
    private final MimeTypes.Wrapper _mimeTypes = new MimeTypes.Wrapper();
    private final List<ContextScopeListener> _contextListeners = new CopyOnWriteArrayList<ContextScopeListener>();
    private final List<VHost> _vhosts = new ArrayList<VHost>();
    private String _displayName;
    private String _contextPath = "/";
    private boolean _rootContext = true;
    private Resource _baseResource;
    private ClassLoader _classLoader;
    private Request.Handler _errorHandler;
    private boolean _allowNullPathInContext;
    private Index<ProtectedTargetType> _protectedTargets = Index.empty(false);
    private final List<AliasCheck> _aliasChecks = new CopyOnWriteArrayList<AliasCheck>();
    private File _tempDirectory;
    private boolean _tempDirectoryPersisted = false;
    private boolean _tempDirectoryCreated = false;
    private boolean _createdTempDirectoryName = false;
    private boolean _crossContextDispatchSupported = false;
    private final AtomicReference<Availability> _availability = new AtomicReference<Availability>(Availability.STOPPED);

    public static Context getCurrentContext() {
        return __context.get();
    }

    public static Context getCurrentContext(Server server) {
        Context context = __context.get();
        return context == null ? (server == null ? null : server.getContext()) : context;
    }

    public static ContextHandler getCurrentContextHandler() {
        ContextHandler contextHandler;
        Context context = ContextHandler.getCurrentContext();
        if (context instanceof ScopedContext) {
            ScopedContext scopedContext = (ScopedContext)context;
            contextHandler = (ContextHandler)scopedContext.getContextHandler();
        } else {
            contextHandler = null;
        }
        return contextHandler;
    }

    public static ContextHandler getContextHandler(Request request) {
        ContextHandler contextHandler;
        ContextRequest contextRequest = Request.as(request, ContextRequest.class);
        if (contextRequest == null) {
            return null;
        }
        Context context = contextRequest.getContext();
        if (context instanceof ScopedContext) {
            ScopedContext scoped = (ScopedContext)context;
            contextHandler = (ContextHandler)scoped.getContextHandler();
        } else {
            contextHandler = null;
        }
        return contextHandler;
    }

    public ContextHandler() {
        this(null, null);
    }

    public ContextHandler(Handler handler) {
        this(handler, null);
    }

    public ContextHandler(String contextPath) {
        this(null, contextPath);
    }

    public ContextHandler(Handler handler, String contextPath) {
        super(handler);
        ClassLoader classLoader;
        this._context = this.newContext();
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        if (File.separatorChar == '/') {
            this.addAliasCheck(new SymlinkAllowedResourceAliasChecker(this));
        }
        if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (classLoader != Server.class.getClassLoader()) {
            this._classLoader = classLoader;
        }
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        this._mimeTypes.setWrapped(server.getMimeTypes());
    }

    protected ScopedContext newContext() {
        return new ScopedContext();
    }

    @ManagedAttribute(value="temporary directory location", readonly=true)
    public File getTempDirectory() {
        return this._tempDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        block8: {
            if (this.isStarted()) {
                throw new IllegalStateException("Started");
            }
            File oldTempDirectory = this._tempDirectory;
            if (tempDirectory != null) {
                try {
                    tempDirectory = new File(tempDirectory.getCanonicalPath());
                }
                catch (IOException e) {
                    LOG.warn("Unable to find canonical path for {}", (Object)tempDirectory, (Object)e);
                }
            }
            if (oldTempDirectory != null) {
                try {
                    if (this._createdTempDirectoryName && (tempDirectory == null || !Files.isSameFile(oldTempDirectory.toPath(), tempDirectory.toPath()))) {
                        IO.delete(oldTempDirectory);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug("Unable to delete old temp directory {}", (Object)oldTempDirectory, (Object)e);
                }
            }
        }
        this._tempDirectory = tempDirectory;
        this._createdTempDirectoryName = false;
    }

    public void setTempDirectoryPersistent(boolean persist) {
        this._tempDirectoryPersisted = persist;
    }

    public boolean isTempDirectoryPersistent() {
        return this._tempDirectoryPersisted;
    }

    public MimeTypes.Mutable getMimeTypes() {
        return this._mimeTypes;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new ClassLoaderDump(this.getClassLoader()), new DumpableAttributes("handler attributes", this._persistentAttributes), new DumpableAttributes("attributes", this._context));
    }

    @ManagedAttribute(value="Context")
    public ScopedContext getContext() {
        return this._context;
    }

    @ManagedAttribute(value="Checks if the /context is not redirected to /context/")
    public boolean getAllowNullPathInContext() {
        return this._allowNullPathInContext;
    }

    public void setAllowNullPathInContext(boolean allowNullPathInContext) {
        this._allowNullPathInContext = allowNullPathInContext;
    }

    public void setVirtualHosts(List<String> vhosts) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._vhosts.clear();
        if (vhosts != null && !vhosts.isEmpty()) {
            for (String vhost : vhosts) {
                if (vhost == null) continue;
                this._vhosts.add(new VHost(vhost));
            }
        }
    }

    public void addVirtualHosts(String ... virtualHosts) {
        if (virtualHosts == null || virtualHosts.length == 0) {
            return;
        }
        ArrayList<String> vhosts = new ArrayList<String>(this.getVirtualHosts());
        vhosts.addAll(Arrays.asList(virtualHosts));
        this.setVirtualHosts(vhosts);
    }

    public void removeVirtualHosts(String ... virtualHosts) {
        ArrayList<String> vhosts = new ArrayList<String>(this.getVirtualHosts());
        if (virtualHosts == null || virtualHosts.length == 0 || vhosts.isEmpty()) {
            return;
        }
        for (String vh : virtualHosts) {
            this._vhosts.remove(new VHost(vh));
        }
    }

    @ManagedAttribute(value="Virtual hosts accepted by the context", readonly=true)
    public List<String> getVirtualHosts() {
        return this._vhosts.stream().map(VHost::getName).collect(Collectors.toList());
    }

    @Override
    public Object getAttribute(String name) {
        return this._persistentAttributes.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNameSet() {
        return this._persistentAttributes.getAttributeNameSet();
    }

    @Override
    public Object setAttribute(String name, Object attribute) {
        return this._persistentAttributes.setAttribute(name, attribute);
    }

    @Override
    public Object removeAttribute(String name) {
        return this._persistentAttributes.removeAttribute(name);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setClassLoader(ClassLoader contextLoader) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._classLoader = contextLoader;
    }

    @ManagedAttribute(value="The file classpath")
    public String getClassPath() {
        ClassLoader classLoader;
        if (this._classLoader == null || !((classLoader = this._classLoader) instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader loader = (URLClassLoader)classLoader;
        String classpath = URIUtil.streamOf(loader).map(URI::toASCIIString).collect(Collectors.joining(File.pathSeparator));
        if (StringUtil.isBlank(classpath)) {
            return null;
        }
        return classpath;
    }

    @ManagedAttribute(value="Context path of the Context")
    public String getContextPath() {
        return this._contextPath;
    }

    @ManagedAttribute(value="Display name of the Context")
    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        if ("/".equals(this._contextPath)) {
            return "ROOT";
        }
        return this._contextPath;
    }

    @ManagedAttribute(value="Cross context dispatch is support by the context")
    public boolean isCrossContextDispatchSupported() {
        return this._crossContextDispatchSupported;
    }

    public void setCrossContextDispatchSupported(boolean crossContextDispatchSupported) {
        this._crossContextDispatchSupported = crossContextDispatchSupported;
    }

    public ContextHandler getCrossContextHandler(String path) {
        ContextHandler contextHandler2;
        if (!this.isCrossContextDispatchSupported()) {
            return null;
        }
        ArrayList<ContextHandler> contexts = new ArrayList<ContextHandler>();
        for (ContextHandler contextHandler2 : this.getServer().getDescendants(ContextHandler.class)) {
            String contextPath;
            if (contextHandler2 == null || !contextHandler2.isCrossContextDispatchSupported() || !path.equals(contextPath = contextHandler2.getContextPath()) && (!path.startsWith(contextPath) || path.charAt(contextPath.length()) != '/') && !"/".equals(contextPath)) continue;
            contexts.add(contextHandler2);
        }
        if (contexts.isEmpty()) {
            return null;
        }
        if (contexts.size() == 1) {
            return (ContextHandler)contexts.get(0);
        }
        List<String> vhosts = this.getVirtualHosts();
        if (vhosts != null && !vhosts.isEmpty()) {
            ListIterator i2 = contexts.listIterator();
            while (i2.hasNext()) {
                ContextHandler ch = (ContextHandler)i2.next();
                List<String> targetVhosts = ch.getVirtualHosts();
                if (targetVhosts != null && !targetVhosts.isEmpty() && !Collections.disjoint(vhosts, targetVhosts)) continue;
                i2.remove();
            }
        }
        if (contexts.isEmpty()) {
            return null;
        }
        contextHandler2 = null;
        for (ContextHandler c : contexts) {
            if (contextHandler2 != null && c.getContextPath().length() <= contextHandler2.getContextPath().length()) continue;
            contextHandler2 = c;
        }
        return contextHandler2;
    }

    @Override
    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if (listener instanceof ContextScopeListener) {
                ContextScopeListener contextScopeListener = (ContextScopeListener)listener;
                this._contextListeners.add(contextScopeListener);
                if (__context.get() != null) {
                    contextScopeListener.enterScope(__context.get(), null);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof ContextScopeListener) {
                ContextScopeListener contextScopeListener = (ContextScopeListener)listener;
                this._contextListeners.remove(contextScopeListener);
                if (__context.get() != null) {
                    contextScopeListener.exitScope(__context.get(), null);
                }
            }
            return true;
        }
        return false;
    }

    protected ClassLoader enterScope(Request contextRequest) {
        ClassLoader lastLoader = Thread.currentThread().getContextClassLoader();
        __context.set(this._context);
        if (this._classLoader != null) {
            Thread.currentThread().setContextClassLoader(this._classLoader);
        }
        this.notifyEnterScope(contextRequest);
        return lastLoader;
    }

    protected void notifyEnterScope(Request request) {
        for (ContextScopeListener listener : this._contextListeners) {
            try {
                listener.enterScope(this._context, request);
            }
            catch (Throwable e) {
                LOG.warn("Unable to enter scope", e);
            }
        }
    }

    protected void exitScope(Request request, Context lastContext, ClassLoader lastLoader) {
        this.notifyExitScope(request);
        __context.set(lastContext);
        Thread.currentThread().setContextClassLoader(lastLoader);
    }

    protected void notifyExitScope(Request request) {
        ListIterator<ContextScopeListener> i2 = TypeUtil.listIteratorAtEnd(this._contextListeners);
        while (i2.hasPrevious()) {
            try {
                i2.previous().exitScope(this._context, request);
            }
            catch (Throwable e) {
                LOG.warn("Unable to exit scope", e);
            }
        }
    }

    public boolean isAvailable() {
        return this._availability.get() == Availability.AVAILABLE && this.isStarted();
    }

    public void setAvailable(boolean available) {
        block11: {
            if (available) {
                block7: while (true) {
                    Availability availability = this._availability.get();
                    switch (availability.ordinal()) {
                        case 2: {
                            break block11;
                        }
                        case 3: {
                            if (!this._availability.compareAndSet(availability, Availability.AVAILABLE)) {
                                continue block7;
                            }
                            break block11;
                        }
                        default: {
                            throw new IllegalStateException(availability.toString());
                        }
                    }
                    break;
                }
            }
            block8: while (true) {
                Availability availability = this._availability.get();
                switch (availability.ordinal()) {
                    case 1: 
                    case 2: {
                        if (!this._availability.compareAndSet(availability, Availability.UNAVAILABLE)) continue block8;
                        return;
                    }
                }
                break;
            }
            return;
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.getContextPath() == null) {
            throw new IllegalStateException("Null contextPath");
        }
        Resource baseResource = this.getBaseResource();
        if (baseResource != null) {
            if (!Resources.isReadable(baseResource)) {
                throw new IllegalArgumentException("Base Resource is not valid: " + String.valueOf(baseResource));
            }
            if (baseResource.isAlias()) {
                URI realUri = baseResource.getRealURI();
                if (realUri == null) {
                    LOG.warn("{} Base Resource should not be an alias (100% of requests to context are subject to Security/Alias Checks): {}", (Object)this.getDisplayName(), (Object)baseResource);
                } else {
                    LOG.info("{} Base Resource is an alias: {} -> {}", this.getDisplayName(), baseResource, realUri.toASCIIString());
                    this.setAttribute("_baseResource", this._baseResource);
                    this._baseResource = ResourceFactory.of(this).newResource(realUri);
                }
            }
        }
        this._availability.set(Availability.STARTING);
        try {
            this.createTempDirectory();
            this._context.call(() -> super.doStart(), null);
            this._availability.compareAndSet(Availability.STARTING, Availability.AVAILABLE);
            LOG.info("Started {}", (Object)this);
        }
        finally {
            this._availability.compareAndSet(Availability.STARTING, Availability.UNAVAILABLE);
        }
    }

    protected void createTempDirectory() {
        File tempDirectory = this.getTempDirectory();
        if (tempDirectory != null && !this._tempDirectoryCreated) {
            this._tempDirectoryCreated = true;
            if (this.isTempDirectoryPersistent()) {
                if (!tempDirectory.exists() && !tempDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to create temp dir: " + String.valueOf(tempDirectory));
                }
            } else {
                if (tempDirectory.exists() && !IO.delete(tempDirectory)) {
                    throw new IllegalArgumentException("Failed to delete temp dir: " + String.valueOf(tempDirectory));
                }
                if (!tempDirectory.mkdirs()) {
                    throw new IllegalArgumentException("Unable to create temp dir: " + String.valueOf(tempDirectory));
                }
                tempDirectory.deleteOnExit();
            }
            if (!tempDirectory.canWrite() || !tempDirectory.isDirectory()) {
                throw new IllegalArgumentException("Temp dir " + String.valueOf(tempDirectory) + " not usable: writeable=" + tempDirectory.canWrite() + ", dir=" + tempDirectory.isDirectory());
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        this._context.call(() -> super.doStop(), null);
        this.cleanupAfterStop();
        this._tempDirectoryCreated = false;
        Object object = this.removeAttribute("_baseResource");
        if (object instanceof Resource) {
            Resource baseResource;
            this._baseResource = baseResource = (Resource)object;
        }
    }

    protected void cleanupAfterStop() throws Exception {
        File tempDirectory = this.getTempDirectory();
        if (tempDirectory != null && tempDirectory.exists() && !this.isTempDirectoryPersistent()) {
            IO.delete(tempDirectory);
        }
        if (this._createdTempDirectoryName) {
            this.setTempDirectory(null);
            this._createdTempDirectoryName = false;
        }
    }

    protected void makeTempDirectory() throws Exception {
        File tmpDir;
        File parent = this.getServer().getContext().getTempDirectory();
        if (!(parent != null && parent.exists() && parent.canWrite() && parent.isDirectory())) {
            throw new IllegalStateException("Parent for temp dir not configured correctly: " + (String)(parent == null ? "null" : "writeable=" + parent.canWrite()));
        }
        boolean persistent = this.isTempDirectoryPersistent() || "work".equals(parent.toPath().getFileName().toString());
        String temp = this.getCanonicalNameForTmpDir();
        if (persistent) {
            tmpDir = new File(parent, temp);
        } else {
            tmpDir = Files.createTempDirectory(parent.toPath(), temp, new FileAttribute[0]).toFile();
            tmpDir.deleteOnExit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set temp dir {}", (Object)tmpDir);
        }
        this.setTempDirectory(tmpDir);
        this.setTempDirectoryPersistent(persistent);
        this._createdTempDirectoryName = true;
    }

    protected String getCanonicalNameForTmpDir() {
        Connector[] connectors;
        StringBuilder canonicalName = new StringBuilder();
        canonicalName.append("jetty-");
        Server server = this.getServer();
        if (server != null && (connectors = server.getConnectors()).length > 0) {
            String host = null;
            int port = 0;
            Connector connector = connectors[0];
            if (connector instanceof NetworkConnector) {
                NetworkConnector connector2 = (NetworkConnector)connector;
                host = connector2.getHost();
                port = connector2.getLocalPort();
                if (port < 0) {
                    port = connector2.getPort();
                }
            }
            if (host == null) {
                host = "0.0.0.0";
            }
            canonicalName.append(host);
            canonicalName.append("-");
            canonicalName.append(port);
            canonicalName.append("-");
        }
        try {
            Resource resource = this.getResourceForTempDirName();
            String resourceBaseName = ContextHandler.getBaseName(resource);
            canonicalName.append(resourceBaseName);
            canonicalName.append("-");
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't get resource base name", e);
            }
            canonicalName.append("-");
        }
        String contextPath = this.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("-");
        List<String> vhosts = this.getVirtualHosts();
        if (vhosts == null || vhosts.size() <= 0) {
            canonicalName.append("any");
        } else {
            canonicalName.append(vhosts.get(0));
        }
        for (int i2 = 0; i2 < canonicalName.length(); ++i2) {
            char c = canonicalName.charAt(i2);
            if (Character.isJavaIdentifierPart(c) || "-.".indexOf(c) >= 0) continue;
            canonicalName.setCharAt(i2, '.');
        }
        canonicalName.append("-");
        return StringUtil.sanitizeFileSystemName(canonicalName.toString());
    }

    protected Resource getResourceForTempDirName() {
        return this.getBaseResource();
    }

    protected static String getBaseName(Resource resource) {
        Path resourceFile = resource.getPath();
        if (resourceFile != null && resource instanceof MountedPathResource) {
            resourceFile = ((MountedPathResource)resource).getContainerPath();
        }
        if (resourceFile != null) {
            Path fileName = resourceFile.getFileName();
            return fileName == null ? "" : fileName.toString();
        }
        URI uri = resource.getURI();
        if (uri == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource has no URI reference: {}", (Object)resource);
            }
            return "";
        }
        return URIUtil.getUriLastPathSegment(uri);
    }

    public boolean checkVirtualHost(Request request) {
        if (this._vhosts.isEmpty()) {
            return true;
        }
        String host = Request.getServerName(request);
        String connectorName = request.getConnectionMetaData().getConnector().getName();
        for (VHost vhost : this._vhosts) {
            if (!vhost.matches(connectorName, host)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        this._context.run(() -> super.destroy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler handler = this.getHandler();
        if (handler == null || !this.isStarted()) {
            return false;
        }
        if (!this.checkVirtualHost(request)) {
            return false;
        }
        String path = request.getHttpURI().getCanonicalPath();
        String pathInContext = this._context.getPathInContext(path);
        if (pathInContext == null) {
            return false;
        }
        if (!this.isAvailable()) {
            this.handleUnavailable(request, response, callback);
            return true;
        }
        if (pathInContext.isEmpty() && !this.getAllowNullPathInContext()) {
            this.handleMovedPermanently(request, response, callback);
            return true;
        }
        ContextRequest contextRequest = this.wrapRequest(request, response);
        if (contextRequest == null) {
            return false;
        }
        if (this.handleByContextHandler(pathInContext, contextRequest, response, callback)) {
            return true;
        }
        Context lastContext = ContextHandler.getCurrentContext();
        ClassLoader lastLoader = this.enterScope(contextRequest);
        ContextResponse contextResponse = this.wrapResponse(contextRequest, response);
        try {
            boolean bl = handler.handle(contextRequest, contextResponse, callback);
            return bl;
        }
        catch (Throwable t) {
            Response.writeError((Request)contextRequest, (Response)contextResponse, callback, t);
            boolean bl = true;
            return bl;
        }
        finally {
            this.exitScope(contextRequest, lastContext, lastLoader);
        }
    }

    protected boolean handleByContextHandler(String pathInContext, ContextRequest request, Response response, Callback callback) {
        if (this.isProtectedTarget(pathInContext)) {
            Response.writeError(request, response, callback, 404, null);
            return true;
        }
        return false;
    }

    protected void handleMovedPermanently(Request request, Response response, Callback callback) {
        String location = this._contextPath + "/";
        if (request.getHttpURI().getParam() != null) {
            location = location + ";" + request.getHttpURI().getParam();
        }
        if (request.getHttpURI().getQuery() != null) {
            location = location + "?" + request.getHttpURI().getQuery();
        }
        response.setStatus(301);
        response.getHeaders().add(new HttpField(HttpHeader.LOCATION, location));
        callback.succeeded();
    }

    protected void handleUnavailable(Request request, Response response, Callback callback) {
        Response.writeError(request, response, callback, 503, null);
    }

    public void setContextPath(String contextPath) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._contextPath = URIUtil.canonicalPath(Objects.requireNonNull(contextPath));
        this._rootContext = "/".equals(contextPath);
    }

    public void setDisplayName(String servletContextName) {
        this._displayName = servletContextName;
    }

    @ManagedAttribute(value="document root for context", readonly=true)
    public Resource getBaseResource() {
        return this._baseResource;
    }

    public void setBaseResource(Resource resourceBase) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._baseResource = resourceBase;
    }

    public void setBaseResourceAsPath(Path path) {
        this.setBaseResource(path == null ? null : ResourceFactory.of(this).newResource(path));
    }

    public void setBaseResourceAsString(String base) {
        this.setBaseResource(base == null ? null : ResourceFactory.of(this).newResource(base));
    }

    @ManagedAttribute(value="The error handler to use for the context")
    public Request.Handler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(Request.Handler errorHandler) {
        this.updateBean(this._errorHandler, errorHandler, true);
        this._errorHandler = errorHandler;
    }

    protected ContextRequest wrapRequest(Request request, Response response) {
        return new ContextRequest(this._context, request);
    }

    protected ContextResponse wrapResponse(ContextRequest request, Response response) {
        return new ContextResponse(this._context, request, response);
    }

    @Override
    public void clearAttributes() {
        this._persistentAttributes.clearAttributes();
    }

    public boolean isProtectedTarget(String target) {
        ProtectedTargetType type;
        if (target == null || this._protectedTargets.isEmpty()) {
            return false;
        }
        if (target.startsWith("//")) {
            target = URIUtil.compactPath(target);
        }
        return (type = this._protectedTargets.getBest(target)) == ProtectedTargetType.PREFIX || type == ProtectedTargetType.EXACT && this._protectedTargets.get(target) == ProtectedTargetType.EXACT;
    }

    public void setProtectedTargets(String[] targets) {
        Index.Builder<ProtectedTargetType> builder = new Index.Builder<ProtectedTargetType>();
        if (targets != null) {
            for (String t : targets) {
                if (!t.startsWith("/")) {
                    throw new IllegalArgumentException("Bad protected target: " + t);
                }
                builder.with(t, ProtectedTargetType.EXACT);
                builder.with(t + "/", ProtectedTargetType.PREFIX);
                builder.with(t + "?", ProtectedTargetType.PREFIX);
                builder.with(t + "#", ProtectedTargetType.PREFIX);
                builder.with(t + ";", ProtectedTargetType.PREFIX);
            }
        }
        this._protectedTargets = builder.caseSensitive(false).build();
    }

    public String[] getProtectedTargets() {
        if (this._protectedTargets == null) {
            return null;
        }
        return (String[])this._protectedTargets.keySet().stream().filter(s -> this._protectedTargets.get((String)s) == ProtectedTargetType.EXACT).toArray(String[]::new);
    }

    public void addAliasCheck(AliasCheck check) {
        this._aliasChecks.add(check);
        if (check instanceof LifeCycle) {
            this.addManaged((LifeCycle)((Object)check));
        } else {
            this.addBean(check);
        }
    }

    public List<AliasCheck> getAliasChecks() {
        return Collections.unmodifiableList(this._aliasChecks);
    }

    public void setAliasChecks(List<AliasCheck> checks) {
        this.clearAliasChecks();
        checks.forEach(this::addAliasCheck);
    }

    public void clearAliasChecks() {
        this._aliasChecks.forEach(this::removeBean);
        this._aliasChecks.clear();
    }

    @Override
    public boolean checkAlias(String pathInContext, Resource resource) {
        if (resource.isAlias()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aliased resource: {} -> {}", (Object)resource, (Object)resource.getRealURI());
            }
            for (AliasCheck check : this._aliasChecks) {
                if (!check.checkAlias(pathInContext, resource)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Aliased resource: {} approved by {}", (Object)resource, (Object)check);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        Handler nestedHandler;
        List<String> vhosts = this.getVirtualHosts();
        StringBuilder b = new StringBuilder();
        b.append(TypeUtil.toShortName(this.getClass())).append('@').append(Integer.toString(this.hashCode(), 16));
        b.append('{');
        if (this.getDisplayName() != null) {
            b.append(this.getDisplayName()).append(',');
        }
        b.append(this.getContextPath());
        b.append(",b=").append(this.getBaseResource());
        b.append(",a=").append(this._availability);
        if (!vhosts.isEmpty()) {
            b.append(",vh=[");
            b.append(String.join((CharSequence)",", vhosts));
            b.append(']');
        }
        if ((nestedHandler = this.getHandler()) != null) {
            b.append(",h=");
            b.append(nestedHandler);
        }
        b.append('}');
        return b.toString();
    }

    private static String normalizeVirtualHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public class ScopedContext
    extends Attributes.Layer
    implements Context {
        public ScopedContext() {
            super(ContextHandler.this._persistentAttributes);
        }

        public <H extends ContextHandler> H getContextHandler() {
            return (H)ContextHandler.this;
        }

        @Override
        public Request.Handler getErrorHandler() {
            Request.Handler handler = ContextHandler.this.getErrorHandler();
            if (handler == null) {
                handler = ContextHandler.this.getServer().getErrorHandler();
            }
            return handler;
        }

        @Override
        public String getContextPath() {
            return ContextHandler.this._contextPath;
        }

        @Override
        public MimeTypes getMimeTypes() {
            return ContextHandler.this._mimeTypes;
        }

        public String toString() {
            return "%s@%x".formatted(this.getClass().getSimpleName(), ContextHandler.this.hashCode());
        }

        @Override
        public ClassLoader getClassLoader() {
            return ContextHandler.this._classLoader;
        }

        @Override
        public Resource getBaseResource() {
            return ContextHandler.this._baseResource;
        }

        @Override
        public File getTempDirectory() {
            File tempDirectory = ContextHandler.this.getTempDirectory();
            if (tempDirectory == null) {
                tempDirectory = ContextHandler.this.getServer().getContext().getTempDirectory();
            }
            return tempDirectory;
        }

        @Override
        public List<String> getVirtualHosts() {
            return ContextHandler.this.getVirtualHosts();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Invocable.Callable callable, Request request) throws Exception {
            Context lastContext = __context.get();
            if (lastContext == this) {
                callable.call();
            } else {
                ClassLoader lastLoader = ContextHandler.this.enterScope(request);
                try {
                    callable.call();
                }
                finally {
                    ContextHandler.this.exitScope(request, lastContext, lastLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> boolean test(Predicate<T> predicate, T t, Request request) {
            Context lastContext = __context.get();
            if (lastContext == this) {
                return predicate.test(t);
            }
            ClassLoader lastLoader = ContextHandler.this.enterScope(request);
            try {
                boolean bl = predicate.test(t);
                return bl;
            }
            finally {
                ContextHandler.this.exitScope(request, lastContext, lastLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(Consumer<Throwable> consumer, Throwable t, Request request) {
            Context lastContext = __context.get();
            if (lastContext == this) {
                consumer.accept(t);
            } else {
                ClassLoader lastLoader = ContextHandler.this.enterScope(request);
                try {
                    consumer.accept(t);
                }
                finally {
                    ContextHandler.this.exitScope(request, lastContext, lastLoader);
                }
            }
        }

        @Override
        public void run(Runnable runnable) {
            this.run(runnable, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Runnable runnable, Request request) {
            Context lastContext = __context.get();
            if (lastContext == this) {
                runnable.run();
            } else {
                ClassLoader lastLoader = ContextHandler.this.enterScope(request);
                try {
                    runnable.run();
                }
                finally {
                    ContextHandler.this.exitScope(request, lastContext, lastLoader);
                }
            }
        }

        @Override
        public void execute(Runnable runnable) {
            this.execute(runnable, null);
        }

        public void execute(Runnable runnable, Request request) {
            ContextHandler.this.getServer().getContext().execute(() -> this.run(runnable, request));
        }

        protected DecoratedObjectFactory getDecoratedObjectFactory() {
            DecoratedObjectFactory factory = ContextHandler.this.getBean(DecoratedObjectFactory.class);
            if (factory != null) {
                return factory;
            }
            return ContextHandler.this.getServer().getBean(DecoratedObjectFactory.class);
        }

        @Override
        public <T> T decorate(T o) {
            DecoratedObjectFactory factory = this.getDecoratedObjectFactory();
            if (factory != null) {
                return factory.decorate(o);
            }
            return o;
        }

        @Override
        public void destroy(Object o) {
            DecoratedObjectFactory factory = this.getDecoratedObjectFactory();
            if (factory != null) {
                factory.destroy(o);
            }
        }

        @Override
        public String getPathInContext(String canonicallyEncodedPath) {
            return ContextHandler.this._rootContext ? canonicallyEncodedPath : Context.getPathInContext(ContextHandler.this._contextPath, canonicallyEncodedPath);
        }

        @Override
        public boolean isCrossContextDispatch(Request request) {
            return ContextHandler.this.isCrossContextDispatchSupported() && request.getAttribute(ContextHandler.CROSS_CONTEXT_ATTRIBUTE) != null;
        }

        @Override
        public String getCrossContextDispatchType(Request request) {
            return ContextHandler.this.isCrossContextDispatchSupported() ? (String)request.getAttribute(ContextHandler.CROSS_CONTEXT_ATTRIBUTE) : null;
        }
    }

    public static enum Availability {
        STOPPED,
        STARTING,
        AVAILABLE,
        UNAVAILABLE;

    }

    private static class VHost {
        private final String _vHost;
        private final boolean _wild;
        private final String _vConnector;

        public VHost(String vhost) {
            boolean wild = false;
            String connector = null;
            int at = vhost.indexOf(64);
            if (at >= 0) {
                connector = vhost.substring(at + 1);
                vhost = vhost.substring(0, at);
            }
            if (StringUtil.isBlank(vhost)) {
                vhost = null;
            } else if (vhost.startsWith("*.")) {
                vhost = vhost.substring(1);
                wild = true;
            }
            this._vHost = ContextHandler.normalizeVirtualHostname(vhost);
            this._wild = wild;
            this._vConnector = connector;
        }

        public boolean matches(String connectorName, String host) {
            int offset;
            if (this._vConnector != null) {
                if (!this._vConnector.equalsIgnoreCase(connectorName)) {
                    return false;
                }
                if (this._vHost == null) {
                    return true;
                }
            }
            if (this._vHost != null && host != null && host.regionMatches(true, offset = host.length() - this._vHost.length() - (host.charAt(host.length() - 1) == '.' ? 1 : 0), this._vHost, 0, this._vHost.length())) {
                if (this._wild) {
                    return host.lastIndexOf(46, offset - 1) < 0;
                }
                return offset == 0;
            }
            return false;
        }

        String getVHost() {
            return this._vHost;
        }

        String getName() {
            if (this._vConnector != null) {
                return "@" + this._vConnector;
            }
            return this._vHost;
        }

        public int hashCode() {
            return Objects.hash(this._vHost, this._wild, this._vConnector);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof VHost)) return false;
            VHost vhost = (VHost)o;
            if (!Objects.equals(this._vHost, vhost._vHost)) return false;
            if (!Objects.equals(this._wild, vhost._wild)) return false;
            if (!Objects.equals(this._vConnector, vhost._vConnector)) return false;
            return true;
        }

        public String toString() {
            return "VHost{_vHost='" + this._vHost + "', _wild=" + this._wild + ", _vConnector='" + this._vConnector + "'}";
        }
    }

    public static interface ContextScopeListener
    extends EventListener {
        default public void enterScope(Context context, Request request) {
        }

        default public void exitScope(Context context, Request request) {
        }
    }

    private static enum ProtectedTargetType {
        EXACT,
        PREFIX;

    }
}

