/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.ee10.servlet;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import wiremock.jakarta.servlet.DispatcherType;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.jakarta.servlet.http.MappingMatch;
import wiremock.org.eclipse.jetty.ee10.servlet.ResourceServlet;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import wiremock.org.eclipse.jetty.server.Context;
import wiremock.org.eclipse.jetty.util.URIUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DefaultServlet
extends ResourceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServlet.class);
    public static final String CONTEXT_INIT = "wiremock.org.eclipse.jetty.servlet.Default.";
    private final AtomicBoolean warned = new AtomicBoolean(false);

    @Override
    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter(CONTEXT_INIT + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    @Override
    public void init() throws ServletException {
        if ("true".equalsIgnoreCase(this.getInitParameter("pathInfoOnly"))) {
            LOG.warn("DefaultServlet pathInfoOnly is set to true. Use ResourceServlet instead.");
        }
        super.init();
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(request, response);
        } else {
            super.doPost(request, response);
        }
    }

    @Override
    protected String getEncodedPathInContext(HttpServletRequest request, boolean included) {
        String deprecatedPath = this.getEncodedPathInContext(request, (String)(included ? request.getAttribute("wiremock.jakarta.servlet.include.servlet_path") : null));
        if (deprecatedPath != null) {
            return deprecatedPath;
        }
        if (request.getHttpServletMapping().getMappingMatch() != MappingMatch.DEFAULT) {
            if (this.warned.compareAndSet(false, true)) {
                LOG.warn("Incorrect mapping for DefaultServlet at %s. Use ResourceServlet".formatted(request.getHttpServletMapping().getPattern()));
            }
            return super.getEncodedPathInContext(request, included);
        }
        if (included) {
            Object object = request.getAttribute("wiremock.jakarta.servlet.include.servlet_path");
            if (object instanceof String) {
                String servletPath = (String)object;
                return URIUtil.encodePath(servletPath);
            }
            return URIUtil.encodePath(request.getServletPath());
        }
        if (request instanceof ServletApiRequest) {
            ServletApiRequest apiRequest = (ServletApiRequest)request;
            return Context.getPathInContext(request.getContextPath(), apiRequest.getRequest().getHttpURI().getCanonicalPath());
        }
        return URIUtil.encodePath(request.getServletPath());
    }

    @Deprecated(forRemoval=true)
    protected String getEncodedPathInContext(HttpServletRequest req, String includedServletPath) {
        return null;
    }
}

