/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit.util;

public class IntegerBuffer {
    private static final int INITIAL_SIZE = 512;
    private int[] buffer;
    private int currentSize;

    public IntegerBuffer() {
        this(512);
    }

    public IntegerBuffer(int capacity) {
        this.buffer = new int[capacity];
    }

    public int size() {
        return this.currentSize;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public void append(int i2) {
        while (this.currentSize >= this.buffer.length) {
            this.grow();
        }
        this.buffer[this.currentSize++] = i2;
    }

    public void append(int[] i2) {
        while (this.currentSize + i2.length > this.buffer.length) {
            this.grow();
        }
        System.arraycopy(i2, 0, this.buffer, this.currentSize, i2.length);
        this.currentSize += i2.length;
    }

    public int[] toIntArray() {
        int[] i2 = new int[this.currentSize];
        System.arraycopy(this.buffer, 0, i2, 0, this.currentSize);
        return i2;
    }

    public int indexOf(int[] sequence) {
        int index = -1;
        for (int i2 = 0; index == -1 && i2 <= this.currentSize - sequence.length; ++i2) {
            if (this.buffer[i2] != sequence[0]) continue;
            boolean matches = true;
            for (int j = 1; matches && j < sequence.length; ++j) {
                if (this.buffer[i2 + j] == sequence[j]) continue;
                matches = false;
            }
            if (!matches) continue;
            index = i2;
        }
        return index;
    }

    private void grow() {
        int[] i2 = new int[this.buffer.length * 2 + 1];
        System.arraycopy(this.buffer, 0, i2, 0, this.buffer.length);
        this.buffer = i2;
    }
}

