/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit.jaxp13;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import wiremock.org.custommonkey.xmlunit.NamespaceContext;

public class XMLUnitNamespaceContext2Jaxp13
implements javax.xml.namespace.NamespaceContext {
    private final Map<String, String> nsMap;

    public XMLUnitNamespaceContext2Jaxp13(NamespaceContext ctx) {
        this.nsMap = XMLUnitNamespaceContext2Jaxp13.turnIntoMap(ctx);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null");
        }
        String uri = this.nsMap.get(prefix);
        if (uri == null) {
            uri = "";
        }
        return uri;
    }

    public Iterator getPrefixes(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        TreeSet<String> ts = new TreeSet<String>();
        for (Map.Entry<String, String> entry : this.nsMap.entrySet()) {
            if (!uri.equals(entry.getValue())) continue;
            ts.add(entry.getKey());
        }
        return ts.iterator();
    }

    @Override
    public String getPrefix(String uri) {
        Iterator i2 = this.getPrefixes(uri);
        return i2.hasNext() ? (String)i2.next() : null;
    }

    static Map<String, String> turnIntoMap(NamespaceContext ctx) {
        HashMap<String, String> m = new HashMap<String, String>();
        Iterator i2 = ctx.getPrefixes();
        while (i2.hasNext()) {
            String prefix = (String)i2.next();
            String uri = ctx.getNamespaceURI(prefix);
            if ("http://www.w3.org/XML/1998/namespace".equals(uri) || "http://www.w3.org/2000/xmlns/".equals(uri)) continue;
            m.put(prefix, uri);
        }
        m.put("xml", "http://www.w3.org/XML/1998/namespace");
        m.put("xmlns", "http://www.w3.org/2000/xmlns/");
        return m;
    }
}

