/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ArrayNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaRef;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.com.networknt.schema.utils.JsonSchemaRefs;
import wiremock.com.networknt.schema.utils.SetView;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ItemsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ItemsValidator.class);
    private static final String PROPERTY_ADDITIONAL_ITEMS = "additionalItems";
    private final JsonSchema schema;
    private final List<JsonSchema> tupleSchema;
    private final Boolean additionalItems;
    private final JsonSchema additionalSchema;
    private Boolean hasUnevaluatedItemsValidator = null;
    private final JsonNodePath additionalItemsEvaluationPath;
    private final SchemaLocation additionalItemsSchemaLocation;
    private final JsonNode additionalItemsSchemaNode;

    public ItemsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ITEMS, validationContext);
        Boolean additionalItems = null;
        JsonSchema foundSchema = null;
        JsonSchema foundAdditionalSchema = null;
        JsonNode additionalItemsSchemaNode = null;
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            foundSchema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
            this.tupleSchema = Collections.emptyList();
        } else {
            int i2 = 0;
            this.tupleSchema = new ArrayList<JsonSchema>(schemaNode.size());
            for (JsonNode s : schemaNode) {
                this.tupleSchema.add(validationContext.newSchema(schemaLocation.append(i2), evaluationPath.append(i2), s, parentSchema));
                ++i2;
            }
            JsonNode addItemNode = this.getParentSchema().getSchemaNode().get(PROPERTY_ADDITIONAL_ITEMS);
            if (addItemNode != null) {
                additionalItemsSchemaNode = addItemNode;
                if (addItemNode.isBoolean()) {
                    additionalItems = addItemNode.asBoolean();
                } else if (addItemNode.isObject()) {
                    foundAdditionalSchema = validationContext.newSchema(parentSchema.schemaLocation.append(PROPERTY_ADDITIONAL_ITEMS), parentSchema.evaluationPath.append(PROPERTY_ADDITIONAL_ITEMS), addItemNode, parentSchema);
                }
            }
        }
        this.additionalItems = additionalItems;
        this.schema = foundSchema;
        this.additionalSchema = foundAdditionalSchema;
        this.additionalItemsEvaluationPath = parentSchema.evaluationPath.append(PROPERTY_ADDITIONAL_ITEMS);
        this.additionalItemsSchemaLocation = parentSchema.schemaLocation.append(PROPERTY_ADDITIONAL_ITEMS);
        this.additionalItemsSchemaNode = additionalItemsSchemaNode;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        ItemsValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        if (!node.isArray() && !this.validationContext.getConfig().isTypeLoose()) {
            return Collections.emptySet();
        }
        boolean collectAnnotations = this.collectAnnotations();
        if (collectAnnotations || this.collectAnnotations(executionContext)) {
            if (this.schema != null) {
                executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
            } else if (this.tupleSchema != null) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        }
        boolean hasAdditionalItem = false;
        SetView<ValidationMessage> errors = new SetView<ValidationMessage>();
        if (node.isArray()) {
            int i2 = 0;
            for (JsonNode n : node) {
                if (this.doValidate(executionContext, errors, i2, n, rootNode, instanceLocation)) {
                    hasAdditionalItem = true;
                }
                ++i2;
            }
        } else if (this.doValidate(executionContext, errors, 0, node, rootNode, instanceLocation)) {
            hasAdditionalItem = true;
        }
        if (hasAdditionalItem && (collectAnnotations || this.collectAnnotations(executionContext, PROPERTY_ADDITIONAL_ITEMS))) {
            executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.additionalItemsEvaluationPath).schemaLocation(this.additionalItemsSchemaLocation).keyword(PROPERTY_ADDITIONAL_ITEMS).value(true).build());
        }
        return errors.isEmpty() ? Collections.emptySet() : errors;
    }

    private boolean doValidate(ExecutionContext executionContext, SetView<ValidationMessage> errors, int i2, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        boolean isAdditionalItem = false;
        JsonNodePath path = instanceLocation.append(i2);
        if (this.schema != null) {
            Set<ValidationMessage> results = this.schema.validate(executionContext, node, rootNode, path);
            if (!results.isEmpty()) {
                errors.union(results);
            }
        } else if (this.tupleSchema != null) {
            if (i2 < this.tupleSchema.size()) {
                Set<ValidationMessage> results = this.tupleSchema.get(i2).validate(executionContext, node, rootNode, path);
                if (!results.isEmpty()) {
                    errors.union(results);
                }
            } else {
                if (this.additionalItems != null && this.additionalItems.booleanValue() || this.additionalSchema != null) {
                    isAdditionalItem = true;
                }
                if (this.additionalSchema != null) {
                    Set<ValidationMessage> results = this.additionalSchema.validate(executionContext, node, rootNode, path);
                    if (!results.isEmpty()) {
                        errors.union(results);
                    }
                } else if (this.additionalItems != null && !this.additionalItems.booleanValue()) {
                    errors.union(Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(rootNode)).instanceLocation(instanceLocation)).type(PROPERTY_ADDITIONAL_ITEMS)).messageKey(PROPERTY_ADDITIONAL_ITEMS)).evaluationPath(this.additionalItemsEvaluationPath)).schemaLocation(this.additionalItemsSchemaLocation)).schemaNode(this.additionalItemsSchemaNode)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(i2)).build()));
                }
            }
        }
        return isAdditionalItem;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        boolean collectAnnotations = this.collectAnnotations();
        if (collectAnnotations || this.collectAnnotations(executionContext)) {
            if (this.schema != null) {
                executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
            } else if (this.tupleSchema != null) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        }
        if (this.schema != null) {
            if (node instanceof ArrayNode) {
                int count = Math.max(1, node.size());
                ArrayNode arrayNode = (ArrayNode)node;
                JsonNode defaultNode = null;
                if (this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                    defaultNode = ItemsValidator.getDefaultNode(this.schema);
                }
                for (int i2 = 0; i2 < count; ++i2) {
                    JsonNode n = arrayNode.get(i2);
                    if (n != null && n.isNull() && defaultNode != null) {
                        arrayNode.set(i2, defaultNode);
                        n = defaultNode;
                    }
                    this.walkSchema(executionContext, this.schema, n, rootNode, instanceLocation.append(i2), shouldValidateSchema, validationMessages, ValidatorTypeCode.ITEMS.getValue());
                }
            } else {
                this.walkSchema(executionContext, this.schema, null, rootNode, instanceLocation.append(0), shouldValidateSchema, validationMessages, ValidatorTypeCode.ITEMS.getValue());
            }
        } else if (this.tupleSchema != null) {
            int prefixItems = this.tupleSchema.size();
            for (int i3 = 0; i3 < prefixItems; ++i3) {
                if (node instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)node;
                    JsonNode defaultNode = null;
                    JsonNode n = arrayNode.get(i3);
                    if (this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                        defaultNode = ItemsValidator.getDefaultNode(this.tupleSchema.get(i3));
                    }
                    if (n != null && n.isNull() && defaultNode != null) {
                        arrayNode.set(i3, defaultNode);
                        n = defaultNode;
                    }
                    this.walkSchema(executionContext, this.tupleSchema.get(i3), n, rootNode, instanceLocation.append(i3), shouldValidateSchema, validationMessages, ValidatorTypeCode.ITEMS.getValue());
                    continue;
                }
                this.walkSchema(executionContext, this.tupleSchema.get(i3), null, rootNode, instanceLocation.append(i3), shouldValidateSchema, validationMessages, ValidatorTypeCode.ITEMS.getValue());
            }
            if (this.additionalSchema != null) {
                boolean hasAdditionalItem = false;
                int additionalItems = Math.max(1, (node != null ? node.size() : 0) - prefixItems);
                for (int x = 0; x < additionalItems; ++x) {
                    int i4 = x + prefixItems;
                    if (node instanceof ArrayNode) {
                        ArrayNode arrayNode = (ArrayNode)node;
                        JsonNode defaultNode = null;
                        JsonNode n = arrayNode.get(i4);
                        if (this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                            defaultNode = ItemsValidator.getDefaultNode(this.additionalSchema);
                        }
                        if (n != null && n.isNull() && defaultNode != null) {
                            arrayNode.set(i4, defaultNode);
                            n = defaultNode;
                        }
                        this.walkSchema(executionContext, this.additionalSchema, n, rootNode, instanceLocation.append(i4), shouldValidateSchema, validationMessages, PROPERTY_ADDITIONAL_ITEMS);
                        if (n == null) continue;
                        hasAdditionalItem = true;
                        continue;
                    }
                    this.walkSchema(executionContext, this.additionalSchema, null, rootNode, instanceLocation.append(i4), shouldValidateSchema, validationMessages, PROPERTY_ADDITIONAL_ITEMS);
                }
                if (hasAdditionalItem && (collectAnnotations || this.collectAnnotations(executionContext, PROPERTY_ADDITIONAL_ITEMS))) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.additionalItemsEvaluationPath).schemaLocation(this.additionalItemsSchemaLocation).keyword(PROPERTY_ADDITIONAL_ITEMS).value(true).build());
                }
            }
        }
        return validationMessages;
    }

    private static JsonNode getDefaultNode(JsonSchema schema) {
        JsonSchemaRef schemaRef;
        JsonNode result = schema.getSchemaNode().get("default");
        if (result == null && (schemaRef = JsonSchemaRefs.from(schema)) != null) {
            result = ItemsValidator.getDefaultNode(schemaRef.getSchema());
        }
        return result;
    }

    private void walkSchema(ExecutionContext executionContext, JsonSchema walkSchema, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages, String keyword) {
        boolean executeWalk = this.validationContext.getConfig().getItemWalkListenerRunner().runPreWalkListeners(executionContext, keyword, node, rootNode, instanceLocation, walkSchema, this);
        if (executeWalk) {
            validationMessages.addAll(walkSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema));
        }
        this.validationContext.getConfig().getItemWalkListenerRunner().runPostWalkListeners(executionContext, keyword, node, rootNode, instanceLocation, walkSchema, this, validationMessages);
    }

    public List<JsonSchema> getTupleSchema() {
        return this.tupleSchema;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedItemsValidator();
    }

    private boolean hasUnevaluatedItemsValidator() {
        if (this.hasUnevaluatedItemsValidator == null) {
            this.hasUnevaluatedItemsValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedItems");
        }
        return this.hasUnevaluatedItemsValidator;
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
        this.preloadJsonSchemas(this.tupleSchema);
        if (null != this.additionalSchema) {
            this.additionalSchema.initializeValidators();
        }
        this.collectAnnotations();
    }
}

