/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal.antlr.tree.xpath;

import wiremock.com.github.jknack.handlebars.internal.antlr.CharStream;
import wiremock.com.github.jknack.handlebars.internal.antlr.CommonToken;
import wiremock.com.github.jknack.handlebars.internal.antlr.Lexer;
import wiremock.com.github.jknack.handlebars.internal.antlr.LexerNoViableAltException;
import wiremock.com.github.jknack.handlebars.internal.antlr.Token;
import wiremock.com.github.jknack.handlebars.internal.antlr.Vocabulary;
import wiremock.com.github.jknack.handlebars.internal.antlr.VocabularyImpl;
import wiremock.com.github.jknack.handlebars.internal.antlr.atn.ATN;
import wiremock.com.github.jknack.handlebars.internal.antlr.misc.Interval;

public class XPathLexer
extends Lexer {
    public static final int TOKEN_REF = 1;
    public static final int RULE_REF = 2;
    public static final int ANYWHERE = 3;
    public static final int ROOT = 4;
    public static final int WILDCARD = 5;
    public static final int BANG = 6;
    public static final int ID = 7;
    public static final int STRING = 8;
    public static final String[] modeNames = new String[]{"DEFAULT_MODE"};
    public static final String[] ruleNames = new String[]{"ANYWHERE", "ROOT", "WILDCARD", "BANG", "ID", "NameChar", "NameStartChar", "STRING"};
    private static final String[] _LITERAL_NAMES = new String[]{null, null, null, "'//'", "'/'", "'*'", "'!'"};
    private static final String[] _SYMBOLIC_NAMES = new String[]{null, "TOKEN_REF", "RULE_REF", "ANYWHERE", "ROOT", "WILDCARD", "BANG", "ID", "STRING"};
    public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);
    @Deprecated
    public static final String[] tokenNames = new String[_SYMBOLIC_NAMES.length];
    protected int line = 1;
    protected int charPositionInLine = 0;

    @Override
    public String getGrammarFileName() {
        return "XPathLexer.g4";
    }

    @Override
    public String[] getRuleNames() {
        return ruleNames;
    }

    @Override
    public String[] getModeNames() {
        return modeNames;
    }

    @Override
    @Deprecated
    public String[] getTokenNames() {
        return tokenNames;
    }

    @Override
    public Vocabulary getVocabulary() {
        return VOCABULARY;
    }

    @Override
    public ATN getATN() {
        return null;
    }

    public XPathLexer(CharStream input) {
        super(input);
    }

    @Override
    public Token nextToken() {
        this._tokenStartCharIndex = this._input.index();
        CommonToken t = null;
        block7: while (t == null) {
            switch (this._input.LA(1)) {
                case 47: {
                    this.consume();
                    if (this._input.LA(1) == 47) {
                        this.consume();
                        t = new CommonToken(3, "//");
                        continue block7;
                    }
                    t = new CommonToken(4, "/");
                    continue block7;
                }
                case 42: {
                    this.consume();
                    t = new CommonToken(5, "*");
                    continue block7;
                }
                case 33: {
                    this.consume();
                    t = new CommonToken(6, "!");
                    continue block7;
                }
                case 39: {
                    String s = this.matchString();
                    t = new CommonToken(8, s);
                    continue block7;
                }
                case -1: {
                    return new CommonToken(-1, "<EOF>");
                }
            }
            if (this.isNameStartChar(this._input.LA(1))) {
                String id = this.matchID();
                if (Character.isUpperCase(id.charAt(0))) {
                    t = new CommonToken(1, id);
                    continue;
                }
                t = new CommonToken(2, id);
                continue;
            }
            throw new LexerNoViableAltException(this, this._input, this._tokenStartCharIndex, null);
        }
        t.setStartIndex(this._tokenStartCharIndex);
        t.setCharPositionInLine(this._tokenStartCharIndex);
        t.setLine(this.line);
        return t;
    }

    public void consume() {
        int curChar = this._input.LA(1);
        if (curChar == 10) {
            ++this.line;
            this.charPositionInLine = 0;
        } else {
            ++this.charPositionInLine;
        }
        this._input.consume();
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public String matchID() {
        int start = this._input.index();
        this.consume();
        while (this.isNameChar(this._input.LA(1))) {
            this.consume();
        }
        return this._input.getText(Interval.of(start, this._input.index() - 1));
    }

    public String matchString() {
        int start = this._input.index();
        this.consume();
        while (this._input.LA(1) != 39) {
            this.consume();
        }
        this.consume();
        return this._input.getText(Interval.of(start, this._input.index() - 1));
    }

    public boolean isNameChar(int c) {
        return Character.isUnicodeIdentifierPart(c);
    }

    public boolean isNameStartChar(int c) {
        return Character.isUnicodeIdentifierStart(c);
    }

    static {
        for (int i2 = 0; i2 < tokenNames.length; ++i2) {
            XPathLexer.tokenNames[i2] = VOCABULARY.getLiteralName(i2);
            if (tokenNames[i2] == null) {
                XPathLexer.tokenNames[i2] = VOCABULARY.getSymbolicName(i2);
            }
            if (tokenNames[i2] != null) continue;
            XPathLexer.tokenNames[i2] = "<INVALID>";
        }
    }
}

