/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class EqualToPatternWithCaseInsensitivePrefix
extends StringValuePattern {
    private final String prefix;
    private final String testValue;

    public EqualToPatternWithCaseInsensitivePrefix(@JsonProperty(value="prefix") String prefix, @JsonProperty(value="equalTo") String testValue) {
        super(prefix + testValue);
        Objects.requireNonNull(prefix, "prefix cannot be null");
        this.prefix = prefix;
        this.testValue = testValue;
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return value != null && value.substring(0, EqualToPatternWithCaseInsensitivePrefix.this.prefix.length()).equalsIgnoreCase(EqualToPatternWithCaseInsensitivePrefix.this.prefix) && Objects.equals(EqualToPatternWithCaseInsensitivePrefix.this.testValue, value.substring(EqualToPatternWithCaseInsensitivePrefix.this.prefix.length()));
            }

            @Override
            public double getDistance() {
                return Strings.normalisedLevenshteinDistance((String)EqualToPatternWithCaseInsensitivePrefix.this.expectedValue, value);
            }
        };
    }
}

