/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.security.AccessController;
import java.security.Principal;
import java.util.function.Consumer;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.security.spi.SecurityServices;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldSecurityServices
implements Service,
SecurityServices {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_SECURITY_SERVICES_SERVICE_NAME;
    private final Consumer<SecurityServices> securityServicesConsumer;

    public WeldSecurityServices(Consumer<SecurityServices> securityServicesConsumer) {
        this.securityServicesConsumer = securityServicesConsumer;
    }

    public void start(StartContext context) throws StartException {
        this.securityServicesConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.securityServicesConsumer.accept(null);
    }

    public Principal getPrincipal() {
        SecurityDomain elytronDomain = this.getCurrentSecurityDomain();
        if (elytronDomain != null) {
            return elytronDomain.getCurrentSecurityIdentity().getPrincipal();
        }
        throw WeldLogger.ROOT_LOGGER.securityNotEnabled();
    }

    public void cleanup() {
    }

    public Consumer<Runnable> getSecurityContextAssociator() {
        SecurityDomain elytronDomain = this.getCurrentSecurityDomain();
        if (elytronDomain != null) {
            SecurityIdentity storedSecurityIdentity = elytronDomain.getCurrentSecurityIdentity();
            return action -> storedSecurityIdentity.runAs(action);
        }
        return super.getSecurityContextAssociator();
    }

    private SecurityDomain getCurrentSecurityDomain() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> SecurityDomain.getCurrent());
        }
        return SecurityDomain.getCurrent();
    }
}

