/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.UndeployDescription;

public class ArchiveDeployer {
    private static final Logger log = Logger.getLogger(ArchiveDeployer.class);
    private final DeploymentManager deploymentManager;
    private final ManagementClient client;

    @Deprecated
    public ArchiveDeployer(ModelControllerClient modelControllerClient) {
        this.deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)modelControllerClient);
        this.client = null;
    }

    public ArchiveDeployer(ManagementClient client) {
        this.client = client;
        this.deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client.getControllerClient());
    }

    public String deploy(Archive<?> archive) throws DeploymentException {
        return this.deployInternal(archive);
    }

    public String deploy(String name, InputStream input) throws DeploymentException {
        return this.deployInternal(name, input);
    }

    public void undeploy(String runtimeName) {
        this.undeploy(runtimeName, true);
    }

    public void undeploy(String runtimeName, boolean failOnMissing) {
        this.checkState();
        try {
            DeploymentResult result = this.deploymentManager.undeploy(UndeployDescription.of((String)runtimeName).setFailOnMissing(failOnMissing));
            if (!result.successful()) {
                log.warnf("Failed to undeploy %s: %s", (Object)runtimeName, (Object)result.getFailureMessage());
            }
        }
        catch (Exception ex) {
            log.warnf((Throwable)ex, "Cannot undeploy: %s", (Object)runtimeName);
        }
    }

    public boolean hasDeployment(String name) throws IOException {
        this.checkState();
        return this.deploymentManager.hasDeployment(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deployInternal(Archive<?> archive) throws DeploymentException {
        this.checkState();
        InputStream input = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
        try {
            String string = this.deployInternal(archive.getName(), input);
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warnf((Throwable)e, "Failed to close resource %s", (Object)input);
                }
            }
        }
    }

    private String deployInternal(String name, InputStream input) throws DeploymentException {
        DeploymentResult result;
        this.checkState();
        try {
            result = this.deploymentManager.deploy(Deployment.of((InputStream)input, (String)name));
        }
        catch (Exception ex) {
            throw ArchiveDeployer.createException("Cannot deploy: " + name, ex);
        }
        if (result.successful()) {
            return name;
        }
        throw new DeploymentException(String.format("Cannot deploy %s: %s", name, result.getFailureMessage()));
    }

    private void checkState() {
        if (this.client != null && this.client.isClosed()) {
            throw new IllegalStateException("The client connection has been closed.");
        }
    }

    private static DeploymentException createException(String message, Throwable cause) {
        Throwable currentCause;
        Set causes = Collections.newSetFromMap(new IdentityHashMap());
        Throwable rootCause = currentCause = cause;
        while (currentCause != null) {
            if ((currentCause = currentCause.getCause()) == null) continue;
            causes.add(currentCause);
            rootCause = currentCause;
        }
        DeploymentException result = new DeploymentException(message, rootCause);
        causes.forEach(arg_0 -> result.addSuppressed(arg_0));
        return result;
    }
}

