/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.modalx.optional;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValueConversionException;
import org.wicketstuff.modalx.ModalContentPanel;
import org.wicketstuff.modalx.ModalContentWindow;
import org.wicketstuff.modalx.ModalMgr;

public class ModalXPage
extends WebPage
implements ModalMgr {
    private static final long serialVersionUID = 1L;
    protected ModalContentWindow[] modalContentWindows = new ModalContentWindow[3];
    private int nextModalIdx = 0;
    public static final int MAX_MODALS = 3;

    public ModalXPage(PageParameters iParameters) throws StringValueConversionException {
        super(iParameters);
        for (int m = 0; m < 3; ++m) {
            Form form = new Form("wrapperForm_" + m);
            this.add(new Component[]{form});
            ModalContentWindow modalWindow = new ModalContentWindow(this, "modalWindow_" + m, true);
            modalWindow.setInitialWidth(600);
            modalWindow.setInitialHeight(400);
            form.add(new Component[]{modalWindow});
            this.modalContentWindows[m] = modalWindow;
        }
    }

    @Override
    public void preShow(ModalContentPanel modalContentPanel) {
    }

    @Override
    public void releaseModalWindow(ModalContentWindow modalContentWindow) {
        --this.nextModalIdx;
        if (this.nextModalIdx < 0) {
            System.out.println("release: Too many modal deallocations");
        }
    }

    @Override
    public ModalContentWindow allocateModalWindow() {
        if (this.nextModalIdx < 0) {
            System.out.println("alloc: Too many modal deallocations");
        } else if (this.nextModalIdx >= 3) {
            System.out.println("alloc: Too many modal allocations");
        } else {
            return this.modalContentWindows[this.nextModalIdx++];
        }
        return null;
    }
}

