/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.modalx;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.panel.Panel;
import org.wicketstuff.modalx.IWindowCloseListener;
import org.wicketstuff.modalx.ModalContentWindow;
import org.wicketstuff.modalx.ModalMgr;

public class ModalContentPanel
extends Panel {
    private String variation;
    private static final long serialVersionUID = 1L;
    private String title;
    private int initialWidth = 300;
    private int initialHeight = 300;
    protected IWindowCloseListener windowCloseListener;
    protected ModalContentWindow modalContentWindow;

    public String getVariation() {
        if (this.variation != null) {
            return this.variation;
        }
        return super.getVariation();
    }

    public void setVariation(String variation) {
        this.variation = variation;
    }

    public void closeModal(AjaxRequestTarget target) {
        this.modalContentWindow.close(target);
    }

    public void setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public void setInitialWidth(int initialWidth) {
        this.initialWidth = initialWidth;
    }

    public int getInitialWidth() {
        return this.initialWidth;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void show(AjaxRequestTarget target) {
        this.modalContentWindow.setContent((Component)this);
        this.modalContentWindow.setTitle(this.title);
        this.modalContentWindow.setInitialWidth(this.initialWidth);
        this.modalContentWindow.setInitialHeight(this.initialHeight);
        if (this.windowCloseListener != null) {
            this.modalContentWindow.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
                private static final long serialVersionUID = 1L;

                public void onClose(AjaxRequestTarget target) {
                    ModalMgr modalMgr = ModalContentPanel.this.modalContentWindow.getModalMgr();
                    if (modalMgr != null) {
                        modalMgr.releaseModalWindow(ModalContentPanel.this.modalContentWindow);
                    }
                    ModalContentPanel.this.windowCloseListener.windowClosed(ModalContentPanel.this, target);
                }
            });
        } else {
            this.modalContentWindow.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
                private static final long serialVersionUID = 1L;

                public void onClose(AjaxRequestTarget target) {
                    ModalMgr modalMgr = ModalContentPanel.this.modalContentWindow.getModalMgr();
                    if (modalMgr != null) {
                        modalMgr.releaseModalWindow(ModalContentPanel.this.modalContentWindow);
                    }
                }
            });
        }
        if (this.modalContentWindow.getModalMgr() != null) {
            this.modalContentWindow.getModalMgr().preShow(this);
        }
        this.modalContentWindow.show(target);
    }

    public ModalContentPanel(ModalContentWindow iModalContentWindow, IWindowCloseListener iWindowCloseListener) {
        super(iModalContentWindow.getContentId());
        this.modalContentWindow = iModalContentWindow;
        this.windowCloseListener = iWindowCloseListener;
    }
}

