/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.modalx;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.wicketstuff.modalx.IWindowCloseListener;
import org.wicketstuff.modalx.ModalContentWindow;
import org.wicketstuff.modalx.ModalFormPanel;
import org.wicketstuff.modalx.ModalMgr;

public class MessageBox
extends ModalFormPanel {
    private static final long serialVersionUID = 1L;
    public static final int MB_OK = 0;
    public static final int MB_OK_CANCEL = 1;
    public static final int MB_YES_NO = 2;
    public static final int MB_YES_NO_CANCEL = 3;
    public static final int MR_YES = 3;
    public static final int MR_NO = 4;
    protected transient String message;
    protected transient int buttonConfig;
    private static int defaultWidth = 400;
    private static Logger logger = Logger.getLogger(MessageBox.class);

    public static void setDefaultWidth(int iDefaultWidth) {
        defaultWidth = iDefaultWidth;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    @Override
    public void addControlComponents() {
        Button button;
        if (this.buttonConfig == 0 || this.buttonConfig == 1) {
            button = new Button("ok");
            button.add(new Behavior[]{new AjaxEventBehavior("onclick"){
                private static final long serialVersionUID = 1L;

                protected void onEvent(AjaxRequestTarget target) {
                    MessageBox.this.setModalResult(1);
                    MessageBox.this.closeModal(target);
                }
            }});
            button.setDefaultFormProcessing(false);
            this.form.add(new Component[]{button});
        } else {
            button = new Button("ok");
            button.setVisible(false);
            this.form.add(new Component[]{button});
        }
        if (this.buttonConfig == 2 || this.buttonConfig == 3) {
            button = new Button("yes");
            button.add(new Behavior[]{new AjaxEventBehavior("onclick"){
                private static final long serialVersionUID = 1L;

                protected void onEvent(AjaxRequestTarget target) {
                    MessageBox.this.setModalResult(3);
                    MessageBox.this.closeModal(target);
                }
            }});
            button.setDefaultFormProcessing(false);
            this.form.add(new Component[]{button});
            button = new Button("no");
            button.add(new Behavior[]{new AjaxEventBehavior("onclick"){
                private static final long serialVersionUID = 1L;

                protected void onEvent(AjaxRequestTarget target) {
                    MessageBox.this.setModalResult(4);
                    MessageBox.this.closeModal(target);
                }
            }});
            button.setDefaultFormProcessing(false);
            this.form.add(new Component[]{button});
        } else {
            button = new Button("yes");
            button.setVisible(false);
            this.form.add(new Component[]{button});
            button = new Button("no");
            button.setVisible(false);
            this.form.add(new Component[]{button});
        }
        if (this.buttonConfig == 1 || this.buttonConfig == 3) {
            button = new Button("cancel");
            button.add(new Behavior[]{new AjaxEventBehavior("onclick"){
                private static final long serialVersionUID = 1L;

                protected void onEvent(AjaxRequestTarget target) {
                    MessageBox.this.setModalResult(2);
                    MessageBox.this.onCancel(target);
                }
            }});
            button.setDefaultFormProcessing(false);
            this.form.add(new Component[]{button});
        } else {
            button = new Button("cancel");
            button.setVisible(false);
            this.form.add(new Component[]{button});
        }
    }

    @Override
    public void addFormComponents() {
        MultiLineLabel body = new MultiLineLabel("message", this.message);
        body.setEscapeModelStrings(false);
        this.form.add(new Component[]{body});
    }

    public static MessageBox showFixedHeight(AjaxRequestTarget target, String message, String title, int width, int height) {
        return MessageBox.show(target, message, title, width, height, false, 0, null);
    }

    public static MessageBox show(AjaxRequestTarget target, String message) {
        return MessageBox.show(target, message, "Warning");
    }

    public static MessageBox show(AjaxRequestTarget target, String message, String title) {
        return MessageBox.show(target, message, title, defaultWidth, 240);
    }

    public static MessageBox show(AjaxRequestTarget target, String message, String title, int width, int height) {
        return MessageBox.show(target, message, title, width, height, true, 0, null);
    }

    public static MessageBox show(AjaxRequestTarget target, String message, String title, int width, int height, boolean autoHeight, int buttonConfig, IWindowCloseListener iWindowCloseListener) {
        Page page = target.getPage();
        if (!(page instanceof ModalMgr)) {
            logger.error((Object)"Page is not a ModalMgr. Can not open message box");
            return null;
        }
        ModalMgr modalMgr = (ModalMgr)page;
        MessageBox messageBox = new MessageBox(modalMgr.allocateModalWindow(), message, title, buttonConfig, iWindowCloseListener);
        messageBox.setTitle(title);
        messageBox.modalContentWindow.setResizable(false);
        messageBox.setInitialWidth(width);
        messageBox.modalContentWindow.setUseInitialHeight(!autoHeight);
        messageBox.setInitialHeight(height);
        messageBox.show(target);
        return messageBox;
    }

    public MessageBox(ModalContentWindow iModalContentWindow, String iMessage, String iTitle, int iButtonConfig, IWindowCloseListener iWindowCloseListener) {
        super(iModalContentWindow, iWindowCloseListener);
        this.message = iMessage;
        this.setTitle(iTitle);
        this.buttonConfig = iButtonConfig;
    }
}

