export interface Options {
    element?: Element | Element[];
    onStart?: () => void;
    onStop?: () => void;
    onResult?: OnResult;
    onPreResult?: OnPreResult;
    onCommandModeTrigger?: OnCommandModeTrigger;
    onPauseTrigger?: OnPauseTrigger;
    onError?: OnError;
    displayInterimResults?: boolean;
    insertInCursorLocation?: boolean;
    autoScroll?: boolean;
    textColor?: TextColor;
    translations?: Translations;
    commands?: Commands;
}
export type OnResult = (text: string, isFinal: boolean) => void;
export type OnPreResult = (text: string, isFinal: boolean) => {
    stop?: boolean;
    restart?: boolean;
    removeNewText?: boolean;
} | void | null | undefined;
export type OnCommandModeTrigger = (isStart: boolean) => void;
export type OnPauseTrigger = (isStart: boolean) => void;
export type OnError = (message: string) => void;
export interface TextColor {
    interim?: string;
    final?: string;
}
export interface Translations {
    [key: string]: string;
}
export interface AzureOptions {
    retrieveToken?: () => Promise<string | void>;
    subscriptionKey?: string;
    token?: string;
    region: string;
    language?: string;
    stopAfterSilenceMs?: number;
}
export interface WebSpeechOptions {
    language?: string;
}
export interface Commands {
    stop?: string;
    pause?: string;
    resume?: string;
    reset?: string;
    removeAllText?: string;
    commandMode?: string;
    settings?: {
        substrings?: boolean;
        caseSensitive?: boolean;
    };
}
