/// <reference types="node" />
import { OnCommandModeTrigger, OnPauseTrigger, Options } from './types/options';
import { InternalCommands } from './types/internalCommands';
export declare abstract class Speech {
    finalTranscript: string;
    interimSpan: HTMLSpanElement;
    finalSpan: HTMLSpanElement;
    scrollingSpan: HTMLSpanElement;
    isCursorAtEnd: boolean;
    private _primitiveElement?;
    private _genericElement?;
    spansPopulated: boolean;
    mouseDownEvent?: (event: MouseEvent) => void;
    mouseUpEvent?: (event: MouseEvent) => void;
    keyDownEvent?: (event: KeyboardEvent) => void;
    startPadding: string;
    endPadding: string;
    numberOfSpacesBeforeNewText: number;
    numberOfSpacesAfterNewText: number;
    isHighlighted: boolean;
    primitiveTextRecorded: boolean;
    recognizing: boolean;
    mouseDownElement?: Element;
    private _displayInterimResults;
    private _finalTextColor?;
    stopTimeout?: NodeJS.Timeout;
    stopTimeoutMS?: number;
    insertInCursorLocation: boolean;
    autoScroll: boolean;
    private _onResult?;
    private _onPreResult?;
    private _onStart?;
    private _onStop?;
    private _onError?;
    isRestarting: boolean;
    private _options?;
    private _originalText?;
    onCommandModeTrigger?: OnCommandModeTrigger;
    onPauseTrigger?: OnPauseTrigger;
    isPaused: boolean;
    commands?: InternalCommands;
    isWaitingForCommand: boolean;
    isTargetInShadow: boolean;
    cannotBeStopped: boolean;
    constructor();
    prepareBeforeStart(options?: Options): void;
    private prepare;
    resetRecording(options?: Options): void;
    updateElements(interimTranscript: string, finalTranscript: string, newText: string): void;
    private updatePrimitiveElement;
    private updateGenericElement;
    finalise(isDuringReset?: boolean): void;
    setInterimColorToFinal(): void;
    private resetState;
    setStateOnStart(): void;
    setStateOnStop(): void;
    setStateOnError(details: string): void;
    abstract start(options?: Options, isDuringReset?: boolean): void;
    abstract stop(isDuringReset?: boolean): void;
}
