/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitMediator;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitter;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNImportMediator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNCommitClient
extends SVNBasicClient {
    private ISVNCommitHandler myCommitHandler;
    private ISVNCommitParameters myCommitParameters;

    public SVNCommitClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNCommitClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setCommitHander(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        if (this.myCommitHandler == null) {
            this.myCommitHandler = new DefaultSVNCommitHandler();
        }
        return this.myCommitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        this.myCommitParameters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        if (this.myCommitParameters == null) {
            this.myCommitParameters = new DefaultSVNCommitParameters();
        }
        return this.myCommitParameters;
    }

    public SVNCommitInfo doDelete(SVNURL[] urls, String commitMessage) throws SVNException {
        SVNCommitInfo info;
        if (urls == null || urls.length == 0) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> paths = new ArrayList<String>();
        SVNURL rootURL = SVNURLUtil.condenceURLs(urls, paths, true);
        if (rootURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Can not compute common root URL for specified URLs");
            SVNErrorManager.error(err);
        }
        if (paths.isEmpty()) {
            paths.add(SVNPathUtil.tail(rootURL.getURIEncodedPath()));
            rootURL = rootURL.removePathTail();
        }
        SVNCommitItem[] commitItems = new SVNCommitItem[paths.size()];
        for (int i = 0; i < commitItems.length; ++i) {
            String path = (String)paths.get(i);
            commitItems[i] = new SVNCommitItem(null, rootURL.appendPath(path, true), null, SVNNodeKind.NONE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, false, true, false, false, false, false);
        }
        commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitItems);
        if (commitMessage == null) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> decodedPaths = new ArrayList<String>();
        Iterator commitPaths = paths.iterator();
        while (commitPaths.hasNext()) {
            String path = (String)commitPaths.next();
            decodedPaths.add(SVNEncodingUtil.uriDecode(path));
        }
        paths = decodedPaths;
        SVNRepository repos = this.createRepository(rootURL, true);
        Iterator commitPath = paths.iterator();
        while (commitPath.hasNext()) {
            String path = (String)commitPath.next();
            SVNNodeKind kind = repos.checkPath(path, -1L);
            if (kind != SVNNodeKind.NONE) continue;
            SVNURL url = rootURL.appendPath(path, false);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' does not exist", url);
            SVNErrorManager.error(err);
        }
        commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
        ISVNEditor commitEditor = repos.getCommitEditor(commitMessage, null, false, null);
        ISVNCommitPathHandler deleter = new ISVNCommitPathHandler(){

            public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
                commitEditor.deleteEntry(commitPath, -1L);
                return false;
            }
        };
        try {
            SVNCommitUtil.driveCommitEditor(deleter, paths, commitEditor, -1L);
            info = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            throw e;
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, info.getNewRevision()), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doMkDir(SVNURL[] urls, String commitMessage) throws SVNException {
        SVNCommitInfo info;
        String path;
        Iterator commitPaths;
        if (urls == null || urls.length == 0) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> paths = new ArrayList<String>();
        SVNURL rootURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (rootURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Can not compute common root URL for specified URLs");
            SVNErrorManager.error(err);
        }
        if (paths.isEmpty()) {
            paths.add(SVNPathUtil.tail(rootURL.getURIEncodedPath()));
            rootURL = rootURL.removePathTail();
        }
        if (paths.contains("")) {
            ArrayList<String> convertedPaths = new ArrayList<String>();
            String tail = SVNPathUtil.tail(rootURL.getURIEncodedPath());
            rootURL = rootURL.removePathTail();
            commitPaths = paths.iterator();
            while (commitPaths.hasNext()) {
                path = (String)commitPaths.next();
                if ("".equals(path)) {
                    convertedPaths.add(tail);
                    continue;
                }
                convertedPaths.add(SVNPathUtil.append(tail, path));
            }
            paths = convertedPaths;
        }
        SVNCommitItem[] commitItems = new SVNCommitItem[paths.size()];
        for (int i = 0; i < commitItems.length; ++i) {
            String path2 = (String)paths.get(i);
            commitItems[i] = new SVNCommitItem(null, rootURL.appendPath(path2, true), null, SVNNodeKind.DIR, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, true, false, false, false, false, false);
        }
        commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitItems);
        if (commitMessage == null) {
            return SVNCommitInfo.NULL;
        }
        ArrayList<String> decodedPaths = new ArrayList<String>();
        commitPaths = paths.iterator();
        while (commitPaths.hasNext()) {
            path = (String)commitPaths.next();
            decodedPaths.add(SVNEncodingUtil.uriDecode(path));
        }
        paths = decodedPaths;
        SVNRepository repos = this.createRepository(rootURL, true);
        commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
        ISVNEditor commitEditor = repos.getCommitEditor(commitMessage, null, false, null);
        ISVNCommitPathHandler creater = new ISVNCommitPathHandler(){

            public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
                commitEditor.addDir(commitPath, null, -1L);
                return true;
            }
        };
        try {
            SVNCommitUtil.driveCommitEditor(creater, paths, commitEditor, -1L);
            info = commitEditor.closeEdit();
        }
        catch (SVNException e) {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException inner) {
                // empty catch block
            }
            throw e;
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, info.getNewRevision()), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean recursive) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, true, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean useGlobalIgnores, boolean recursive) throws SVNException {
        block21: {
            block22: {
                repos = null;
                srcKind = SVNFileType.getType(path);
                if (srcKind == SVNFileType.NONE) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Path ''{0}'' does not exist", path);
                    SVNErrorManager.error(err);
                }
                newPaths = new ArrayList<String>();
                rootURL = dstURL;
                repos = this.createRepository(rootURL, true);
                reposRoot = repos.getRepositoryRoot(true);
                while (!reposRoot.equals(rootURL) && repos.checkPath("", -1L) == SVNNodeKind.NONE) {
                    newPaths.add(SVNPathUtil.tail(rootURL.getPath()));
                    rootURL = rootURL.removePathTail();
                    repos = this.createRepository(rootURL, true);
                }
                if (newPaths.isEmpty() && (srcKind == SVNFileType.FILE || srcKind == SVNFileType.SYMLINK)) {
                    err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", dstURL);
                    SVNErrorManager.error(err);
                }
                if (newPaths.contains(SVNFileUtil.getAdminDirectoryName())) {
                    err = SVNErrorMessage.create(SVNErrorCode.CL_ADM_DIR_RESERVED, "''{0}'' is a reserved name and cannot be imported", SVNFileUtil.getAdminDirectoryName());
                    SVNErrorManager.error(err);
                }
                items = new SVNCommitItem[]{new SVNCommitItem(path, dstURL, null, srcKind == SVNFileType.DIRECTORY ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, true, false, false, false, false, false)};
                commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, items);
                if (commitMessage == null) {
                    return SVNCommitInfo.NULL;
                }
                commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
                commitEditor = repos.getCommitEditor(commitMessage, null, false, new SVNImportMediator());
                filePath = "";
                if (srcKind != SVNFileType.DIRECTORY) {
                    filePath = (String)newPaths.remove(0);
                    for (i = 0; i < newPaths.size(); ++i) {
                        newDir = (String)newPaths.get(i);
                        filePath = newDir + "/" + filePath;
                    }
                }
                this.checkCancelled();
                changed = false;
                info = null;
                commitEditor.openRoot(-1L);
                newDirPath = null;
                for (i = newPaths.size() - 1; i >= 0; --i) {
                    newDirPath = newDirPath == null ? (String)newPaths.get(i) : SVNPathUtil.append(newDirPath, (String)newPaths.get(i));
                    commitEditor.addDir(newDirPath, null, -1L);
                }
                changed = newPaths.size() > 0;
                deltaGenerator = new SVNDeltaGenerator();
                changed = srcKind == SVNFileType.DIRECTORY ? (changed |= this.importDir(deltaGenerator, path, path, newDirPath, useGlobalIgnores, recursive, commitEditor)) : (changed |= this.importFile(deltaGenerator, path.getParentFile(), path, srcKind, filePath, commitEditor));
                if (changed) break block21;
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {
                    // empty catch block
                }
                e = SVNCommitInfo.NULL;
                var20_22 = null;
                if (changed && info != null) break block22;
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {
                    // empty catch block
                }
            }
            return e;
        }
        try {
            for (i = 0; i < newPaths.size(); ++i) {
                commitEditor.closeDir();
            }
            info = commitEditor.closeEdit();
            var20_23 = null;
            ** if (changed && info != null) goto lbl-1000
        }
        catch (Throwable var19_28) {
            var20_24 = null;
            if (!changed || info == null) {
                try {
                    commitEditor.abortEdit();
                }
                catch (SVNException e) {
                    // empty catch block
                }
            }
            throw var19_28;
        }
lbl-1000:
        // 1 sources

        {
            try {
                commitEditor.abortEdit();
            }
            catch (SVNException e) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (info != null && info.getNewRevision() >= 0L) {
            this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, info.getNewRevision()), -1.0);
        }
        return info != null ? info : SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitInfo doCommit(File[] paths, boolean keepLocks, String commitMessage, boolean force, boolean recursive) throws SVNException {
        SVNCommitPacket packet = this.doCollectCommitItems(paths, keepLocks, force, recursive);
        try {
            packet = packet.removeSkippedItems();
            SVNCommitInfo sVNCommitInfo = this.doCommit(packet, keepLocks, commitMessage);
            return sVNCommitInfo;
        }
        finally {
            if (packet != null) {
                packet.dispose();
            }
        }
    }

    public SVNCommitInfo doCommit(SVNCommitPacket commitPacket, boolean keepLocks, String commitMessage) throws SVNException {
        SVNCommitInfo[] info = this.doCommit(new SVNCommitPacket[]{commitPacket}, keepLocks, commitMessage);
        if (info != null && info.length > 0) {
            if (info[0].getErrorMessage() != null && info[0].getErrorMessage().getErrorCode() != SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                SVNErrorManager.error(info[0].getErrorMessage());
            }
            return info[0];
        }
        return SVNCommitInfo.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVNCommitInfo[] doCommit(SVNCommitPacket[] commitPackets, boolean keepLocks, String commitMessage) throws SVNException {
        if (commitPackets == null || commitPackets.length == 0) {
            return new SVNCommitInfo[0];
        }
        tmpFiles = null;
        info = null;
        commitEditor = null;
        infos = new ArrayList<SVNCommitInfo>();
        needsSleepForTimeStamp = false;
        for (p = 0; p < commitPackets.length; ++p) {
            block46: {
                block43: {
                    block40: {
                        block41: {
                            commitPacket = commitPackets[p].removeSkippedItems();
                            if (commitPacket.getCommitItems().length == 0) continue;
                            try {
                                try {
                                    commitMessage = this.getCommitHandler().getCommitMessage(commitMessage, commitPacket.getCommitItems());
                                    if (commitMessage == null) {
                                        infos.add(SVNCommitInfo.NULL);
                                        var31_35 = null;
                                        if (info != null || commitEditor == null) break block40;
                                        break block41;
                                    }
                                    commitMessage = SVNCommitClient.validateCommitMessage(commitMessage);
                                    commitables = new TreeMap<K, V>();
                                    baseURL = SVNCommitUtil.translateCommitables(commitPacket.getCommitItems(), commitables);
                                    lockTokens = SVNCommitUtil.translateLockTokens(commitPacket.getLockTokens(), baseURL);
                                    repository = this.createRepository(SVNURL.parseURIEncoded(baseURL), true);
                                    mediator = new SVNCommitMediator(commitables);
                                    tmpFiles = mediator.getTmpFiles();
                                    commitEditor = repository.getCommitEditor(commitMessage, lockTokens, keepLocks, mediator);
                                    for (i = 0; i < commitPacket.getCommitItems().length; ++i) {
                                        commitPacket.getCommitItems()[i].getWCAccess().setEventHandler(this.getEventDispatcher());
                                    }
                                    repositoryRoot = repository.getRepositoryRoot(true).getPath();
                                    info = SVNCommitter.commit(mediator.getTmpFiles(), commitables, repositoryRoot, commitEditor);
                                    processedItems = new HashSet<String>();
                                    explicitCommitPaths = new HashSet<String>();
                                    urls = commitables.keySet().iterator();
                                    while (urls.hasNext()) {
                                        url = (String)urls.next();
                                        item = (SVNCommitItem)commitables.get(url);
                                        explicitCommitPaths.add(item.getPath());
                                    }
                                    urls = commitables.keySet().iterator();
                                    while (urls.hasNext()) {
                                        block42: {
                                            url = (String)urls.next();
                                            item = (SVNCommitItem)commitables.get(url);
                                            wcAccess = item.getWCAccess();
                                            path = item.getPath();
                                            dir = null;
                                            target = null;
                                            try {
                                                if (item.getKind() == SVNNodeKind.DIR) {
                                                    dir = wcAccess.retrieve(item.getFile());
                                                    target = "";
                                                } else {
                                                    dir = wcAccess.retrieve(item.getFile().getParentFile());
                                                    target = SVNPathUtil.tail(path);
                                                }
                                            }
                                            catch (SVNException e) {
                                                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_LOCKED) break block42;
                                                dir = null;
                                            }
                                        }
                                        if (dir == null) {
                                            if (SVNCommitClient.hasProcessedParents(processedItems, path)) {
                                                processedItems.add(path);
                                                continue;
                                            }
                                            if (item.isDeleted() && item.getKind() == SVNNodeKind.DIR) {
                                                parentPath = "".equals(path) != false ? null : item.getFile().getParentFile();
                                                v0 = nameInParent = "".equals(path) != false ? null : SVNPathUtil.tail(path);
                                                if (parentPath != null && (parentDir = wcAccess.retrieve(parentPath)) != null && (entryInParent = parentDir.getEntry(nameInParent, true)) != null) {
                                                    entryInParent.unschedule();
                                                    entryInParent.setDeleted(true);
                                                    parentDir.saveEntries(false);
                                                }
                                                processedItems.add(path);
                                                continue;
                                            }
                                        }
                                        if ((entry = dir.getEntry(target, true)) == null && SVNCommitClient.hasProcessedParents(processedItems, path)) {
                                            processedItems.add(path);
                                            continue;
                                        }
                                        recurse = false;
                                        if (item.isAdded() && item.getCopyFromURL() != null && item.getKind() == SVNNodeKind.DIR) {
                                            recurse = true;
                                        }
                                        removeLock = keepLocks == false && item.isLocked() != false;
                                        wcPropChanges = mediator.getWCProperties(item);
                                        dir.commit(target, info, wcPropChanges, removeLock, recurse, explicitCommitPaths, this.getCommitParameters());
                                        processedItems.add(path);
                                    }
                                    needsSleepForTimeStamp = true;
                                    this.dispatchEvent(SVNEventFactory.createCommitCompletedEvent(null, info.getNewRevision()), -1.0);
                                    break block43;
                                }
                                catch (SVNException e) {
                                    if (e instanceof SVNCancelException) {
                                        throw e;
                                    }
                                    err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "Commit failed (details follow):");
                                    err.setChildErrorMessage(e.getErrorMessage());
                                    infos.add(new SVNCommitInfo(-1L, null, null, err));
                                    this.dispatchEvent(new SVNEvent(err), -1.0);
                                    var31_35 = null;
                                    if (info == null && commitEditor != null) {
                                        try {
                                            commitEditor.abortEdit();
                                        }
                                        catch (SVNException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (tmpFiles != null) {
                                        files = tmpFiles.iterator();
                                        while (files.hasNext()) {
                                            file = (File)files.next();
                                            file.delete();
                                        }
                                    }
                                    if (commitPacket == null) continue;
                                    commitPacket.dispose();
                                    continue;
                                }
                            }
                            catch (Throwable var30_38) {
                                block45: {
                                    var31_35 = null;
                                    if (info == null && commitEditor != null) {
                                        ** try [egrp 3[TRYBLOCK] [7 : 893->903)] { 
lbl126:
                                        // 1 sources

                                        commitEditor.abortEdit();
                                        break block45;
lbl128:
                                        // 1 sources

                                        catch (SVNException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (tmpFiles != null) {
                                    files = tmpFiles.iterator();
                                    while (files.hasNext()) {
                                        file = (File)files.next();
                                        file.delete();
                                    }
                                }
                                if (commitPacket != null) {
                                    commitPacket.dispose();
                                }
                                throw var30_38;
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [7 : 893->903)] { 
lbl143:
                        // 1 sources

                        commitEditor.abortEdit();
                        break block40;
lbl145:
                        // 1 sources

                        catch (SVNException e) {
                            // empty catch block
                        }
                    }
                    if (tmpFiles != null) {
                        files = tmpFiles.iterator();
                        while (files.hasNext()) {
                            file = (File)files.next();
                            file.delete();
                        }
                    }
                    if (commitPacket == null) continue;
                    commitPacket.dispose();
                    continue;
                }
                var31_35 = null;
                if (info == null && commitEditor != null) {
                    ** try [egrp 3[TRYBLOCK] [7 : 893->903)] { 
lbl162:
                    // 1 sources

                    commitEditor.abortEdit();
                    break block46;
lbl164:
                    // 1 sources

                    catch (SVNException e) {
                        // empty catch block
                    }
                }
            }
            if (tmpFiles != null) {
                files = tmpFiles.iterator();
                while (files.hasNext()) {
                    file = (File)files.next();
                    file.delete();
                }
            }
            if (commitPacket != null) {
                commitPacket.dispose();
            }
            infos.add(info != null ? info : SVNCommitInfo.NULL);
        }
        if (needsSleepForTimeStamp) {
            this.sleepForTimeStamp();
        }
        return infos.toArray(new SVNCommitInfo[infos.size()]);
    }

    public SVNCommitPacket doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive) throws SVNException {
        if (paths == null || paths.length == 0) {
            return SVNCommitPacket.EMPTY;
        }
        ArrayList targets = new ArrayList();
        SVNStatusClient statusClient = new SVNStatusClient(this.getRepositoryPool(), this.getOptions());
        statusClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
                SVNCommitClient.this.checkCancelled();
            }
        });
        SVNWCAccess wcAccess = SVNCommitUtil.createCommitWCAccess(paths, recursive, force, targets, statusClient);
        SVNAdminArea[] areas = wcAccess.getAdminAreas();
        for (int i = 0; areas != null && i < areas.length; ++i) {
            if (areas[i] == null) continue;
            areas[i].setCommitParameters(this.getCommitParameters());
        }
        try {
            HashMap lockTokens = new HashMap();
            this.checkCancelled();
            SVNCommitItem[] commitItems = SVNCommitUtil.harvestCommitables(wcAccess, targets, lockTokens, !keepLocks, recursive, force, this.getCommitParameters());
            boolean hasModifications = false;
            this.checkCancelled();
            for (int i = 0; commitItems != null && i < commitItems.length; ++i) {
                SVNCommitItem commitItem = commitItems[i];
                if (!commitItem.isAdded() && !commitItem.isDeleted() && !commitItem.isContentsModified() && !commitItem.isPropertiesModified() && !commitItem.isCopied()) continue;
                hasModifications = true;
                break;
            }
            if (!hasModifications) {
                wcAccess.close();
                return SVNCommitPacket.EMPTY;
            }
            return new SVNCommitPacket(wcAccess, commitItems, lockTokens);
        }
        catch (SVNException e) {
            wcAccess.close();
            if (e instanceof SVNCancelException) {
                throw e;
            }
            SVNErrorMessage nestedErr = e.getErrorMessage();
            SVNErrorMessage err = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error(err, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNCommitPacket[] doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive, boolean combinePackets) throws SVNException {
        if (paths == null || paths.length == 0) {
            return new SVNCommitPacket[0];
        }
        ArrayList<SVNCommitPacket> packets = new ArrayList<SVNCommitPacket>();
        HashMap targets = new HashMap();
        SVNStatusClient statusClient = new SVNStatusClient(this.getRepositoryPool(), this.getOptions());
        statusClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
                SVNCommitClient.this.checkCancelled();
            }
        });
        SVNWCAccess[] wcAccesses = SVNCommitUtil.createCommitWCAccess2(paths, recursive, force, targets, statusClient);
        for (int i = 0; i < wcAccesses.length; ++i) {
            SVNWCAccess wcAccess = wcAccesses[i];
            SVNAdminArea[] areas = wcAccess.getAdminAreas();
            for (int j = 0; areas != null && j < areas.length; ++j) {
                if (areas[j] == null) continue;
                areas[j].setCommitParameters(this.getCommitParameters());
            }
            Collection targetPaths = (Collection)targets.get(wcAccess);
            try {
                this.checkCancelled();
                HashMap lockTokens = new HashMap();
                SVNCommitItem[] commitItems = SVNCommitUtil.harvestCommitables(wcAccess, targetPaths, lockTokens, !keepLocks, recursive, force, this.getCommitParameters());
                this.checkCancelled();
                boolean hasModifications = false;
                for (int j = 0; commitItems != null && j < commitItems.length; ++j) {
                    SVNCommitItem commitItem = commitItems[j];
                    if (!commitItem.isAdded() && !commitItem.isDeleted() && !commitItem.isContentsModified() && !commitItem.isPropertiesModified() && !commitItem.isCopied()) continue;
                    hasModifications = true;
                    break;
                }
                if (!hasModifications) {
                    wcAccess.close();
                    continue;
                }
                packets.add(new SVNCommitPacket(wcAccess, commitItems, lockTokens));
                continue;
            }
            catch (SVNException e) {
                for (int j = 0; j < wcAccesses.length; ++j) {
                    wcAccesses[j].close();
                }
                if (e instanceof SVNCancelException) {
                    throw e;
                }
                SVNErrorMessage nestedErr = e.getErrorMessage();
                SVNErrorMessage err = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
                SVNErrorManager.error(err, e);
            }
        }
        SVNCommitPacket[] packetsArray = packets.toArray(new SVNCommitPacket[packets.size()]);
        if (!combinePackets) {
            return packetsArray;
        }
        HashMap repoUUIDs = new HashMap();
        HashMap locktokensMap = new HashMap();
        try {
            for (int i = 0; i < packetsArray.length; ++i) {
                this.checkCancelled();
                SVNCommitPacket packet = packetsArray[i];
                File wcRoot = SVNWCUtil.getWorkingCopyRoot(packet.getCommitItems()[0].getWCAccess().getAnchor(), true);
                SVNWCAccess rootWCAccess = this.createWCAccess();
                String uuid = null;
                SVNURL url = null;
                try {
                    SVNAdminArea rootDir = rootWCAccess.open(wcRoot, false, 0);
                    uuid = rootDir.getEntry(rootDir.getThisDirName(), false).getUUID();
                    url = rootDir.getEntry(rootDir.getThisDirName(), false).getSVNURL();
                }
                finally {
                    rootWCAccess.close();
                }
                this.checkCancelled();
                if (uuid == null) {
                    if (url != null) {
                        SVNRepository repos = this.createRepository(url, true);
                        uuid = repos.getRepositoryUUID(true);
                    } else {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", wcRoot);
                        SVNErrorManager.error(err);
                    }
                }
                if (!repoUUIDs.containsKey(uuid = uuid + url.getProtocol() + ":" + url.getHost() + ":" + url.getPort())) {
                    repoUUIDs.put(uuid, new ArrayList());
                    locktokensMap.put(uuid, new HashMap());
                }
                Collection items = (Collection)repoUUIDs.get(uuid);
                Map lockTokens = (Map)locktokensMap.get(uuid);
                for (int j = 0; j < packet.getCommitItems().length; ++j) {
                    items.add(packet.getCommitItems()[j]);
                }
                if (packet.getLockTokens() != null) {
                    lockTokens.putAll(packet.getLockTokens());
                }
                this.checkCancelled();
            }
            packetsArray = new SVNCommitPacket[repoUUIDs.size()];
            int index = 0;
            Iterator roots = repoUUIDs.keySet().iterator();
            while (roots.hasNext()) {
                this.checkCancelled();
                String uuid = (String)roots.next();
                Collection items = (Collection)repoUUIDs.get(uuid);
                Map lockTokens = (Map)locktokensMap.get(uuid);
                SVNCommitItem[] itemsArray = items.toArray(new SVNCommitItem[items.size()]);
                packetsArray[index++] = new SVNCommitPacket(null, itemsArray, lockTokens);
            }
        }
        catch (SVNException e) {
            for (int j = 0; j < wcAccesses.length; ++j) {
                wcAccesses[j].close();
            }
            if (e instanceof SVNCancelException) {
                throw e;
            }
            SVNErrorMessage nestedErr = e.getErrorMessage();
            SVNErrorMessage err = SVNErrorMessage.create(nestedErr.getErrorCode(), "Commit failed (details follow):");
            SVNErrorManager.error(err, e);
        }
        return packetsArray;
    }

    private boolean importDir(SVNDeltaGenerator deltaGenerator, File rootFile, File dir, String importPath, boolean useGlobalIgnores, boolean recursive, ISVNEditor editor) throws SVNException {
        this.checkCancelled();
        File[] children = SVNFileListUtil.listFiles(dir);
        boolean changed = false;
        for (int i = 0; children != null && i < children.length; ++i) {
            File file = children[i];
            if (SVNFileUtil.getAdminDirectoryName().equals(file.getName())) {
                SVNEvent skippedEvent = SVNEventFactory.createSkipEvent(rootFile, file, SVNEventAction.SKIP, SVNEventAction.COMMIT_ADDED, SVNNodeKind.NONE);
                this.handleEvent(skippedEvent, -1.0);
                continue;
            }
            if (useGlobalIgnores && this.getOptions().isIgnored(file)) continue;
            String path = importPath == null ? file.getName() : SVNPathUtil.append(importPath, file.getName());
            SVNFileType fileType = SVNFileType.getType(file);
            if (fileType == SVNFileType.DIRECTORY && recursive) {
                editor.addDir(path, null, -1L);
                changed |= true;
                SVNEvent event = SVNEventFactory.createCommitEvent(rootFile, file, SVNEventAction.COMMIT_ADDED, SVNNodeKind.DIR, null);
                this.handleEvent(event, -1.0);
                this.importDir(deltaGenerator, rootFile, file, path, useGlobalIgnores, recursive, editor);
                editor.closeDir();
                continue;
            }
            if (fileType != SVNFileType.FILE && fileType != SVNFileType.SYMLINK) continue;
            changed |= this.importFile(deltaGenerator, rootFile, file, fileType, path, editor);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importFile(SVNDeltaGenerator deltaGenerator, File rootFile, File file, SVNFileType fileType, String filePath, ISVNEditor editor) throws SVNException {
        if (fileType == null || fileType == SVNFileType.UNKNOWN) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "unknown or unversionable type for ''{0}''", file);
            SVNErrorManager.error(err);
        }
        editor.addFile(filePath, null, -1L);
        String mimeType = null;
        Map<String, String> autoProperties = new HashMap<String, String>();
        if (fileType != SVNFileType.SYMLINK) {
            autoProperties = this.getOptions().applyAutoProperties(file, autoProperties);
            if (!autoProperties.containsKey("svn:mime-type") && (mimeType = SVNFileUtil.detectMimeType(file)) != null) {
                autoProperties.put("svn:mime-type", mimeType);
                if (SVNProperty.isBinaryMimeType(mimeType)) {
                    autoProperties.remove("svn:eol-style");
                }
            }
            if (!autoProperties.containsKey("svn:executable") && SVNFileUtil.isExecutable(file)) {
                autoProperties.put("svn:executable", "");
            }
        } else {
            autoProperties.put("svn:special", "*");
        }
        Iterator names = autoProperties.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            String value = (String)autoProperties.get(name);
            if ("svn:eol-style".equals(name) && value != null && (SVNProperty.isBinaryMimeType((String)autoProperties.get("svn:mime-type")) || !SVNTranslator.checkNewLines(file))) continue;
            editor.changeFileProperty(filePath, name, value);
        }
        SVNEvent addedEvent = SVNEventFactory.createCommitEvent(rootFile, file, SVNEventAction.COMMIT_ADDED, SVNNodeKind.FILE, mimeType);
        this.handleEvent(addedEvent, -1.0);
        String eolStyle = (String)autoProperties.get("svn:eol-style");
        String keywords = (String)autoProperties.get("svn:keywords");
        boolean special = autoProperties.get("svn:special") != null;
        File tmpFile = null;
        if (eolStyle != null || keywords != null || special) {
            byte[] eolBytes = SVNTranslator.getBaseEOL(eolStyle);
            Map keywordsMap = keywords != null ? SVNTranslator.computeKeywords(keywords, null, null, null, null, this.getOptions()) : null;
            tmpFile = SVNFileUtil.createTempFile(".import", ".tmp");
            SVNTranslator.translate(file, tmpFile, eolBytes, keywordsMap, special, false);
        }
        File importedFile = tmpFile != null ? tmpFile : file;
        InputStream is = null;
        String checksum = null;
        try {
            is = SVNFileUtil.openFileForReading(importedFile);
            editor.applyTextDelta(filePath, null);
            checksum = deltaGenerator.sendDelta(filePath, is, editor, true);
        }
        finally {
            SVNFileUtil.closeFile(is);
            SVNFileUtil.deleteFile(tmpFile);
        }
        editor.closeFile(filePath, checksum);
        return true;
    }

    private static boolean hasProcessedParents(Collection paths, String path) {
        if (paths.contains(path = SVNPathUtil.removeTail(path))) {
            return true;
        }
        if ("".equals(path)) {
            return false;
        }
        return SVNCommitClient.hasProcessedParents(paths, path);
    }

    static String validateCommitMessage(String message) {
        if (message == null) {
            return message;
        }
        message = message.replaceAll("\r\n", "\n");
        message = message.replace('\r', '\n');
        return message;
    }
}

