/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNUpdateEditor
implements ISVNEditor {
    private String mySwitchURL;
    private String myTarget;
    private String myTargetURL;
    private String myRootURL;
    private boolean myIsRecursive;
    private SVNAdminAreaInfo myAdminInfo;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private long myTargetRevision;
    private boolean myIsRootOpen;
    private boolean myIsTargetDeleted;
    private boolean myIsLeaveConflicts;
    private SVNWCAccess myWCAccess;
    private SVNDeltaProcessor myDeltaProcessor;

    public SVNUpdateEditor(SVNAdminAreaInfo info, String switchURL, boolean recursive, boolean leaveConflicts) throws SVNException {
        this.myAdminInfo = info;
        this.myWCAccess = info.getWCAccess();
        this.myIsRecursive = recursive;
        this.myTarget = info.getTargetName();
        this.mySwitchURL = switchURL;
        this.myTargetRevision = -1L;
        this.myIsLeaveConflicts = leaveConflicts;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        SVNEntry entry = info.getAnchor().getEntry(info.getAnchor().getThisDirName(), false);
        this.myTargetURL = entry != null ? entry.getURL() : null;
        String string = this.myRootURL = entry != null ? entry.getRepositoryRoot() : null;
        if (this.myTarget != null) {
            this.myTargetURL = SVNPathUtil.append(this.myTargetURL, SVNEncodingUtil.uriEncode(this.myTarget));
        }
        if (this.mySwitchURL != null && entry != null && entry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(entry.getRepositoryRoot(), this.mySwitchURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", new Object[]{this.mySwitchURL, entry.getRepositoryRoot()});
            SVNErrorManager.error(err);
        }
        this.myAdminInfo.getTarget().closeEntries();
        if ("".equals(this.myTarget)) {
            this.myTarget = null;
        }
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
        if (this.myTarget == null) {
            SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
            SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), true);
            entry.setRevision(this.myTargetRevision);
            entry.setURL(this.myCurrentDirectory.URL);
            entry.setIncomplete(true);
            if (this.mySwitchURL != null) {
                this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
            }
            adminArea.saveEntries(false);
        } else if (this.mySwitchURL != null) {
            if (this.myAdminInfo.getTarget() == this.myAdminInfo.getAnchor()) {
                this.clearWCProperty(this.myAdminInfo.getTarget(), this.myTarget);
            } else {
                this.clearWCProperty(this.myAdminInfo.getTarget(), null);
            }
        }
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        SVNAdminArea parentArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry entry = parentArea.getEntry(name, true);
        if (entry == null) {
            return;
        }
        SVNLog log = this.myCurrentDirectory.getLog();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", name);
        log.addCommand("delete-entry", attributes, false);
        SVNNodeKind kind = entry.getKind();
        boolean isDeleted = entry.isDeleted();
        if (path.equals(this.myTarget)) {
            attributes.put("name", name);
            attributes.put(SVNProperty.shortPropertyName("svn:entry:kind"), kind == SVNNodeKind.DIR ? "dir" : "file");
            attributes.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
            attributes.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.TRUE.toString());
            log.addCommand("modify-entry", attributes, false);
            this.myIsTargetDeleted = true;
        }
        try {
            log.save();
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Error writing log file for ''{0}''", this.myCurrentDirectory.getPath());
            SVNErrorManager.error(err, svne);
        }
        if (this.mySwitchURL != null && kind == SVNNodeKind.DIR) {
            SVNAdminArea childArea = this.myWCAccess.retrieve(parentArea.getFile(name));
            try {
                childArea.removeFromRevisionControl(childArea.getThisDirName(), true, true);
            }
            catch (SVNException svne) {
                this.handleLeftLocalModificationsError(svne, log, childArea);
            }
        }
        try {
            this.myCurrentDirectory.runLogs();
        }
        catch (SVNException svne) {
            this.handleLeftLocalModificationsError(svne, log, parentArea);
        }
        if (isDeleted) {
            return;
        }
        this.myWCAccess.handleEvent(SVNEventFactory.createUpdateDeleteEvent(this.myAdminInfo, this.myCurrentDirectory.getAdminArea(), kind, name));
    }

    private void handleLeftLocalModificationsError(SVNException originalError, SVNLog log, SVNAdminArea adminArea) throws SVNException {
        SVNException error = null;
        error = originalError;
        while (error != null && error.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            error = error.getCause() instanceof SVNException ? (SVNException)error.getCause() : null;
        }
        if (error != null) {
            log.delete();
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Won''t delete locally modified directory ''{0}''", adminArea.getRoot());
            SVNErrorManager.error(err, error);
        }
        throw originalError;
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNEntry entry;
        SVNErrorMessage err;
        SVNAdminArea parentArea = this.myCurrentDirectory.getAdminArea();
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, true);
        String name = SVNPathUtil.tail(path);
        File childDir = parentArea.getFile(name);
        SVNFileType kind = SVNFileType.getType(childDir);
        if (kind != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': object of the same name already exists", path);
            SVNErrorManager.error(err);
        } else if (SVNFileUtil.getAdminDirectoryName().equals(name)) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'':  object of the same name as the administrative directory", path);
            SVNErrorManager.error(err);
        }
        if (copyFromPath != null || copyFromRevision >= 0L) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Failed to add directory ''{0}'': copyfrom arguments not yet supported", path);
            SVNErrorManager.error(err);
        }
        if ((entry = parentArea.getEntry(name, false)) != null) {
            if (entry.isScheduledForAddition()) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': object of the same name already exists", path);
                SVNErrorManager.error(err2);
            }
        } else {
            entry = parentArea.addEntry(name);
        }
        entry.setKind(SVNNodeKind.DIR);
        entry.setAbsent(false);
        entry.setDeleted(false);
        parentArea.saveEntries(false);
        String rootURL = null;
        if (SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            rootURL = this.myRootURL;
        }
        if (this.myWCAccess.getAdminArea(childDir) != null) {
            this.myWCAccess.closeAdminArea(childDir);
        }
        if (SVNWCManager.ensureAdmiAreaExists(childDir, this.myCurrentDirectory.URL, rootURL, null, this.myTargetRevision)) {
            SVNFileUtil.deleteFile(new File(childDir, SVNFileUtil.getAdminDirectoryName() + "/lock"));
        }
        this.myWCAccess.open(childDir, true, 0);
        this.myWCAccess.handleEvent(SVNEventFactory.createUpdateAddEvent(this.myAdminInfo, parentArea, SVNNodeKind.DIR, entry));
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, false);
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), true);
        entry.setRevision(this.myTargetRevision);
        entry.setURL(this.myCurrentDirectory.URL);
        entry.setIncomplete(true);
        if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            entry.setRepositoryRoot(this.myRootURL);
        }
        if (this.mySwitchURL != null) {
            this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
        }
        adminArea.saveEntries(false);
    }

    public void absentDir(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.DIR);
    }

    public void absentFile(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.FILE);
    }

    private void absentEntry(String path, SVNNodeKind kind) throws SVNException {
        String name = SVNPathUtil.tail(path);
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry entry = adminArea.getEntry(name, false);
        if (entry != null && entry.isScheduledForAddition()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition", path);
            SVNErrorManager.error(err);
        }
        if (entry == null) {
            entry = adminArea.addEntry(name);
        }
        if (entry != null) {
            entry.setKind(kind);
            entry.setDeleted(false);
            entry.setRevision(this.myTargetRevision);
            entry.setAbsent(true);
        }
        adminArea.saveEntries(false);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.myCurrentDirectory.propertyChanged(name, value);
    }

    private void clearWCProperty(SVNAdminArea adminArea, String target) throws SVNException {
        if (adminArea == null) {
            return;
        }
        Iterator ents = adminArea.entries(false);
        while (ents.hasNext()) {
            SVNVersionedProperties props;
            SVNEntry entry = (SVNEntry)ents.next();
            if (target != null) {
                if (!entry.isFile() || !target.equals(entry.getName())) continue;
                props = adminArea.getWCProperties(entry.getName());
                props.setPropertyValue("svn:wc:ra_dav:version-url", null);
                adminArea.saveWCProperties(false);
                continue;
            }
            if (entry.isFile() || adminArea.getThisDirName().equals(entry.getName())) {
                props = adminArea.getWCProperties(entry.getName());
                props.setPropertyValue("svn:wc:ra_dav:version-url", null);
                adminArea.saveWCProperties(false);
                continue;
            }
            SVNAdminArea childArea = this.myAdminInfo.getWCAccess().getAdminArea(adminArea.getFile(entry.getName()));
            this.clearWCProperty(childArea, null);
        }
    }

    public void closeDir() throws SVNException {
        Map modifiedWCProps = this.myCurrentDirectory.getChangedWCProperties();
        Map modifiedEntryProps = this.myCurrentDirectory.getChangedEntryProperties();
        Map modifiedProps = this.myCurrentDirectory.getChangedProperties();
        SVNStatusType propStatus = SVNStatusType.UNKNOWN;
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        if (modifiedWCProps != null || modifiedEntryProps != null || modifiedProps != null) {
            SVNLog log = this.myCurrentDirectory.getLog();
            if (modifiedProps != null && !modifiedProps.isEmpty()) {
                this.myAdminInfo.addExternals(adminArea, (String)modifiedProps.get("svn:externals"));
                SVNVersionedProperties oldBaseProps = adminArea.getBaseProperties(adminArea.getThisDirName());
                try {
                    propStatus = adminArea.mergeProperties(adminArea.getThisDirName(), oldBaseProps.asMap(), modifiedProps, true, false, log);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err = svne.getErrorMessage().wrap("Couldn't do property merge");
                    SVNErrorManager.error(err, svne);
                }
            }
            log.logChangedEntryProperties(adminArea.getThisDirName(), modifiedEntryProps);
            log.logChangedWCProperties(adminArea.getThisDirName(), modifiedWCProps);
            log.save();
        }
        this.myCurrentDirectory.runLogs();
        this.completeDirectory(this.myCurrentDirectory);
        if (!this.myCurrentDirectory.IsAdded && (adminArea != this.myAdminInfo.getAnchor() || "".equals(this.myAdminInfo.getTargetName()))) {
            SVNEventAction action = SVNEventAction.UPDATE_UPDATE;
            if (propStatus == SVNStatusType.UNKNOWN) {
                action = SVNEventAction.UPDATE_NONE;
            }
            this.myWCAccess.handleEvent(SVNEventFactory.createUpdateModifiedEvent(this.myAdminInfo, adminArea, "", SVNNodeKind.DIR, action, null, SVNStatusType.UNKNOWN, propStatus, null));
        }
        this.myCurrentDirectory = this.myCurrentDirectory.Parent;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myTarget != null && this.myWCAccess.isMissing(this.myAdminInfo.getAnchor().getFile(this.myTarget))) {
            this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            this.deleteEntry(this.myTarget, this.myTargetRevision);
        }
        if (!this.myIsRootOpen) {
            this.completeDirectory(this.myCurrentDirectory);
        }
        if (!this.myIsTargetDeleted) {
            File targetFile = this.myTarget != null ? this.myAdminInfo.getAnchor().getFile(this.myTarget) : this.myAdminInfo.getAnchor().getRoot();
            SVNWCManager.updateCleanup(targetFile, this.myWCAccess, this.myIsRecursive, this.mySwitchURL, this.myRootURL, this.myTargetRevision, true);
        }
        return null;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, true);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, false);
    }

    public void changeFileProperty(String commitPath, String name, String value) throws SVNException {
        this.myCurrentFile.propertyChanged(name, value);
        if (this.myWCAccess.getOptions().isUseCommitTimes() && "svn:entry:committed-date".equals(name)) {
            this.myCurrentFile.CommitTime = value;
        }
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        File baseFile;
        SVNAdminArea adminArea = this.myCurrentFile.getAdminArea();
        SVNEntry entry = adminArea.getEntry(this.myCurrentFile.Name, false);
        boolean replaced = entry != null && entry.isScheduledForReplacement();
        File file = baseFile = replaced ? adminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.Name, false)) : adminArea.getBaseFile(this.myCurrentFile.Name, false);
        if (entry != null && entry.getChecksum() != null) {
            String entryChecksumSafe;
            String realChecksum = SVNFileUtil.computeChecksum(baseFile);
            if (baseChecksum != null && !baseChecksum.equals(realChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{this.myCurrentFile.getPath(), baseChecksum, realChecksum});
                SVNErrorManager.error(err);
            }
            String realChecksumSafe = realChecksum == null ? "" : realChecksum;
            String string = entryChecksumSafe = entry.getChecksum() == null ? "" : entry.getChecksum();
            if (!replaced && !realChecksumSafe.equals(entryChecksumSafe)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; recorded: ''{1}'', actual: ''{2}''", new Object[]{this.myCurrentFile.getPath(), entry.getChecksum(), realChecksum});
                SVNErrorManager.error(err);
            }
        }
        File baseTmpFile = replaced ? adminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.Name, true)) : adminArea.getBaseFile(this.myCurrentFile.Name, true);
        this.myCurrentFile.TextUpdated = true;
        this.myDeltaProcessor.applyTextDelta(baseFile, baseTmpFile, true);
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        this.myCurrentFile.Checksum = this.myDeltaProcessor.textDeltaEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        String basePath;
        String tmpPath;
        File textTmpBase;
        boolean isReplaced;
        boolean isLocallyModified;
        SVNStatusType propStatus;
        boolean magicPropsChanged;
        SVNStatusType lockStatus;
        SVNStatusType textStatus;
        HashMap<String, String> command;
        String commitTime;
        String name;
        SVNLog log;
        SVNAdminArea adminArea;
        String checksum;
        block34: {
            block32: {
                File workingFile;
                Map modifiedProps;
                block33: {
                    SVNEntry entry;
                    boolean isLocalPropsModified;
                    SVNVersionedProperties baseProps;
                    checksum = null;
                    if (textChecksum != null && this.myCurrentFile.TextUpdated) {
                        if (this.myCurrentFile.Checksum != null && !textChecksum.equals(this.myCurrentFile.Checksum)) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{this.myCurrentFile.getPath(), textChecksum, checksum});
                            SVNErrorManager.error(err);
                        }
                        checksum = textChecksum;
                    }
                    adminArea = this.myCurrentFile.getAdminArea();
                    log = this.myCurrentDirectory.getLog();
                    Map modifiedWCProps = this.myCurrentFile.getChangedWCProperties();
                    Map modifiedEntryProps = this.myCurrentFile.getChangedEntryProperties();
                    modifiedProps = this.myCurrentFile.getChangedProperties();
                    name = this.myCurrentFile.Name;
                    commitTime = this.myCurrentFile.CommitTime;
                    command = new HashMap<String, String>();
                    textStatus = SVNStatusType.UNCHANGED;
                    lockStatus = SVNStatusType.LOCK_UNCHANGED;
                    magicPropsChanged = false;
                    if (modifiedProps != null && !modifiedProps.isEmpty()) {
                        magicPropsChanged = modifiedProps.containsKey("svn:executable") || modifiedProps.containsKey("svn:needs-lock") || modifiedProps.containsKey("svn:keywords") || modifiedProps.containsKey("svn:eol-style") || modifiedProps.containsKey("svn:special");
                    }
                    Map oldBaseProps = (baseProps = adminArea.getBaseProperties(name)) != null ? baseProps.asMap() : null;
                    propStatus = adminArea.mergeProperties(name, oldBaseProps, modifiedProps, true, false, log);
                    if (modifiedEntryProps != null) {
                        lockStatus = log.logChangedEntryProperties(name, modifiedEntryProps);
                    }
                    boolean bl = isLocalPropsModified = !this.myCurrentFile.IsAdded && adminArea.hasPropModifications(name);
                    if (modifiedProps != null && !isLocalPropsModified) {
                        command.put("name", name);
                        command.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), "working");
                        log.addCommand("modify-entry", command, false);
                        command.clear();
                    }
                    if (modifiedWCProps != null) {
                        log.logChangedWCProperties(name, modifiedWCProps);
                    }
                    isLocallyModified = !this.myCurrentFile.IsAdded && adminArea.hasTextModifications(name, false);
                    isReplaced = false;
                    if (!isLocallyModified && (entry = adminArea.getEntry(name, false)) != null && entry.isScheduledForReplacement()) {
                        isReplaced = true;
                    }
                    String adminDir = SVNFileUtil.getAdminDirectoryName();
                    textTmpBase = adminArea.getBaseFile(name, true);
                    if (isReplaced) {
                        textTmpBase = adminArea.getFile(SVNAdminUtil.getTextRevertPath(name, true));
                    }
                    workingFile = adminArea.getFile(name);
                    tmpPath = null;
                    basePath = null;
                    if (this.myCurrentFile.TextUpdated && textTmpBase.exists()) {
                        if (!isReplaced) {
                            tmpPath = adminDir + "/tmp/text-base/" + name + ".svn-base";
                            basePath = adminDir + "/text-base/" + name + ".svn-base";
                        } else {
                            tmpPath = adminDir + "/tmp/text-base/" + name + ".svn-revert";
                            basePath = adminDir + "/text-base/" + name + ".svn-revert";
                        }
                    } else if (!this.myCurrentFile.TextUpdated && magicPropsChanged && workingFile.exists()) {
                        tmpPath = SVNAdminUtil.getTextBasePath(name, true);
                        command.put("name", name);
                        command.put("dest", tmpPath);
                        log.addCommand("cp-and-detranslate", command, false);
                        command.clear();
                        command.put("name", tmpPath);
                        command.put("dest", name);
                        log.addCommand("cp-and-translate", command, false);
                        command.clear();
                    }
                    command.put("name", name);
                    command.put(SVNProperty.shortPropertyName("svn:entry:kind"), "file");
                    command.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
                    command.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.FALSE.toString());
                    command.put(SVNProperty.shortPropertyName("svn:entry:absent"), Boolean.FALSE.toString());
                    if (this.myCurrentFile.URL != null) {
                        command.put(SVNProperty.shortPropertyName("svn:entry:url"), this.myCurrentFile.URL);
                    }
                    log.addCommand("modify-entry", command, false);
                    command.clear();
                    if (!this.myCurrentFile.TextUpdated || !textTmpBase.exists()) break block32;
                    textStatus = SVNStatusType.CHANGED;
                    if (isLocallyModified || isReplaced) break block33;
                    command.put("name", tmpPath);
                    command.put("dest", name);
                    log.addCommand("cp-and-translate", command, false);
                    command.clear();
                    break block34;
                }
                SVNFileType kind = SVNFileType.getType(workingFile);
                if (kind == SVNFileType.NONE) {
                    command.put("name", tmpPath);
                    command.put("dest", name);
                    log.addCommand("cp-and-translate", command, false);
                    command.clear();
                    break block34;
                } else {
                    SVNEntry entry;
                    block31: {
                        entry = adminArea.getEntry(name, false);
                        if (entry == null) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", workingFile);
                            SVNErrorManager.error(err);
                        }
                        String oldEolStyle = null;
                        String oldKeywords = null;
                        SVNVersionedProperties props = adminArea.getProperties(this.myCurrentFile.Name);
                        try {
                            if (magicPropsChanged && (modifiedProps.containsKey("svn:eol-style") || modifiedProps.containsKey("svn:keywords"))) {
                                oldKeywords = props.getPropertyValue("svn:keywords");
                                oldEolStyle = props.getPropertyValue("svn:eol-style");
                                props.setPropertyValue("svn:eol-style", (String)modifiedProps.get("svn:eol-style"));
                                props.setPropertyValue("svn:keywords", (String)modifiedProps.get("svn:keywords"));
                            }
                            textStatus = adminArea.mergeText(name, adminArea.getFile(basePath), adminArea.getFile(tmpPath), "", "", "", this.myIsLeaveConflicts, true);
                            Object var32_31 = null;
                            if (!magicPropsChanged || !modifiedProps.containsKey("svn:eol-style") && !modifiedProps.containsKey("svn:keywords")) break block31;
                        }
                        catch (Throwable throwable) {
                            Object var32_32 = null;
                            if (magicPropsChanged && (modifiedProps.containsKey("svn:eol-style") || modifiedProps.containsKey("svn:keywords"))) {
                                props.setPropertyValue("svn:eol-style", oldEolStyle);
                                props.setPropertyValue("svn:keywords", oldKeywords);
                            }
                            throw throwable;
                        }
                        props.setPropertyValue("svn:eol-style", oldEolStyle);
                        props.setPropertyValue("svn:keywords", oldKeywords);
                    }
                    if (textStatus == SVNStatusType.UNCHANGED) {
                        textStatus = SVNStatusType.MERGED;
                    }
                    String oldRevisionStr = ".r" + entry.getRevision();
                    String newRevisionStr = ".r" + this.myTargetRevision;
                    command.put("name", name);
                    command.put("arg1", basePath);
                    command.put("arg2", tmpPath);
                    command.put("arg3", oldRevisionStr);
                    command.put("arg4", newRevisionStr);
                    command.put("arg5", ".mine");
                    if (textStatus == SVNStatusType.CONFLICTED_UNRESOLVED) {
                        command.put("arg6", Boolean.TRUE.toString());
                    }
                    log.addCommand("merge", command, false);
                    command.clear();
                }
                break block34;
            }
            if (lockStatus == SVNStatusType.LOCK_UNLOCKED) {
                command.put("name", name);
                log.addCommand("maybe-readonly", command, false);
                command.clear();
            }
        }
        if (this.myCurrentFile.TextUpdated && textTmpBase.exists()) {
            command.put("name", tmpPath);
            command.put("dest", basePath);
            log.addCommand("mv", command, false);
            command.clear();
            command.put("name", basePath);
            log.addCommand("readonly", command, false);
            command.clear();
            if (!isReplaced) {
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
                log.addCommand("modify-entry", command, false);
                command.clear();
            }
        }
        if (!isLocallyModified) {
            if (commitTime != null) {
                command.put("name", name);
                command.put("timestamp", commitTime);
                log.addCommand("set-timestamp", command, false);
                command.clear();
            }
            if (this.myCurrentFile.TextUpdated && textTmpBase.exists() || magicPropsChanged) {
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                log.addCommand("modify-entry", command, false);
                command.clear();
            }
        }
        log.save();
        this.myCurrentFile.TextUpdated = false;
        this.completeDirectory(this.myCurrentDirectory);
        if (!this.myCurrentFile.IsAdded && textStatus == SVNStatusType.UNCHANGED && propStatus == SVNStatusType.UNCHANGED && lockStatus == SVNStatusType.LOCK_UNCHANGED) {
            this.myCurrentFile = null;
            return;
        }
        SVNEventAction action = this.myCurrentFile.IsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        this.myWCAccess.handleEvent(SVNEventFactory.createUpdateModifiedEvent(this.myAdminInfo, adminArea, this.myCurrentFile.Name, SVNNodeKind.FILE, action, null, textStatus, propStatus, lockStatus));
        this.myCurrentFile = null;
    }

    public void abortEdit() throws SVNException {
    }

    private void completeDirectory(SVNDirectoryInfo info) throws SVNException {
        while (info != null) {
            --info.RefCount;
            if (info.RefCount > 0) {
                return;
            }
            if (info.Parent == null && this.myTarget != null) {
                return;
            }
            SVNAdminArea adminArea = info.getAdminArea();
            if (adminArea.getEntry(adminArea.getThisDirName(), true) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No root entry found in ''{0}''", adminArea.getRoot());
                SVNErrorManager.error(err);
            }
            Iterator ents = adminArea.entries(true);
            while (ents.hasNext()) {
                SVNEntry entry = (SVNEntry)ents.next();
                if (adminArea.getThisDirName().equals(entry.getName())) {
                    entry.setIncomplete(false);
                    continue;
                }
                if (entry.isDeleted()) {
                    if (!entry.isScheduledForAddition()) {
                        adminArea.deleteEntry(entry.getName());
                        continue;
                    }
                    entry.setDeleted(false);
                    continue;
                }
                if (entry.isAbsent() && entry.getRevision() != this.myTargetRevision) {
                    adminArea.deleteEntry(entry.getName());
                    continue;
                }
                if (entry.getKind() != SVNNodeKind.DIR || !this.myWCAccess.isMissing(adminArea.getFile(entry.getName())) || entry.isAbsent() || entry.isScheduledForAddition()) continue;
                adminArea.deleteEntry(entry.getName());
                this.myWCAccess.handleEvent(SVNEventFactory.createUpdateDeleteEvent(this.myAdminInfo, info.getAdminArea(), entry));
            }
            adminArea.saveEntries(true);
            info = info.Parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNFileInfo createFileInfo(SVNDirectoryInfo parent, String path, boolean added) throws SVNException {
        SVNFileInfo info = new SVNFileInfo(parent, path);
        info.IsAdded = added;
        info.Name = SVNPathUtil.tail(path);
        SVNAdminArea adminArea = parent.getAdminArea();
        SVNFileType kind = SVNFileType.getType(adminArea.getFile(info.Name));
        if (added && kind != SVNFileType.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': object of the same name already exists", path);
            SVNErrorManager.error(err);
        }
        try {
            SVNErrorMessage err;
            SVNEntry entry = adminArea.getEntry(info.Name, true);
            if (added && entry != null && entry.isScheduledForAddition()) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': object of the same name already exists and scheduled for addition", path);
                SVNErrorManager.error(err);
            }
            if (!added && entry == null) {
                err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "File ''{0}'' in directory ''{1}'' is not a versioned resource", new Object[]{info.Name, adminArea.getRoot()});
                SVNErrorManager.error(err);
            }
            info.URL = this.mySwitchURL != null || entry == null ? SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(info.Name)) : entry.getURL();
        }
        finally {
            adminArea.closeEntries();
        }
        ++parent.RefCount;
        return info;
    }

    private SVNDirectoryInfo createDirectoryInfo(SVNDirectoryInfo parent, String path, boolean added) {
        String name;
        SVNDirectoryInfo info = new SVNDirectoryInfo(path);
        info.Parent = parent;
        info.IsAdded = added;
        String string = name = path != null ? SVNPathUtil.tail(path) : "";
        if (this.mySwitchURL == null) {
            SVNAdminArea area = null;
            SVNEntry dirEntry = null;
            try {
                area = info.getAdminArea();
                if (area != null) {
                    dirEntry = area.getEntry(area.getThisDirName(), false);
                }
            }
            catch (SVNException svne) {
                // empty catch block
            }
            if (area != null && dirEntry != null) {
                info.URL = dirEntry.getURL();
            }
            if (info.URL == null && parent != null) {
                info.URL = SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name));
            } else if (info.URL == null && parent == null) {
                info.URL = this.myTargetURL;
            }
        } else {
            info.URL = parent == null ? (this.myTarget == null ? this.mySwitchURL : SVNPathUtil.removeTail(this.mySwitchURL)) : (this.myTarget != null && parent.Parent == null ? this.mySwitchURL : SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name)));
        }
        info.RefCount = 1;
        if (info.Parent != null) {
            ++info.Parent.RefCount;
        }
        return info;
    }

    private class SVNDirectoryInfo
    extends SVNEntryInfo {
        public int RefCount;

        public SVNDirectoryInfo(String path) {
            super(path);
        }

        public SVNAdminArea getAdminArea() throws SVNException {
            String path = this.getPath();
            File file = new File(SVNUpdateEditor.this.myAdminInfo.getAnchor().getRoot(), path);
            return SVNUpdateEditor.this.myAdminInfo.getWCAccess().retrieve(file);
        }

        public SVNLog getLog() throws SVNException {
            SVNLog log = this.getAdminArea().getLog();
            return log;
        }

        public void runLogs() throws SVNException {
            this.getAdminArea().runLogs();
        }
    }

    private class SVNFileInfo
    extends SVNEntryInfo {
        public String Name;
        public String CommitTime;
        public boolean TextUpdated;
        public String Checksum;

        public SVNFileInfo(SVNDirectoryInfo parent, String path) {
            super(path);
            this.Parent = parent;
        }

        public SVNAdminArea getAdminArea() throws SVNException {
            return this.Parent.getAdminArea();
        }
    }

    private class SVNEntryInfo {
        public String URL;
        public boolean IsAdded;
        public SVNDirectoryInfo Parent;
        private String myPath;
        private Map myChangedProperties;
        private Map myChangedEntryProperties;
        private Map myChangedWCProperties;

        protected SVNEntryInfo(String path) {
            this.myPath = path;
        }

        protected String getPath() {
            return this.myPath;
        }

        public void propertyChanged(String name, String value) {
            if (name.startsWith("svn:entry:")) {
                this.myChangedEntryProperties = this.myChangedEntryProperties == null ? new HashMap() : this.myChangedEntryProperties;
                this.myChangedEntryProperties.put(name.substring("svn:entry:".length()), value);
            } else if (name.startsWith("svn:wc:")) {
                this.myChangedWCProperties = this.myChangedWCProperties == null ? new HashMap() : this.myChangedWCProperties;
                this.myChangedWCProperties.put(name, value);
            } else {
                this.myChangedProperties = this.myChangedProperties == null ? new HashMap() : this.myChangedProperties;
                this.myChangedProperties.put(name, value);
            }
        }

        public Map getChangedWCProperties() {
            return this.myChangedWCProperties;
        }

        public Map getChangedEntryProperties() {
            return this.myChangedEntryProperties;
        }

        public Map getChangedProperties() {
            return this.myChangedProperties;
        }
    }
}

