/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class SVNPasswordCipher {
    private static final SVNPasswordCipher EMPTY_CIPHER = new CompositePasswordCipher(Collections.EMPTY_LIST);
    private static Map ourInstances = new HashMap();
    private static String ourDefaultType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNPasswordCipher getInstance(String type) {
        if (type == null) {
            return EMPTY_CIPHER;
        }
        Map map = ourInstances;
        synchronized (map) {
            if (ourInstances.containsKey(type)) {
                return (SVNPasswordCipher)ourInstances.get(type);
            }
        }
        return EMPTY_CIPHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCipher(String type) {
        Map map = ourInstances;
        synchronized (map) {
            return type != null && ourInstances.containsKey(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultCipherType(String type) {
        Map map = ourInstances;
        synchronized (map) {
            ourDefaultType = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultCipherType() {
        Map map = ourInstances;
        synchronized (map) {
            if (ourDefaultType != null) {
                return ourDefaultType;
            }
            if (!ourInstances.isEmpty()) {
                ourDefaultType = (String)ourInstances.keySet().iterator().next();
                return ourDefaultType;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerCipher(String type, SVNPasswordCipher cipher) {
        if (type != null && cipher != null) {
            Map map = ourInstances;
            synchronized (map) {
                if (ourInstances.containsKey(type)) {
                    ((CompositePasswordCipher)ourInstances.get(type)).addCipher(cipher);
                } else {
                    cipher = new CompositePasswordCipher(cipher);
                    ourInstances.put(type, cipher);
                }
            }
        }
    }

    protected SVNPasswordCipher() {
    }

    public abstract String encrypt(String var1);

    public abstract String decrypt(String var1);

    private static class CompositePasswordCipher
    extends SVNPasswordCipher {
        private List myCiphers;

        private CompositePasswordCipher(List chiphers) {
            this.myCiphers = chiphers;
        }

        public CompositePasswordCipher(SVNPasswordCipher chipher) {
            this.myCiphers = new ArrayList();
            this.myCiphers.add(chipher);
        }

        public synchronized void addCipher(SVNPasswordCipher chipher) {
            this.myCiphers.add(chipher);
        }

        public synchronized String decrypt(String encyrptedData) {
            Iterator chiphers = this.myCiphers.iterator();
            while (chiphers.hasNext()) {
                SVNPasswordCipher chipher = (SVNPasswordCipher)chiphers.next();
                encyrptedData = chipher.decrypt(encyrptedData);
            }
            return encyrptedData;
        }

        public synchronized String encrypt(String rawData) {
            Iterator chiphers = this.myCiphers.iterator();
            while (chiphers.hasNext()) {
                SVNPasswordCipher chipher = (SVNPasswordCipher)chiphers.next();
                rawData = chipher.encrypt(rawData);
            }
            return rawData;
        }
    }
}

