/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import ch.ethz.ssh2.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNTunnelConnector
implements ISVNConnector {
    private static final String TUNNEL_COMMAND = "{0} {1} svnserve -t";
    private String myTunnelSpec;
    private String myName;
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private Process myProcess;

    public SVNTunnelConnector(String name, String tunnelSpec) {
        this.myName = name;
        this.myTunnelSpec = tunnelSpec;
    }

    public void open(SVNRepositoryImpl repository) throws SVNException {
        String expandedTunnel = SVNTunnelConnector.expandTunnelSpec(this.myName, this.myTunnelSpec);
        String host = repository.getLocation().getHost();
        if (repository.getLocation().getUserInfo() != null && !"".equals(repository.getLocation().getUserInfo())) {
            String username = repository.getLocation().getUserInfo();
            host = username + "@" + host;
        }
        expandedTunnel = MessageFormat.format(TUNNEL_COMMAND, expandedTunnel, host);
        if (repository.getAuthenticationManager() != null) {
            String userName;
            SVNAuthentication auth = repository.getAuthenticationManager().getFirstAuthentication("svn.username", host, repository.getLocation());
            if (auth == null) {
                SVNErrorManager.cancel("Authentication cancelled");
            }
            if ((userName = auth.getUserName()) == null || "".equals(userName.trim())) {
                userName = System.getProperty("user.name");
            }
            auth = new SVNUserNameAuthentication(userName, auth.isStorageAllowed());
            repository.getAuthenticationManager().acknowledgeAuthentication(true, "svn.username", host, null, auth);
            expandedTunnel = expandedTunnel + " --tunnel-user " + userName;
            repository.setExternalUserName(userName);
        }
        try {
            this.myProcess = Runtime.getRuntime().exec(expandedTunnel);
            this.myInputStream = repository.getDebugLog().createLogStream(this.myProcess.getInputStream());
            this.myOutputStream = repository.getDebugLog().createLogStream(this.myProcess.getOutputStream());
            new StreamGobbler(this.myProcess.getErrorStream());
        }
        catch (IOException e) {
            try {
                this.close(repository);
            }
            catch (SVNException inner) {
                // empty catch block
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "Cannot create tunnel: ''{0}''", e.getMessage());
            SVNErrorManager.error(err, e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    public boolean isConnected(SVNRepositoryImpl repos) throws SVNException {
        return this.myInputStream != null;
    }

    public void close(SVNRepositoryImpl repository) throws SVNException {
        if (this.myProcess != null) {
            if (this.myInputStream != null) {
                repository.getDebugLog().flushStream(this.myInputStream);
                SVNFileUtil.closeFile(this.myInputStream);
            }
            if (this.myOutputStream != null) {
                repository.getDebugLog().flushStream(this.myOutputStream);
                SVNFileUtil.closeFile(this.myOutputStream);
            }
            this.myProcess.destroy();
            this.myInputStream = null;
            this.myOutputStream = null;
            this.myProcess = null;
        }
    }

    private static String expandTunnelSpec(String name, String tunnelSpec) throws SVNException {
        String lastSegment;
        int spaceIndex;
        if (tunnelSpec == null || tunnelSpec.trim().length() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "No tunnel spec foound for ''{0}''", name);
            SVNErrorManager.error(err);
        }
        String firstSegment = (spaceIndex = (tunnelSpec = tunnelSpec.trim()).indexOf(32)) > 0 ? tunnelSpec.substring(0, spaceIndex) : tunnelSpec;
        String string = lastSegment = spaceIndex > 0 ? tunnelSpec.substring(spaceIndex).trim() : tunnelSpec;
        if (firstSegment.charAt(0) == '%' && firstSegment.charAt(firstSegment.length() - 1) == '%') {
            firstSegment = firstSegment.substring(1);
            firstSegment = firstSegment.substring(0, firstSegment.length() - 1);
            firstSegment = SVNFileUtil.getEnvironmentVariable(firstSegment);
        } else if (firstSegment.charAt(0) == '$') {
            firstSegment = firstSegment.substring(1);
            firstSegment = SVNFileUtil.getEnvironmentVariable(firstSegment);
        } else {
            firstSegment = null;
            lastSegment = null;
        }
        if (firstSegment != null) {
            tunnelSpec = firstSegment;
        } else if (lastSegment != null) {
            tunnelSpec = lastSegment;
        }
        return tunnelSpec;
    }

    public void free() {
    }

    public boolean occupy() {
        return true;
    }
}

