/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.crypto.PEMDecoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNGanymedSession {
    private static Map ourConnectionsPool = new Hashtable();
    private static boolean ourIsUsePersistentConnection;
    private static Map ourSessionsMap;
    private static Object ourRequestor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnection(SVNURL location, SVNSSHAuthentication credentials) throws SVNException {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            Connection connection;
            block29: {
                int port;
                if ("".equals(credentials.getUserName()) || credentials.getUserName() == null) {
                    SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "User name is required to establish SSH connection");
                    SVNErrorManager.error(error);
                }
                int n = port = location.hasPort() ? location.getPort() : credentials.getPortNumber();
                if (port < 0) {
                    port = 22;
                }
                String key = credentials.getUserName() + ":" + location.getHost() + ":" + port;
                if (credentials.getPrivateKeyFile() != null) {
                    key = key + ":" + credentials.getPrivateKeyFile().getAbsolutePath();
                }
                if (credentials.getPassphrase() != null) {
                    key = key + ":" + credentials.getPassphrase();
                }
                if (credentials.getPassword() != null) {
                    key = key + ":" + credentials.getPassword();
                }
                Connection connection2 = connection = SVNGanymedSession.isUsePersistentConnection() ? (Connection)ourConnectionsPool.get(key) : null;
                if (connection == null) {
                    SVNErrorMessage error;
                    File privateKey = credentials.getPrivateKeyFile();
                    String passphrase = credentials.getPassphrase();
                    String password = credentials.getPassword();
                    String userName = credentials.getUserName();
                    password = "".equals(password) && privateKey != null ? null : password;
                    String string = passphrase = "".equals(passphrase) ? null : passphrase;
                    if (privateKey != null && !SVNGanymedSession.isValidPrivateKey(privateKey, passphrase)) {
                        if (password == null) {
                            error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "File ''{0}'' is not valid OpenSSH DSA or RSA private key file", privateKey);
                            SVNErrorManager.error(error);
                        }
                        privateKey = null;
                    }
                    if (privateKey == null && password == null) {
                        error = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Either password or private key should be provided to establish SSH connection");
                        SVNErrorManager.error(error);
                    }
                    connection = new Connection(location.getHost(), port);
                    try {
                        SVNErrorMessage error2;
                        connection.connect();
                        boolean authenticated = false;
                        if (privateKey != null) {
                            authenticated = connection.authenticateWithPublicKey(userName, privateKey, passphrase);
                        } else if (password != null) {
                            String[] methods = connection.getRemainingAuthMethods(userName);
                            authenticated = false;
                            for (int i = 0; i < methods.length; ++i) {
                                if ("password".equals(methods[i])) {
                                    authenticated = connection.authenticateWithPassword(userName, password);
                                } else if ("keyboard-interactive".equals(methods[i])) {
                                    final String p = password;
                                    authenticated = connection.authenticateWithKeyboardInteractive(userName, new InteractiveCallback(){

                                        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
                                            String[] reply = new String[numPrompts];
                                            for (int i = 0; i < reply.length; ++i) {
                                                reply[i] = p;
                                            }
                                            return reply;
                                        }
                                    });
                                }
                                if (!authenticated) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            error2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Either password or private key should be provided to establish SSH connection");
                            SVNErrorManager.error(error2);
                        }
                        if (authenticated) {
                            if (SVNGanymedSession.isUsePersistentConnection()) {
                                ourConnectionsPool.put(key, connection);
                            }
                            break block29;
                        }
                        error2 = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "SSH server rejects provided credentials");
                        SVNErrorManager.error(error2);
                    }
                    catch (IOException e) {
                        if (connection != null) {
                            connection.close();
                            if (SVNGanymedSession.isUsePersistentConnection()) {
                                ourConnectionsPool.remove(key);
                            }
                        }
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_SVN_CONNECTION_CLOSED, "Cannot connect to ''{0}'': {1}", new Object[]{location.setPath("", false), e.getLocalizedMessage()});
                        SVNErrorManager.error(err, e);
                    }
                } else {
                    SVNGanymedSession.purgeSessions();
                }
            }
            Connection connection3 = connection;
            return connection3;
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    private static void purgeSessions() {
        Session session;
        ArrayList<Session> toClose = new ArrayList<Session>();
        Iterator<Object> sessions = ourSessionsMap.keySet().iterator();
        while (sessions.hasNext()) {
            session = (Session)sessions.next();
            if (ourSessionsMap.get(session) != Boolean.FALSE) continue;
            toClose.add(session);
        }
        if (toClose.size() > 1) {
            sessions = toClose.iterator();
            while (sessions.hasNext()) {
                session = (Session)sessions.next();
                if (ourSessionsMap.remove(session) == null) continue;
                session.close();
                session.waitForCondition(2, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean occupySession(Session session) {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            if (session != null && ourSessionsMap.containsKey(session)) {
                ourSessionsMap.put(session, Boolean.TRUE);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            SVNGanymedSession.purgeSessions();
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean addSession(Session session) {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            if (session != null) {
                ourSessionsMap.put(session, Boolean.TRUE);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            SVNGanymedSession.purgeSessions();
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean disposeSession(Session session) {
        block10: {
            Map map;
            boolean bl;
            SVNGanymedSession.lock(Thread.currentThread());
            try {
                if (session == null) break block10;
                bl = ourSessionsMap.remove(session) != null;
                Object var3_2 = null;
                map = ourSessionsMap;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                Map map2 = ourSessionsMap;
                synchronized (map2) {
                    ourSessionsMap.notifyAll();
                }
                SVNGanymedSession.unlock();
                throw throwable;
            }
            synchronized (map) {
                ourSessionsMap.notifyAll();
            }
            SVNGanymedSession.unlock();
            return bl;
        }
        Object var3_3 = null;
        Map map = ourSessionsMap;
        synchronized (map) {
            ourSessionsMap.notifyAll();
        }
        SVNGanymedSession.unlock();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeSession(Session session) {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            if (session != null && ourSessionsMap.containsKey(session)) {
                ourSessionsMap.put(session, Boolean.FALSE);
            }
        }
        finally {
            SVNGanymedSession.purgeSessions();
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidPrivateKey(File privateKey, String passphrase) {
        if (!(privateKey.exists() && privateKey.isFile() && privateKey.canRead())) {
            return false;
        }
        BufferedReader reader = null;
        StringWriter buffer = new StringWriter();
        try {
            int ch;
            reader = new BufferedReader(new FileReader(privateKey));
            while ((ch = ((Reader)reader).read()) >= 0) {
                buffer.write(ch);
            }
            SVNFileUtil.closeFile(reader);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SVNFileUtil.closeFile(reader);
        }
        char[] key = buffer.toString().toCharArray();
        try {
            PEMDecoder.decode((char[])key, (String)passphrase);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            Iterator e = ourConnectionsPool.values().iterator();
            while (e.hasNext()) {
                Connection connection = (Connection)e.next();
                SVNGanymedSession.doCloseConnection(connection);
            }
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeConnection(Connection connection) {
        SVNGanymedSession.lock(Thread.currentThread());
        try {
            SVNGanymedSession.doCloseConnection(connection);
        }
        finally {
            SVNGanymedSession.unlock();
        }
    }

    private static void doCloseConnection(Connection connection) {
        if (connection != null) {
            connection.close();
            if (!SVNGanymedSession.isUsePersistentConnection()) {
                return;
            }
            Iterator connections = ourConnectionsPool.entrySet().iterator();
            while (connections.hasNext()) {
                Map.Entry current = connections.next();
                if (current.getValue() != connection) continue;
                connections.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lock(Object requestor) {
        Map map = ourConnectionsPool;
        synchronized (map) {
            while (ourRequestor != null && ourRequestor != requestor) {
                try {
                    ourConnectionsPool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ourRequestor = requestor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlock() {
        Map map = ourConnectionsPool;
        synchronized (map) {
            ourRequestor = null;
            ourConnectionsPool.notifyAll();
        }
    }

    public static boolean isUsePersistentConnection() {
        return ourIsUsePersistentConnection;
    }

    public static void setUsePersistentConnection(boolean usePersistent) {
        ourIsUsePersistentConnection = usePersistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForFreeChannel() {
        Map map = ourSessionsMap;
        synchronized (map) {
            try {
                ourSessionsMap.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        ourSessionsMap = new Hashtable();
        String persistent = System.getProperty("svnkit.ssh2.persistent", System.getProperty("javasvn.ssh2.persistent", Boolean.TRUE.toString()));
        ourIsUsePersistentConnection = Boolean.TRUE.toString().equals(persistent);
    }
}

