/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

public class FSRevisionRoot
extends FSRoot {
    private long myRevision;
    private long myRootOffset;
    private long myChangesOffset;

    public FSRevisionRoot(FSFS owner, long revision) {
        super(owner);
        this.myRevision = revision;
        this.myRootOffset = -1L;
        this.myChangesOffset = -1L;
    }

    public long getRevision() {
        return this.myRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getChangedPaths() throws SVNException {
        FSFile file = this.getOwner().getRevisionFile(this.getRevision());
        this.loadOffsets(file);
        try {
            file.seek(this.myChangesOffset);
            Map map = this.fetchAllChanges(file, true);
            return map;
        }
        finally {
            file.close();
        }
    }

    public FSCopyInheritance getCopyInheritance(FSParentPath child) throws SVNException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSRevisionNode getRootRevisionNode() throws SVNException {
        if (this.myRootRevisionNode == null) {
            FSFile file = this.getOwner().getRevisionFile(this.getRevision());
            try {
                this.loadOffsets(file);
                file.seek(this.myRootOffset);
                Map headers = file.readHeader();
                this.myRootRevisionNode = FSRevisionNode.fromMap(headers);
            }
            finally {
                file.close();
            }
        }
        return this.myRootRevisionNode;
    }

    private void loadOffsets(FSFile file) throws SVNException {
        if (this.myRootOffset >= 0L) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(64);
        file.seek(file.size() - 64L);
        try {
            file.read(buffer);
        }
        catch (IOException e) {
            // empty catch block
        }
        buffer.flip();
        if (buffer.get(buffer.limit() - 1) != 10) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Revision file lacks trailing newline");
            SVNErrorManager.error(err);
        }
        int spaceIndex = -1;
        int eolIndex = -1;
        for (int i = buffer.limit() - 2; i >= 0; --i) {
            byte b = buffer.get(i);
            if (b == 32 && spaceIndex < 0) {
                spaceIndex = i;
                continue;
            }
            if (b != 10 || eolIndex >= 0) continue;
            eolIndex = i;
            break;
        }
        if (eolIndex < 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file longer than 64 characters");
            SVNErrorManager.error(err);
        }
        if (spaceIndex < 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing space");
            SVNErrorManager.error(err);
        }
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        try {
            buffer.limit(buffer.limit() - 1);
            buffer.position(spaceIndex + 1);
            String line = decoder.decode(buffer).toString();
            this.myChangesOffset = Long.parseLong(line);
            buffer.limit(spaceIndex);
            buffer.position(eolIndex + 1);
            line = decoder.decode(buffer).toString();
            this.myRootOffset = Long.parseLong(line);
        }
        catch (NumberFormatException nfe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing changes and root offsets");
            SVNErrorManager.error(err, nfe);
        }
        catch (CharacterCodingException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Final line in revision file missing changes and root offsets");
            SVNErrorManager.error(err, e);
        }
    }
}

