/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.format;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.tinylog.Level;
import org.tinylog.format.AbstractMessageFormatter;
import org.tinylog.provider.InternalLogger;

public class AdvancedMessageFormatter
extends AbstractMessageFormatter {
    private final DecimalFormatSymbols symbols;
    private final boolean escape;

    public AdvancedMessageFormatter(Locale locale, boolean escape) {
        this.symbols = new DecimalFormatSymbols(locale);
        this.escape = escape;
    }

    @Override
    public String format(String message, Object[] arguments) {
        int length = message.length();
        StringBuilder builder = new StringBuilder(length + 32);
        StringBuilder buffer = new StringBuilder(length + 32);
        StringBuilder current = builder;
        int argumentIndex = 0;
        int openingTickIndex = -1;
        int openingCurlyBrackets = 0;
        for (int index = 0; index < length; ++index) {
            char character = message.charAt(index);
            if (this.escape && character == '\'' && index + 1 < length && openingCurlyBrackets == 0) {
                if (message.charAt(index + 1) == '\'') {
                    current.append('\'');
                    ++index;
                    continue;
                }
                openingTickIndex = openingTickIndex < 0 ? index : -1;
                continue;
            }
            if (character == '{' && index + 1 < length && argumentIndex < arguments.length && openingTickIndex < 0) {
                if (openingCurlyBrackets++ == 0) {
                    current = buffer;
                    continue;
                }
                current.append(character);
                continue;
            }
            if (character == '}' && openingCurlyBrackets > 0 && openingTickIndex < 0) {
                if (--openingCurlyBrackets == 0) {
                    Object argument = AdvancedMessageFormatter.resolve(arguments[argumentIndex++]);
                    if (buffer.length() == 0) {
                        builder.append(argument);
                    } else {
                        builder.append(this.format(buffer.toString(), argument));
                        buffer.setLength(0);
                    }
                    buffer.setLength(0);
                    current = builder;
                    continue;
                }
                current.append(character);
                continue;
            }
            current.append(character);
        }
        if (buffer.length() > 0) {
            builder.append('{');
            builder.append((CharSequence)buffer);
        }
        if (openingTickIndex >= 0) {
            builder.insert(openingTickIndex, '\'');
        }
        return builder.toString();
    }

    private String format(String pattern, Object argument) {
        try {
            return this.getFormatter(pattern, argument).format(argument);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.WARN, "Illegal argument '" + String.valueOf(argument) + "' for pattern '" + pattern + "'");
            return String.valueOf(argument);
        }
    }

    private Format getFormatter(String pattern, Object argument) {
        if (pattern.indexOf(124) != -1) {
            int start = pattern.indexOf(123);
            if (start >= 0 && start < pattern.lastIndexOf(125)) {
                return new ChoiceFormat(this.format(pattern, new Object[]{argument}));
            }
            return new ChoiceFormat(pattern);
        }
        return new DecimalFormat(pattern, this.symbols);
    }
}

