/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SpringSecurityUtils {
    public static void checkUserValidity(UserDetails user) throws AccountExpiredException, CredentialsExpiredException, DisabledException, LockedException {
        if (!user.isAccountNonLocked()) {
            throw new LockedException("Account for user '" + user + "' is locked");
        }
        if (!user.isEnabled()) {
            throw new DisabledException("User '" + user + "' is disabled");
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException("Account for user '" + user + "' has expired");
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException("Credentials for user '" + user + "' have expired");
        }
    }
}

