/**
 * Top-level package for the {@code spring-webflux} module that contains
 * {@link org.springframework.web.reactive.DispatcherHandler}, the main entry
 * point for WebFlux server endpoint processing including key contracts used to
 * map requests to handlers, invoke them, and process the result.
 *
 * <p>The module provides two programming models for reactive server endpoints.
 * One based on annotated {@code @Controller}'s and another based on functional
 * routing and handling. The module also contains a functional, reactive
 * {@code WebClient} as well as client and server, reactive WebSocket support.
 */
@NullMarked
package org.springframework.web.reactive;

import org.jspecify.annotations.NullMarked;
