/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageReaderArgumentResolver;
import org.springframework.web.server.MissingRequestValueException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RequestPartMethodArgumentResolver
extends AbstractMessageReaderArgumentResolver {
    public RequestPartMethodArgumentResolver(List<HttpMessageReader<?>> readers, ReactiveAdapterRegistry registry) {
        super(readers, registry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestPart.class)) return true;
        if (!this.checkParameterType(parameter, Part.class::isAssignableFrom)) return false;
        return true;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange2) {
        RequestPart requestPart = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        boolean isRequired = requestPart == null || requestPart.required();
        Class paramType = parameter.getParameterType();
        Flux<Part> partValues = this.getPartValues(parameter, requestPart, isRequired, exchange2);
        if (Part.class.isAssignableFrom(paramType)) {
            return partValues.next().cast(Object.class);
        }
        if (Collection.class.isAssignableFrom(paramType) || List.class.isAssignableFrom(paramType)) {
            MethodParameter elementType = parameter.nested();
            if (Part.class.isAssignableFrom(elementType.getNestedParameterType())) {
                return partValues.collectList().cast(Object.class);
            }
            return partValues.next().flatMap(part -> this.decode((Part)part, parameter, bindingContext, exchange2, isRequired)).defaultIfEmpty(Collections.emptyList());
        }
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(paramType);
        if (adapter == null) {
            return partValues.next().flatMap(part -> this.decode((Part)part, parameter, bindingContext, exchange2, isRequired));
        }
        MethodParameter elementType = parameter.nested();
        if (Part.class.isAssignableFrom(elementType.getNestedParameterType())) {
            return Mono.just((Object)adapter.fromPublisher(partValues));
        }
        Flux flux = partValues.flatMap(part -> this.decode((Part)part, elementType, bindingContext, exchange2, isRequired));
        return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
    }

    public Flux<Part> getPartValues(MethodParameter parameter, @Nullable RequestPart requestPart, boolean isRequired, ServerWebExchange exchange2) {
        String name = this.getPartName(parameter, requestPart);
        return exchange2.getMultipartData().flatMapIterable(map -> {
            List list = (List)map.get((Object)name);
            if (CollectionUtils.isEmpty((Collection)list)) {
                if (isRequired) {
                    throw new MissingRequestValueException(name, parameter.getParameterType(), "request part", parameter);
                }
                return Collections.emptyList();
            }
            return list;
        });
    }

    private String getPartName(MethodParameter methodParam, @Nullable RequestPart requestPart) {
        String name = null;
        if (requestPart != null) {
            name = requestPart.name();
        }
        if (!StringUtils.hasLength(name)) {
            name = methodParam.getParameterName();
        }
        if (!StringUtils.hasLength((String)name)) {
            throw new IllegalArgumentException("Request part name for argument type [" + methodParam.getNestedParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
        }
        return name;
    }

    private <T> Mono<T> decode(Part part, MethodParameter elementType, BindingContext bindingContext, ServerWebExchange exchange2, boolean isRequired) {
        PartServerHttpRequest partRequest = new PartServerHttpRequest(exchange2.getRequest(), part);
        ServerWebExchange partExchange = exchange2.mutate().request((ServerHttpRequest)partRequest).build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(exchange2.getLogPrefix() + "Decoding part '" + part.name() + "'"));
        }
        return this.readBody(elementType, isRequired, bindingContext, partExchange);
    }

    private static class PartServerHttpRequest
    extends ServerHttpRequestDecorator {
        private final Part part;

        public PartServerHttpRequest(ServerHttpRequest delegate, Part part) {
            super(delegate);
            this.part = part;
        }

        public HttpHeaders getHeaders() {
            return this.part.headers();
        }

        public Flux<DataBuffer> getBody() {
            return this.part.content();
        }
    }
}

