/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class LiteralPathElement
extends PathElement {
    private final String text;
    private final int len;
    private final boolean caseSensitive;

    public LiteralPathElement(int pos, char[] literalText, boolean caseSensitive, char separator) {
        super(pos, separator);
        this.len = literalText.length;
        this.caseSensitive = caseSensitive;
        this.text = new String(literalText);
    }

    @Override
    public boolean matches(int pathIndex, PathPattern.MatchingContext matchingContext) {
        if (pathIndex >= matchingContext.pathLength) {
            return false;
        }
        PathContainer.Element element = matchingContext.pathElements.get(pathIndex);
        if (!(element instanceof PathContainer.PathSegment)) {
            return false;
        }
        PathContainer.PathSegment pathSegment = (PathContainer.PathSegment)element;
        String value = pathSegment.valueToMatch();
        if (value.length() != this.len) {
            return false;
        }
        if (this.caseSensitive ? !this.text.equals(value) : !this.text.equalsIgnoreCase(value)) {
            return false;
        }
        ++pathIndex;
        if (this.isNoMorePattern()) {
            if (matchingContext.determineRemainingPath) {
                matchingContext.remainingPathIndex = pathIndex;
                return true;
            }
            return pathIndex == matchingContext.pathLength;
        }
        return this.next != null && this.next.matches(pathIndex, matchingContext);
    }

    @Override
    public int getNormalizedLength() {
        return this.len;
    }

    @Override
    public char[] getChars() {
        return this.text.toCharArray();
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public String toString() {
        return "Literal(" + this.text + ")";
    }
}

