/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ContentDisposition {
    @Nullable
    private final String type;
    @Nullable
    private final String name;
    @Nullable
    private final String filename;
    @Nullable
    private final Charset charset;
    @Nullable
    private final Long size;
    @Nullable
    private final ZonedDateTime creationDate;
    @Nullable
    private final ZonedDateTime modificationDate;
    @Nullable
    private final ZonedDateTime readDate;

    private ContentDisposition(@Nullable String type, @Nullable String name, @Nullable String filename, @Nullable Charset charset, @Nullable Long size, @Nullable ZonedDateTime creationDate, @Nullable ZonedDateTime modificationDate, @Nullable ZonedDateTime readDate) {
        this.type = type;
        this.name = name;
        this.filename = filename;
        this.charset = charset;
        this.size = size;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.readDate = readDate;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getFilename() {
        return this.filename;
    }

    @Nullable
    public Charset getCharset() {
        return this.charset;
    }

    @Nullable
    public Long getSize() {
        return this.size;
    }

    @Nullable
    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    @Nullable
    public ZonedDateTime getModificationDate() {
        return this.modificationDate;
    }

    @Nullable
    public ZonedDateTime getReadDate() {
        return this.readDate;
    }

    public static Builder builder(String type) {
        return new BuilderImpl(type);
    }

    public static ContentDisposition empty() {
        return new ContentDisposition("", null, null, null, null, null, null, null);
    }

    public static ContentDisposition parse(String contentDisposition) {
        String[] parts = StringUtils.tokenizeToStringArray((String)contentDisposition, (String)";");
        Assert.isTrue((parts.length >= 1 ? 1 : 0) != 0, (String)"Content-Disposition header must not be empty");
        String type = parts[0];
        String name = null;
        String filename = null;
        Charset charset = null;
        Long size = null;
        ZonedDateTime creationDate = null;
        ZonedDateTime modificationDate = null;
        ZonedDateTime readDate = null;
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            int eqIndex = part.indexOf(61);
            if (eqIndex != -1) {
                String value;
                String attribute = part.substring(0, eqIndex);
                String string = value = part.startsWith("\"", eqIndex + 1) && part.endsWith("\"") ? part.substring(eqIndex + 2, part.length() - 1) : part.substring(eqIndex + 1, part.length());
                if (attribute.equals("name")) {
                    name = value;
                    continue;
                }
                if (attribute.equals("filename*")) {
                    filename = ContentDisposition.decodeHeaderFieldParam(value);
                    charset = Charset.forName(value.substring(0, value.indexOf("'")));
                    Assert.isTrue((StandardCharsets.UTF_8.equals(charset) || StandardCharsets.ISO_8859_1.equals(charset) ? 1 : 0) != 0, (String)"Charset should be UTF-8 or ISO-8859-1");
                    continue;
                }
                if (attribute.equals("filename") && filename == null) {
                    filename = value;
                    continue;
                }
                if (attribute.equals("size")) {
                    size = Long.parseLong(value);
                    continue;
                }
                if (attribute.equals("creation-date")) {
                    try {
                        creationDate = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                    }
                    catch (DateTimeParseException dateTimeParseException) {}
                    continue;
                }
                if (attribute.equals("modification-date")) {
                    try {
                        modificationDate = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                    }
                    catch (DateTimeParseException dateTimeParseException) {}
                    continue;
                }
                if (!attribute.equals("read-date")) continue;
                try {
                    readDate = ZonedDateTime.parse(value, DateTimeFormatter.RFC_1123_DATE_TIME);
                }
                catch (DateTimeParseException dateTimeParseException) {}
                continue;
            }
            throw new IllegalArgumentException("Invalid content disposition format");
        }
        return new ContentDisposition(type, name, filename, charset, size, creationDate, modificationDate, readDate);
    }

    private static String decodeHeaderFieldParam(String input) {
        Assert.notNull((Object)input, (String)"Input String should not be null");
        int firstQuoteIndex = input.indexOf("'");
        int secondQuoteIndex = input.indexOf("'", firstQuoteIndex + 1);
        if (firstQuoteIndex == -1 || secondQuoteIndex == -1) {
            return input;
        }
        Charset charset = Charset.forName(input.substring(0, firstQuoteIndex));
        Assert.isTrue((StandardCharsets.UTF_8.equals(charset) || StandardCharsets.ISO_8859_1.equals(charset) ? 1 : 0) != 0, (String)"Charset should be UTF-8 or ISO-8859-1");
        byte[] value = input.substring(secondQuoteIndex + 1, input.length()).getBytes(charset);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int index = 0;
        while (index < value.length) {
            byte b = value[index];
            if (ContentDisposition.isRFC5987AttrChar(b)) {
                bos.write((char)b);
                ++index;
                continue;
            }
            if (b == 37) {
                char[] array = new char[]{(char)value[index + 1], (char)value[index + 2]};
                bos.write(Integer.parseInt(String.valueOf(array), 16));
                index += 3;
                continue;
            }
            throw new IllegalArgumentException("Invalid header field parameter format (as defined in RFC 5987)");
        }
        return new String(bos.toByteArray(), charset);
    }

    private static boolean isRFC5987AttrChar(byte c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 33 || c == 35 || c == 36 || c == 38 || c == 43 || c == 45 || c == 46 || c == 94 || c == 95 || c == 96 || c == 124 || c == 126;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentDisposition)) {
            return false;
        }
        ContentDisposition otherCd = (ContentDisposition)other;
        return ObjectUtils.nullSafeEquals((Object)this.type, (Object)otherCd.type) && ObjectUtils.nullSafeEquals((Object)this.name, (Object)otherCd.name) && ObjectUtils.nullSafeEquals((Object)this.filename, (Object)otherCd.filename) && ObjectUtils.nullSafeEquals((Object)this.charset, (Object)otherCd.charset) && ObjectUtils.nullSafeEquals((Object)this.size, (Object)otherCd.size) && ObjectUtils.nullSafeEquals((Object)this.creationDate, (Object)otherCd.creationDate) && ObjectUtils.nullSafeEquals((Object)this.modificationDate, (Object)otherCd.modificationDate) && ObjectUtils.nullSafeEquals((Object)this.readDate, (Object)otherCd.readDate);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.type);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.filename);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.charset);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.size);
        result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 31 * result + (this.modificationDate != null ? this.modificationDate.hashCode() : 0);
        result = 31 * result + (this.readDate != null ? this.readDate.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(this.type);
        }
        if (this.name != null) {
            sb.append("; name=\"");
            sb.append(this.name).append('\"');
        }
        if (this.filename != null) {
            if (this.charset == null || StandardCharsets.US_ASCII.equals(this.charset)) {
                sb.append("; filename=\"");
                sb.append(this.filename).append('\"');
            } else {
                sb.append("; filename*=");
                sb.append(ContentDisposition.encodeHeaderFieldParam(this.filename, this.charset));
            }
        }
        if (this.size != null) {
            sb.append("; size=");
            sb.append(this.size);
        }
        if (this.creationDate != null) {
            sb.append("; creation-date=\"");
            sb.append(DateTimeFormatter.RFC_1123_DATE_TIME.format(this.creationDate));
            sb.append('\"');
        }
        if (this.modificationDate != null) {
            sb.append("; modification-date=\"");
            sb.append(DateTimeFormatter.RFC_1123_DATE_TIME.format(this.modificationDate));
            sb.append('\"');
        }
        if (this.readDate != null) {
            sb.append("; read-date=\"");
            sb.append(DateTimeFormatter.RFC_1123_DATE_TIME.format(this.readDate));
            sb.append('\"');
        }
        return sb.toString();
    }

    private static String encodeHeaderFieldParam(String input, Charset charset) {
        Assert.notNull((Object)input, (String)"Input String should not be null");
        Assert.notNull((Object)charset, (String)"Charset should not be null");
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return input;
        }
        Assert.isTrue((StandardCharsets.UTF_8.equals(charset) || StandardCharsets.ISO_8859_1.equals(charset) ? 1 : 0) != 0, (String)"Charset should be UTF-8 or ISO-8859-1");
        byte[] source = input.getBytes(charset);
        int len = source.length;
        StringBuilder sb = new StringBuilder(len << 1);
        sb.append(charset.name());
        sb.append("''");
        for (byte b : source) {
            if (ContentDisposition.isRFC5987AttrChar(b)) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            sb.append(hex1);
            sb.append(hex2);
        }
        return sb.toString();
    }

    private static class BuilderImpl
    implements Builder {
        private String type;
        @Nullable
        private String name;
        @Nullable
        private String filename;
        @Nullable
        private Charset charset;
        @Nullable
        private Long size;
        @Nullable
        private ZonedDateTime creationDate;
        @Nullable
        private ZonedDateTime modificationDate;
        @Nullable
        private ZonedDateTime readDate;

        public BuilderImpl(String type) {
            Assert.hasText((String)type, (String)"'type' must not be not empty");
            this.type = type;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        @Override
        public Builder filename(String filename, Charset charset) {
            this.filename = filename;
            this.charset = charset;
            return this;
        }

        @Override
        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        @Override
        public Builder creationDate(ZonedDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public Builder modificationDate(ZonedDateTime modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        @Override
        public Builder readDate(ZonedDateTime readDate) {
            this.readDate = readDate;
            return this;
        }

        @Override
        public ContentDisposition build() {
            return new ContentDisposition(this.type, this.name, this.filename, this.charset, this.size, this.creationDate, this.modificationDate, this.readDate);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder filename(String var1);

        public Builder filename(String var1, Charset var2);

        public Builder size(Long var1);

        public Builder creationDate(ZonedDateTime var1);

        public Builder modificationDate(ZonedDateTime var1);

        public Builder readDate(ZonedDateTime var1);

        public ContentDisposition build();
    }
}

